'''
Map conv shapes to the AIE-4 dataflow architecture.
External facing functions are documented below.

    generate_mappings - enumerate all possible ways to map a conv shape
    onto the compute array and sort them in order of descending projected
    latency (fastest mappings first)
'''

from scheduler.common import (
    BaseDims,
    core_to_split,
)

dims = BaseDims(
    N=1,
    Yi=0,
    Xi=0,
    Ci=0,
    Yo=0,
    Xo=0,
    Co=0,
    Yis=0,
    Xis=0,
    Cos=0,
    Ky=0,
    Kx=0,
    Sy=0,
    Sx=0,
    Py=0,
    Px=0,
    N_split=1,
    Y_split=1,
    X_split=2,
    Co_split=6,
    aie_cols=3,
    aie_rows=4,
)
for col in range(dims.aie_cols):
    for row in range(dims.aie_rows):
        print(f"Core {col},{row} split_idx: {core_to_split(dims, col, row)}")
