import importlib.util
import os

config_path = os.path.join(os.path.dirname(__file__), "config.py")
spec = importlib.util.spec_from_file_location("waic_config", config_path)
waic_config = importlib.util.module_from_spec(spec)
spec.loader.exec_module(waic_config)

#  Ensure 'type' always exists
if not hasattr(waic_config, "type"):
    waic_config.mode = "dev"  # Default fallback
