# Test Script Specification: op_test

**Location:**

dataflow directory

**Description:**

The op_test script is designed to run various tests on shapes. It can select shapes based on the provided arguments or run regression tests for all operations if no arguments are given. Additionally, it can run stress tests for all operations or selected operations.
Arguments:
-m model_shapes: Select shapes from a predefined model.
-r random_shapes: Select random shapes from op_list.json.
-op_type <operation>: Specify the operation type (e.g., -conv, -concat) to run tests for a specific operation.
-stress: Run stress tests for all operations or the specified operation.
  
**Behavior:**
1. Model Shapes (-m model_shapes):
When the -m argument is provided, the script will load shapes from a predefined model.
Example usage: python op_test.py -m model_shapes
2. Random Shapes (-r random_shapes):
When the -r argument is provided, the script will load random shapes from op_list.json.
Example usage: python op_test.py -r random_shapes
3. No Arguments:
If the script is run without any arguments, it will perform a regression test for all operations.
Example usage: python op_test.py
4. Operation Type (-op_type <operation>):
When the -op_type argument is provided, the script will run tests for the specified operation type.
Example usage: python op_test.py -op_type conv
5. Stress Test (-stress):
When the -stress argument is provided, the script will run stress tests for all operations or the specified operation.
Example usage: python op_test.py -stress
Example usage with operation type: python op_test.py -stress -op_type conv
Files:
- op_test.py: The main script to run the tests.
- op_list.json: A JSON file containing different shapes for each operation.
Example Usage:
python op_test.py -m /path/to/model_shapes.json
python op_test.py -r (op_list.json is default file)
python op_test.py -r -op_type conv
python op_test.py -stress
python op_test.py -stress -op_type conv


Here's a clean and concise README section for your `compare_dma_hpp_files.py` script:

---

## DMA Header File Comparator - `compare_dma_hpp_files.py`

This script compares `dma.hpp` files across matching subfolders in two directory trees (e.g., golden reference vs test output). It reports which subfolders contain differing files.

### Usage

```bash
python compare_dma_hpp_files.py \
    --golden_dir /path/to/golden/reference \
    --test_dir /path/to/test/output
```

### Arguments

| Argument       | Type  | Description                                 |
| -------------- | ----- | ------------------------------------------- |
| `--golden_dir` | `str` | Path to the golden/reference root directory |
| `--test_dir`   | `str` | Path to the test/output root directory      |

### Example

```bash
python compare_dma_hpp_files.py \
    --golden_dir /everest/ref/waic/dataflow/slice/test \
    --test_dir /everest/new/waic/dataflow/slice/test
```

### Output

For each subfolder under `--golden_dir`, if a corresponding `dma.hpp` file exists in both golden and test directories but differs in content, the script prints:

```
dma.hpp files differ in subfolder: <subfolder_name>
```

If all `dma.hpp` files match, no output is shown.

---

