import os
import filecmp
import argparse

def compare_dma_hpp_files(golden_dir, test_dir):
    for subfolder in os.listdir(golden_dir):
        input_subfolder = os.path.join(golden_dir, subfolder)
        output_subfolder = os.path.join(test_dir, subfolder)
        input_file = os.path.join(input_subfolder, "dma.hpp")
        output_file = os.path.join(output_subfolder, "dma.hpp")

        if os.path.isfile(input_file) and os.path.isfile(output_file):
            if not filecmp.cmp(input_file, output_file, shallow=False):
                print(f"dma.hpp files differ in subfolder: {subfolder}")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Compare dma.hpp files in subfolders.")
    parser.add_argument("--golden_dir", required=True, help="Path to the golden (reference) directory")
    parser.add_argument("--test_dir", required=True, help="Path to the test directory")

    args = parser.parse_args()
    compare_dma_hpp_files(args.golden_dir, args.test_dir)
