### Run shape:

## `concat_build.py` — Concat Shape Generator

This script builds concat shapes for a set of predefined input shapes, permutations, and configurations. You can run all shapes or select specific ones via command-line arguments.

### Usage

```bash
python concat_build.py \
    --backend <0|1> \
    [--qdq_mode <0|1|2|3>] \
    [--shape_index <int>] \
    [--save_bins <bool>]
```

### Arguments

| Argument        | Type  | Required | Description                                                                                                                     |
| --------------- | ----- | -------- | ------------------------------------------------------------------------------------------------------------------------------- |
| `--backend`     | `int` | No  | Backend mode:<br>• `0` = AIESIM<br>• `1` = TXN\_BIN (default: 0)                                                                             |
| `--qdq_mode`    | `int` | No       | QDQ behavior (default: `3`):<br>• `0` = Only Dequant<br>• `1` = Only Quant<br>• `2` = Both Quant and Dequant<br>• `3` = Neither |
| `--shape_index` | `int` | No       | Key of the target shape in the shape dictionary. If omitted, runs **all shapes**                                                |
| `--save_bins`   | `bool`  | No       | If provided, saves generated `.bin` files and `dma.hpp` output (default: False)                                                 |

### Examples

**Run all shapes with AIESIM and no QDQ:**

```bash
python concat_build.py --backend 0
```

**Run only shape #4 with TXN\_BIN and both Quant/Dequant enabled:**

```bash
python concat_build.py --backend 1 --qdq_mode 2 --shape_index 4
```

**Run shape #3  with no QDQ and save binaries:**

```bash
python concat_build.py --backend 1 --shape_index 3 --save_bins True
```

---

Current Stress test by running the following command

```
python concat_stress_test.py
```





Additionally, the basic shapes should yield the following results:

![image](https://media.gitenterprise.xilinx.com/user/4567/files/2f4a5cf0-924b-408c-967a-393c54aa4434)

