# Guidelines to test your code before issuing a PR

1. Run the stress test using the following command. 
    ```
        python conv_stress_stest.py

        Note: To run only a16w8 or a8w8 shapes alone, please use the --dt flag with a16w8/a8w8 as a value.

    ```
   - the code should at least meet the pass rate on main branch
2. Run perf test using the following command. 
   - first step is to run 
   ```
    python conv_perf_regression_test.py -t {txn or sim} -dt {a16w8 or xint8 or a8w8}

   ```
    - the performance results of the benchmark shapes should be at least meeting that on the main branch.
    - The above command generates the tiling subvolume information and dumps the json into WAIC_Outputs directory and builds the bin files and execute them on HW.
    - The Argument -t should be followed by "txn" or "sim" either for HW execution or Simulation of the shapes.
    - The -dt argument must be followed by either "a16w8" or "xint8 or a8w8", depending on the convolution operation format. By default, it is set to "a16w8"
    - The -vcd argument enables profiling data generation during simulation. Additionally comment out the assert statement in conv_main.cpp and dwc_main.cpp.
    - The Argument -lsf will trigger the bin generation in lsf bjobs which helps in reducing the time taken for bin generation. For now, lsf enabled for HW only.
    - The Argument -HW_IP can be used to set the HW machine IP for execution
   

## More information on performance testing

- For better results make sure turbo mode is on in your board. You can open Administrator Command Prompt and run

```
xrt-smi.exe configure --pmode turbo

```
In `conv_perf_regression_test.py`  the `perf_testing` flag is set to `True`, therefore, XRT test will run for 1000 iterations (line 153).  

For manual run, after generating .bin and .xclbin files, copy xrt_flow_test_patch_datatype_debug.exe, xrt.ini, and dolphin_test_ver4.py from HW_requirements to WAIC_Outputs.

```
python dolphin_test_ver4.py --perf_testing

```

Results of this test are saved to a json file and output.xlsx in WAIC/WAIC_Outputs.

The latest results from the main branch, obtained using the HW machine with IP address 10.228.114.191, have been recorded in the Performance Tracker Excel file located at:
[view Excel Sheet](./Conv_performance_tracker.xlsx)

Here is the table of pass rate for the conv_stress test script across all kernel sizes

| Kernel | DataType | Total shapes | Tiler pass rate w/ sched constraints | Scheduler pass rate | Tiler pass rate w/o sched constraints |
|--------|----------|--------------|--------------------------------------|---------------------|---------------------------------------|
| 3x3    | a16w8    | 38576        | 54.1                                 | 44.8                | 100                                   |
| 5x5    | a16w8    | 560          | 100                                  | 96.6                | 100                                   |
| 7x7    | a16w8    | 560          | 98.7                                 | 95.7                | 98.7                                  |
| 9x9    | a16w8    | 560          | 93.7                                 | 90.5                | 96.2                                  |
| 3x3    | a8w8     | 490          | 100                                  | 100                 | 100                                   |
| 5x5    | a8w8     | 490          | 100                                  | 100                 | 100                                   |
| 7x7    | a8w8     | 490          | 100                                  | 100                 | 100                                   |
| 9x9    | a8w8     | 490          | 100                                  | 98.7                | 100                                   |

Note: Commands used to generate pass rates
- Command for Tiler pass rate w/ sched constraints
```
bsub -R "select[osdistro=rhel && (osver=ws8)]" -R "rusage[mem=65536]" -e tiler_pass_w_sched_e.txt -o tiler_pass_w_sched_o.txt 'python dataflow/conv/conv_stress_test.py -j256 --tiler-only'
```
- Command for Scheduler pass rate
```
bsub -R "select[osdistro=rhel && (osver=ws8)]" -R "rusage[mem=65536]" -e sched_pass_e.txt -o sched_pass_o.txt 'python dataflow/conv/conv_stress_test.py -j256'
```
- Command for Tiler pass rate w/o sched constraints
```
bsub -R "select[osdistro=rhel && (osver=ws8)]" -R "rusage[mem=65536]" -e tiler_pass_wo_sched_e.txt -o tiler_pass_wo_sched_o.txt 'python dataflow/conv/conv_stress_test.py -j256 --tiler-only --disable_scheduler_constraints'
```
