import subprocess
import shutil
import os
CURRDIR = os.path.dirname(os.path.abspath(__file__))

def verbose_run(command: str):
    print(command)
    subprocess.run(command, shell=True)

def main():

    byte_string = subprocess.check_output(['git', 'rev-parse', 'HEAD'])
    cur_version = byte_string.decode('utf-8')[0:7]
    
    sdxl_mha_shapes = [
             "MHA_1",
             "MHA_2",
             #"MHA_3"
            ]
    shape_dirs = [
         "psr_mha_3p0_20x256x64x256x64",
         "psr_mha_3p0_10x1024x64x1024x64",
         #"psr_mha_3p0_10x4096x64x4096x64",
    ]
    dst_dir = "./psr_mha_3p0_build_"+cur_version+"/"
    
    shape_full_bin_dir = []
    for shape_dir in shape_dirs:
        shape_full_bin_dir.append(dst_dir+shape_dir)
        os.makedirs(shape_full_bin_dir[-1], exist_ok=True)

    build_files = ('ifm.bin', 'wgt.bin', 'ofm.bin',
                    'txn.bin', 'param.bin', 'ctrl.bin', 'patch.json')

    for count, shape in enumerate(sdxl_mha_shapes):
        verbose_run("make all TXN=1 "+shape+"=1")
        for file in build_files:
        
            src_file = os.path.join(CURRDIR, file) 
            target_file = "ctrl_meta.json" if(file=='patch.json') else file
            dst_file = os.path.join(shape_full_bin_dir[count], target_file)
            shutil.copy(src_file, dst_file)
    
    xclbin_path = "./hw_package/"
    shutil.copy(xclbin_path+"8x4.xclbin", dst_dir)
    
    #xrt_exe_path = "./"
    #shutil.copy(xrt_exe_path+"xrt_flow_test_new_di_patch_1.exe", dst_dir)
    #shutil.copy(xrt_exe_path+"xrt_flow_test_no_di_patch_1.exe", dst_dir)

if __name__ == "__main__":
	main()
