#pragma once
#include <string>
#include <fstream>
#include <sstream>
#include <assert.h>
#include <stdlib.h>
#include <iostream>
#include <cmath>

template<typename inT>
void read_data_file(std::string filename, inT *in_ptr){
    std::fstream file;
    file.open(filename, std::ios::in);
    if(file.is_open()){
        printf("Opened file: %s for read \n", filename.c_str());
        int count = 0;
        std::string line;
        while(file){
            std::getline(file, line);
            std::istringstream ss(line);
            int64_t num;
            while(ss >> num)
            {
                *(in_ptr + count) = (inT)(num);
                count++;
            }
        }
        printf("Read %d values \n", count);
    } else {
        printf("Unable to open file: %s for read \n", filename.c_str());
      abort();
    }
}

template<typename inT>
void read_data_file_fp(std::string filename, inT *in_ptr){
    std::fstream file;
    file.open(filename, std::ios::in);
    if(file.is_open()){
        printf("Opened file: %s for read \n", filename.c_str());
        int count = 0;
        std::string line;
        while(file){
            std::getline(file, line);
            std::istringstream ss(line);
            float num;
            while(ss >> num)
            {
                *(in_ptr + count) = (inT)(num);
                count++;
            }
        }
        printf("Read %d values \n", count);
    } else {
        printf("Unable to open file: %s for read \n", filename.c_str());
      abort();
    }
}
void read_bin_file(std::string filename, char* data)
{
    size_t size = 0;
    printf("Reading bin file: %s \n", filename.c_str());
    std::ifstream infile(filename, std::ios::binary);
	if(!infile){
		printf("Unable to open file: %s !!\n", filename.c_str());
		printf("Aborting...");
		exit(0);
	}
	infile.seekg(0, std::ios::end);
	size = infile.tellg();
	infile.seekg(0, std::ios::beg);
	infile.read(data, size);
	infile.close();
    printf("Read %ld Bytes \n", size);
}

void read_bin_file(std::string filename, char* data, size_t size)
{
    std::fstream file;
    file.open(filename, std::ios::in | std::ios::binary);
    file.read(data, size);
}

void write_bin_file(std::string filename, char* data, size_t size)
{
    std::fstream file;
    file.open(filename, std::ios::out | std::ios::binary);
    file.write(data, size);
}
