import json
from typing import List, Dict, Any, Optional

class CoreTileParams:
    def __init__(self, subvols: Dict[str, List[int]], iters: Dict[str, List[int]]):
        self.subvols = subvols
        self.iters = iters

class MemTileParams:
    def __init__(self, subvols: Dict[str, List[int]], iters: Dict[str, List[int]], sizes: Dict[str, int]):
        self.subvols = subvols
        self.iters = iters
        self.sizes = sizes

class ShimTileParams:
    def __init__(self, subvols: Dict[str, List[int]], sizes: Dict[str, int]):
        self.subvols = subvols
        self.sizes = sizes

class LayerInfo:
    def __init__(self, op_type: str, attributes: Dict[str, List[int]],
                 inputs, outputs,
                 wgt_datatype: str,
                 wgt1_datatype: str,
                 wgt_bytes: int,
                 wgt1_bytes: int,
                 qdq_symmetry: Optional[int],
                 coeff_shape: Optional[List[int]],
                 in_act_residency : str, out_act_residency : str, Frequency : int,
                 nodenames : List[str], in_v_shape : List[int], in_v_datatype : str, in_v_bytes : int,
                 in_q_shape: List[int], in_k_shape: List[int], 
                 out_ofm_shape: List[int], in_q_datatype: str, 
                 in_k_datatype: str, out_ofm_datatype: str, in_q_bytes: int, in_k_bytes: int, out_ofm_bytes: int, 
                 orig_op_type: str):
        self.nodenames = nodenames
        self.op_type = op_type
        self.attributes = attributes
        self.inputs = inputs
        self.outputs = outputs
        self.wgt_datatype = wgt_datatype
        self.wgt1_datatype = wgt1_datatype
        self.wgt_bytes = wgt_bytes
        self.wgt1_bytes = wgt1_bytes
        self.qdq_symmetry = qdq_symmetry
        self.coeff_shape = coeff_shape
        self.in_act_residency = in_act_residency
        self.out_act_residency = out_act_residency
        self.Frequency = Frequency
        self.nodenames = nodenames
        self.in_v_shape = in_v_shape
        self.in_v_datatype = in_v_datatype
        self.in_v_bytes = in_v_bytes
        self.in_q_shape = in_q_shape
        self.in_k_shape = in_k_shape
        self.out_ofm_shape = out_ofm_shape
        self.in_q_datatype = in_q_datatype
        self.in_k_datatype = in_k_datatype
        self.out_ofm_datatype = out_ofm_datatype
        self.in_q_bytes = in_q_bytes
        self.in_k_bytes = in_k_bytes
        self.out_ofm_bytes = out_ofm_bytes
        self.orig_op_type = orig_op_type

class OverlayInfo:
    def __init__(self, overlay: str, mode: str, shape: List[int]):
        self.overlay = overlay
        self.mode = mode
        self.shape = shape

class KernelInfo:
    def __init__(self, placement_constraints: Dict[str, Dict[str, int]]):
        self.placement_constraints = placement_constraints

class LayerPadding:
    def __init__(self, ifm: List[List[int]], ofm: List[List[int]], wgt: List[List[int]]):
        self.ifm = ifm
        self.wgt = wgt
        self.ofm = ofm

class Parameters:
    def __init__(self, core_tile_params: CoreTileParams, mem_tile_params: MemTileParams, shim_tile_params: ShimTileParams, 
                 scheduling: Dict[str, Any], layer_info: LayerInfo, overlay_info: OverlayInfo, kernel_info: KernelInfo, 
                 layer_padding: LayerPadding):
        self.core_tile_params = core_tile_params
        self.mem_tile_params = mem_tile_params
        self.shim_tile_params = shim_tile_params
        self.scheduling = scheduling
        self.layer_info = layer_info
        self.overlay_info = overlay_info
        self.kernel_info = kernel_info
        self.layer_padding = layer_padding

def deserialize_parameters(json_path: str) -> Parameters:
    try:
        with open(json_path, 'r') as file:
            data = json.load(file)
        
        core_tile_params = CoreTileParams(**data['core_tile_params'])
        mem_tile_params = MemTileParams(**data['mem_tile_params'])
        shim_tile_params = ShimTileParams(**data['shim_tile_params'])
        layer_info = LayerInfo(**data['layer_info'])
        overlay_info = OverlayInfo(**data['overlay_info'])
        kernel_info = KernelInfo(**data['kernel_info'])
        layer_padding = LayerPadding(**data['layer_padding'])
        
        return Parameters(core_tile_params, mem_tile_params, shim_tile_params, data['scheduling'], layer_info, overlay_info, kernel_info, layer_padding)
    except (json.JSONDecodeError, KeyError, TypeError) as e:
        print(f"Error deserializing parameters: {e}")
        return None