## `q_dq_build.py` — QDQ Shape Generator

This script builds qdq shapes for a set of predefined input shapes. You can run all shapes or select specific ones via command-line arguments.

### Usage

```bash
python q_dq_build.py \
    --backend <0|1> \
    [--qdq_mode <0|1|2|3>] \
    [--shape_index <int>] \
    [--save_bins <bool>] \
    [--dtype <8|16>]
```
### Arguments

| Argument        | Type  | Required | Description                                                                                                                     |
| --------------- | ----- | -------- | ------------------------------------------------------------------------------------------------------------------------------- |
| `--backend`     | `int` | No  | Backend mode:<br>• `0` = AIESIM<br>• `1` = TXN\_BIN (default: 0)                                                                           |
| `--qdq_mode`    | `int` | No       | QDQ behavior:<br>• `0` = Only Dequant<br>• `1` = Only Quant<br>• `2` = Both Quant and Dequant<br> If an invalid qdq mode is passed, then the build script will terminate |
| `--shape_index` | `int` | No       | Key of the target shape in the shape dictionary.                                               |
| `--save_bins`   | `bool`  | No       | If provided, saves generated `.bin` files and `dma.hpp` output (default: False). |
| `--dtype`   | `int`  | Yes       | The number of bits in the integer datatype involved in the operation. |

NOTE: If one of qdq_mode or shape_index is omitted, then all combinations of each shape with each possible qdq mode will be run.

For each 'YXC' shape, where each the number of bits in each element in the input tensor is `inputbits`, the number of bits in each element in the output tensor is `outputbits` and the operation being done (One of Dequant, Quant, or both) is `operation` the relevant binary files and dma.hpp will be placed within a folder of name `'qdq_Y_X_C_inputbits_outputbits_operation'`

### Examples

**Run all combinations of each shape with each QDQ mode on AIESIM, where the integer datatype is INT16**

```bash
python q_dq_build.py --backend 0 --dtype 16
```

**Run only shape #4 with TXN\_BIN and both Quant/Dequant enabled, where the integer datatype is INT8: INT8->BF16->INT8**

```bash
python q_dq_build.py --backend 1 --qdq_mode 2 --shape_index 4 --dtype 8
```

**Run shape #3 with Dequant mode and save binaries, where the integer datatype is INT16:**

```bash
python slice_build.py --backend 1 --qdq-mode 0 --shape_index 3 --save_bins True --dtype 16
```

## How to generate random binary files to test on Hardware


To generate random hardware binary files as defined in `q_dq_stress_test.py` including the following:

```
- ctrl.bin
- ifm.bin
- ofm.bin
- param.bin
- patch.json
- txn.bin
- wgt.bin
``` 


Run the following command to create the above associated files for random shapes. 
```
python q_dq_stress_test.py
```



The specific number of shapes generated can be controlled by editing the default value for the `max_shapes` parameter within the `generate_valid_shapes` function within `q_dq_stress_test.py`, or alternatively by providing the relevant argument to the function within `main`.


The folder that each shape will be placed in will follow the same format as when the save_bins flag is set to True when running q_dq_build.py, which is described in **Arguments**


# xclbin generation
To generate the associated xclbin files, navigate to the xclbin directory within dataflow and run the following command:

`python xclbin_build.py -o 8x4 -k run_combined_qdq -i super.hh,qdq/wrapper_qdq.cc -d {desired output folder}`

### Example
`python xclbin_build.py -o 8x4 -k run_combined_qdq -i super.hh,qdq/wrapper_qdq.cc -d qdq_test` (the files will be generated in the qdq_test folder)



## Current Test Results on Hardware
The following is the current hardware results for the input shapes defined in q_dq_build.py
### INT8 Dequant: INT8 -> BF16
<img width="736" alt="qdq_int8_bf16_dequant" src="https://media.gitenterprise.xilinx.com/user/3741/files/66956368-df9e-49f8-8f46-3a422d29e8b3">

### INT8 Quant BF16 -> INT8
<img width="719" alt="qdq_bf16_int8_quant" src="https://media.gitenterprise.xilinx.com/user/3741/files/a6d59a49-99d1-4100-bb90-0612d6abaa64">

### INT8 Quant and Dequant INT8 -> BF16 -> INT8
<img width="692" alt="qdq_int8_int8_both" src="https://media.gitenterprise.xilinx.com/user/3741/files/95d2d142-b6d2-4bd5-a014-9cb71d6c7745">

### INT16 Dequant INT16 -> BF16
<img width="716" alt="qdq_int16_bf16_dequant" src="https://media.gitenterprise.xilinx.com/user/3741/files/167f1f69-a747-4ff2-a322-9ee2801d8b88">

### INT16 Quant BF16 -> INT16
![qdq_bf16_int16_quant](https://media.gitenterprise.xilinx.com/user/3741/files/840cdfae-9a77-4713-9e11-a7d23b2be884)

### INT16 Quant and Dequant INT16 -> BF16 -> INT16
<img width="712" alt="qdq_int16_int16_both" src="https://media.gitenterprise.xilinx.com/user/3741/files/c3ced93c-df4d-42a0-8f16-64781cdb4527">
