
## `slice_build.py` — Slice Shape Generator

This script builds slice shapes for a set of predefined input shapes, permutations, and configurations. You can run all shapes or select specific ones via command-line arguments.

### Usage

```bash
python slice_build.py \
    --backend <0|1> \
    [--qdq_mode <0|1|2|3>] \
    [--shape_index <int>] \
    [--save_bins <bool>]
    [--dtype <8|16>]
```

### Arguments

| Argument        | Type  | Required | Description                                                                                                                     |
| --------------- | ----- | -------- | ------------------------------------------------------------------------------------------------------------------------------- |
| `--backend`     | `int` | No  | Backend mode:<br>• `0` = AIESIM<br>• `1` = TXN\_BIN   (default: 0)                                                                         |
| `--qdq_mode`    | `int` | No       | QDQ behavior (default: `3`):<br>• `0` = Only Dequant<br>• `1` = Only Quant<br>• `2` = Both Quant and Dequant<br>• `3` = Neither |
| `--shape_index` | `int` | No       | Key of the target shape in the shape dictionary. If omitted, runs **all shapes**                                                |
| `--save_bins`   | `bool`  | No       | If provided, saves generated `.bin` files and `dma.hpp` output (default: False)                                               | `--dtype`   | `int`  | Yes       | The number of bits in the integer datatype involved in the operation. 
| `--dtype`   | `int`  | Yes       | The number of bits in the integer datatype involved in the operation. |

### Examples

**Run all shapes with AIESIM and no QDQ, where the integer datatype is INT16:**

```bash
python slice_build.py --backend 0 --dtype 16
```

**Run only shape #4 with TXN\_BIN and both Quant/Dequant enabled, where the integer datatype is INT8: INT8->BF16->INT8:**

```bash
python slice_build.py --backend 1 --qdq_mode 2 --shape_index 4 --dtype 8
```

**Run shape #3 with no QDQ and save binaries, where the integer datatype is INT16::**

```bash
python slice_build.py --backend 1 --shape_index 3 --save_bins True --dtype 16
```

---


Current Stress test by running the following command

```
python slice_stress_test.py
```

Should yield the following results:

| Axis   | QDQ MODE   | Total Shapes        | Total Shapes Passed  | Pass Rate |
|--------|------------|---------------------|----------------------|-----------|
| 1      | 0          | 355                 | 355                  | 100.0     |
| 1      | 1          | 351                 | 351                  | 100.0     |  
| 1      | 2          | 333                 | 333                  | 100.0     |    
| 1      | 3          | 297                 | 297                  | 100.0     |      
| 2      | 0          | 331                 | 331                  | 100.0     |
| 2      | 1          | 307                 | 307                  | 100.0     |
| 2      | 2          | 332                 | 332                  | 100.0     |
| 2      | 3          | 313                 | 313                  | 100.0     |
| 3      | 0          | 350                 | 350                  | 100.0     |
| 3      | 1          | 361                 | 361                  | 100.0     |
| 3      | 2          | 336                 | 336                  | 100.0     |
| 3      | 3          | 334                 | 334                  | 100.0     |



## Current Test Results on Hardware (Shapes labelled as PSP1)

### INT8 Dequant: INT8 -> BF16
![image](https://media.gitenterprise.xilinx.com/user/3741/files/f7ae9251-c638-4935-af49-695d98635f6b)

### INT8 Quant BF16 -> INT8
<img width="766" alt="slice_quant_bf16_int8" src="https://media.gitenterprise.xilinx.com/user/3741/files/001a8ccd-0d96-4195-955e-f637367e42f6">

### INT8 Quant and Dequant INT8 -> BF16 -> INT8
![image](https://media.gitenterprise.xilinx.com/user/3741/files/eed4c0d6-debd-47fc-bf53-94d284cbf689)

### INT8 No QDQ INT8 -> INT8
![image](https://media.gitenterprise.xilinx.com/user/3741/files/8ea9d81b-13ab-48e7-8665-94b0b1e2f61a)

### INT16 Dequant INT16 -> BF16
![image](https://media.gitenterprise.xilinx.com/user/3741/files/fa67e643-1ea9-4f04-9332-6df0ea3317fa)

### INT16 Quant BF16 -> INT16
![image](https://media.gitenterprise.xilinx.com/user/3741/files/201320dc-8230-436e-9c1c-30a18b5b9dc7)

### INT16 Quant and Dequant INT16 -> BF16 -> INT16
![image](https://media.gitenterprise.xilinx.com/user/3741/files/25c4d908-1bb8-467c-92b8-a117afba9a58)

### INT16 No QDQ INT16 -> INT16
![image](https://media.gitenterprise.xilinx.com/user/3741/files/fe517e6a-96ae-43a8-a80e-4a6792ee5df3)



