### Run shape:

## `transpose_build.py` — Transpose Shape Generator

This script builds transpose shapes for a set of predefined input shapes, permutations, and configurations. You can run all shapes or select specific ones via command-line arguments.

### Usage

```bash
python transpose_build.py \
    --backend <0|1> \
    [--qdq_mode <0|1|2|3>] \
    [--shape_index <int>] \
    [--save_bins <bool>]
```

### Arguments

| Argument        | Type  | Required | Description                                                                                                                     |
| --------------- | ----- | -------- | ------------------------------------------------------------------------------------------------------------------------------- |
| `--backend`     | `int` | No  | Backend mode:<br>• `0` = AIESIM<br>• `1` = TXN\_BIN  (default: 0)                                                                           |
| `--qdq_mode`    | `int` | No       | QDQ behavior (default: `3`):<br>• `0` = Only Dequant<br>• `1` = Only Quant<br>• `2` = Both Quant and Dequant<br>• `3` = Neither |
| `--shape_index` | `int` | No       | Key of the target shape in the shape dictionary. If omitted, runs **all shapes**                                                |
| `--save_bins`   | `bool`  | No       | If provided, saves generated `.bin` files and `dma.hpp` output (default: False)                                                 |

### Examples

**Run all shapes with AIESIM and no QDQ:**

```bash
python transpose_build.py --backend 0
```

**Run only shape #4 with TXN\_BIN and both Quant/Dequant enabled:**

```bash
python transpose_build.py --backend 1 --qdq_mode 2 --shape_index 4
```

**Run shape #3 with Defaul QDQ Mode (None) and save binaries:**

```bash
python transpose_build.py --backend 1 --shape_index 3 --save_bins True
```

---


### Trigger Stress Test:

```
python transpose_stress_test.py
```


#### DI Check for basic shapes on HW:

![_Y__sqiang_WAIC_daly_debug_WAIC_dataflow_transpose_logs_DI_HW_ txt](https://media.gitenterprise.xilinx.com/user/4567/files/cdd3c413-2ed2-47a5-97cc-f7fa0ea046d9)



