#include <fstream>
#ifndef __TXNRT__
#include <adf.h>
#include <adf/adf_api/AIERuntimeControl.h>
#include "super.hh"
#include "graph.hpp"
#endif // __TXNRT__
#if defined(__AIESIM__) || defined(__TXNRT__)
#if _FAST_PM_
#include "dma.hpp"
#include "txn_pm_bin_gen.hpp"
#endif
#endif // __AIESIM__


#ifndef __TXNRT__
ComputeGraph g_compute_graph;
#endif

int main(void)
{
#if defined(__AIESIM__) || defined(__TXNRT__)
#if _FAST_PM_
    int binOffset = BINOFFSET;

    int aie_cols = NCOLS;
    int pm_id = PM_ID;
    std::vector<uint8_t> txn = dump_txn_pm(aie_cols, binOffset, pm_id);

    std::ofstream ofs("txn_pm.bin", std::ios::binary);
    if (ofs) {
        ofs.write(reinterpret_cast<const char*>(txn.data()), txn.size());
        ofs.close();
    } else {
        std::cerr << "Failed to open file for writing.\n";
    }

#endif
#endif

    return 0;
}
