import os
import argparse
from typing import List
import shutil
import subprocess
import sys
import json
import traceback
import re

CURRDIR = os.path.dirname(os.path.abspath(__file__))
sys.path.append(CURRDIR)
sys.path.append(os.path.join(CURRDIR, '..'))

def combine_bins(dir: str, col: int, outFile: str):
    with open(outFile, 'wb') as f: #write bin file
        row = 4
        for i in range(col):
            for j in range(row):
                with open(os.path.join(dir, 'aie', str(i) + "_" + str(j), 'elf_ctrl_pkt.bin'), "rb") as f_elf:
                    elf_data = f_elf.read()
                    '''
                    ###TODO : add core enable ctrl pkt data here and add 3 words to the bin offset -
                    # pkt header
                    # ctrl pkt header
                    # core enable bit to write in the register
                    '''
                    f.write(elf_data)
                    f_elf.close()
        f.close()

def main(args):
    try:
        pass
    except Exception as e:
        print("Error in main:")
        print(traceback.format_exc())

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description="Prepare fast pm load binaries", 
                                   usage='use "%(prog)s --help" for more info', 
                                   formatter_class=argparse.RawTextHelpFormatter)
    # Required args
    ## NOTE: Keep the the order of kernel_names and kernel_includes same
    parser.add_argument('-col','--aie_cols', required=True, choices=['4', '8'], help="Number of cols used")
    parser.add_argument('-offset', '--bin_offset', required=True, help="Offset of single pm bin size in bytes")
    args = parser.parse_args()
    main(args)