'''
This module imports the public facing user interfaces, so that
external users do not need to be aware of the internal submodule
structure of the library. Usage of any APIs outside this file
is deprecated and may not be stable accross package versions.
'''


from .types import (
    DevGen,
    CascDir, DmaDir, DmaChannel, TileType, AieTile, AieDma,
    DmaConnection, CoreConnection, OverlayShape,
    core_tile, memory_tile, shim_tile,
    core_dma, memtile_dma, shim_dma,
    BackEnd, SyncStrategy, TransferParams, DataTransfer,
    CoreInstr, Loop, AcqBuffer, RelBuffer, ConfigBuffer, CallKernel,
    DmaPaddingMap,
)
from .setup import set_dev_gen
from .tiling import (
    generate_transfer_params,
    generate_shim_data_transfer,
    generate_core_buffer_config,
    compute_buffer_size,
    compute_reuse_chain_length,
    generate_memtile_data_transfers_1_to_N,
    generate_memtile_data_transfers_N_to_1,
    pack_reconfig_transfers,
    generate_packed_shim_data_transfer,
    generate_memtile_data_transfer,
)
from .compilation import run_layer_compilation
from . import config
from .print_run_layer_compilation import print_run_layer_compilation_inputs


__version__ = '0.4.0'
