'''
This module contains the device-specific backend configuration.
In future versions, this config module will be used to specify
the device generation (Aie2p, Aie4, etc.) for the backend to target.
'''


# Array parameters

DEV_GEN = None

NUM_AIE_ROWS = None
NUM_AIE_COLS = None

ENABLE_BUSY_POLL = None
MIN_STEP_SIZE = None
MAX_LOCK_VALUE = None
MAX_TASK_QUEUE_SIZE = None
MAX_NEIGHBOR_ACCESS = None
MAX_REPEAT_COUNT = None
MAX_ITER_WRAP = None
ENABLE_MULTI_UC = None

# Core parameters

MAX_CORE_ADDR = None
MAX_CORE_BUFFER_LENGTH = None
MIN_CORE_BUFFER_ALIGNMENT = None
MAX_CORE_STEP = None
MAX_CORE_WRAP = None
MAX_CORE_DIMS = None
MAX_CORE_S2MM_DMA_CHANNEL = None
MAX_CORE_MM2S_DMA_CHANNEL = None
MAX_CORE_LOCK_ID = None
MAX_CORE_LAYER_PARAM_SIZE = None
MAX_CORE_NUM_KERNELS = None

# Memtile parameters

MEMTILE_BASE_ADDR = None
MAX_MEMTILE_ADDR = None
MAX_MEMTILE_BUFFER_LENGTH = None
MAX_MEMTILE_STEP = None
MAX_MEMTILE_WRAP = None
MAX_MEMTILE_DIMS = None
MAX_MEMTILE_S2MM_DMA_CHANNEL = None
MAX_MEMTILE_MM2S_DMA_CHANNEL = None
MAX_MEMTILE_S2MM_NEIGHBOR_CHANNEL = None
MAX_MEMTILE_MM2S_NEIGHBOR_CHANNEL = None
MAX_MEMTILE_LOCK_ID = None
MAX_MEMTILE_PAD_DIMS = None
MAX_MEMTILE_D0_PAD = None
MAX_MEMTILE_D1_PAD = None
MAX_MEMTILE_D2_PAD = None
MEMTILE_ADDR_GRAN = None

# Shim parameters

MAX_SHIM_ADDR = None
MAX_SHIM_BUFFER_LENGTH = None
MAX_SHIM_STEP = None
MAX_SHIM_WRAP = None
MAX_SHIM_DIMS = None
MAX_SHIM_S2MM_DMA_CHANNEL = None
MAX_SHIM_MM2S_DMA_CHANNEL = None
MAX_SHIM_LOCK_ID = None

SHIM_PARAM_BUFFER_IDX = None
SHIM_CTRL_BUFFER_IDX = None
MAX_DDR_BURST_LENGTH = None

# Control packet size parameters

BD_CONFIG_CTRL_PKT_WORDS = None
LOCK_CONFIG_CTRL_PKT_WORDS = None
TASK_ENQUEUE_CTRL_PKT_WORDS = None

#
# AIE-2p Specific Configs
#

# BD register file configs

MAX_MEMTILE_BD_LO_ID = None
MAX_MEMTILE_BD_HI_ID = None

MAX_SHIM_BD_ID = None

# Control split node parameters

SHIM_CTRL_MM2S_CHANNEL_ID = None
DATA_TRANSFER_PKT_SPLIT_IDX = None
SHIM_CTRL_PKT_SPLIT_IDX = None
MEMTILE_CTRL_PKT_SPLIT_IDX = None
CORE_CTRL_PKT_SPLIT_IDX = None
NUM_CTRL_PKT_SPLIT = None
SHIM_CTRL_PKT_BD_ID = None

# Fast PM support
ENABLE_FAST_PM = None
DATA_TRANSFER_PKT_ID = None
SHIM_CTRL_PKT_IDX = None
MEMTILE_CTRL_PKT_IDX = None

#
# AIE-4 Specific Configs
#

# BD regsiter file configs

MAX_MEMTILE_PRIVATE_BD_ID = None

MAX_SHIM_LO_S2MM_DMA_CHANNEL = None
MAX_SHIM_LO_MM2S_DMA_CHANNEL = None
MAX_SHIM_LO_BD_ID = None
MAX_SHIM_HI_BD_ID = None

#
# TASK QUEUE OPTIMIZATION Specific Configs
# Lookup table (dictionary) that maps:
#   DevGen -> TileType -> Channel
# and returns the number of channels for the given combination.
#
NUM_CHANNEL_LUT = None

# Multi Micro-controller
MAX_UC = None
NUM_UC_USED = None
MAX_REMOTE_BARRIER = None
IS_MULTI_UC = None


def check_init():
    if DEV_GEN is None:
        raise RuntimeError('Uninitialized device generation! '
                           'Call set_dev_gen after importing dmacompiler')
