/*  (c) Copyright 2019 - 2024 Xilinx, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __BILINEAR_PIXEL_RESIZE_BF16_IMPL_H__
#define __BILINEAR_PIXEL_RESIZE_BF16_IMPL_H__

#include "aie_api/aie.hpp"
#include "aie_api/utils.hpp"
#include "bilinear_pixel_resize_bf16.hpp"
#ifdef DEBUG_KERNEL
#include "stdio.h"
#endif



//ALWAYS_INLINE void
//void __attribute__(( noinline ))
void
bilinear_pixel_resize_bf16_inner
(
        bfloat16 * ifm,
        int16_t * wgt,
        bfloat16 * restrict ofm,
        const BilinearPixelResizeBf16Params &params
) {
    bfloat16 *pI = ( bfloat16 * ) ifm;
    bfloat16 *pO = ( bfloat16 * ) ofm;
    dims_3d_t dimsO = params.dimsO.instantiate( );
    dims_2d_t dimsW = params.dimsW.instantiate( );
    dims_2d_t dimsI( params.dimsW.num0, 0, params.step_Ci );
    
    int16_t *pWh = wgt;
    for ( int h=0; h<params.H; h++ ) {
        aie::vector<bfloat16,32> sh = broadcast_to_v32bfloat16( *( v2bfloat16* ) pWh ); // low level due to CRVO-12074
        sh = aie::interleave_zip( sh, sh, 1 ).first;
        bfloat16 *pIh = byte_incr( pI, params.step_Hi * (( int32_t * ) pWh )[1] );
        int16_t * __aie_register_keep( ) pWw = wgt + params.H * 4;
        
        [[using chess: prepare_for_pipelining, min_loop_count( 8 )]]
        for ( int i=0; i<params.inner_loop; i++ ) {
            aie::vector<bfloat16,32> sw = broadcast_to_v32bfloat16( *( v2bfloat16* ) pWw ); // low level due to CRVO-12074
            int32_t * __aie_register_keep( ) pWw32 = chess_copy(( int32_t * ) pWw );
            bfloat16 * pIw = byte_incr( pIh, pWw32[1] );
            pWw = chess_copy( pWw );
            auto s = aie::mul( sh, sw ).to_vector<bfloat16>( );
                        
            auto pIwh = byte_incr( pIw, params.step_Hi );
            auto i00 = aie::load_v<8>( pIw ).grow<32>( );
            auto i01 = aie::load_v<8>( pIw + 8 ).grow<32>( );
            auto i10 = aie::load_v<8>( pIwh ).template grow<32>( );
            auto i11 = aie::load_v<8>( pIwh + 8 ).template grow<32>( );
            
            auto acc = aie::mul(  i00, s[0] );
            acc = aie::mac( acc, i01, s[1] );
            acc = aie::mac( acc, i10, s[2] );
            acc = aie::mac( acc, i11, s[3] );
            aie::store_v( pO, acc.to_vector<bfloat16>( ).template extract<8>( 0 ));
            
            pO = add_3d_byte( pO, dimsO );
            pWw = add_2d_byte( pWw, dimsW );
            pIh = add_2d_byte( pIh, dimsI );
        }
        pWh += 4;
    }
}

#endif // __BILINEAR_PIXEL_RESIZE_BF16_TEMPLATE_H__
