#ifndef _BILINEAR_PIXEL_RESIZE_BF16_WRAPPER_CC_
#define _BILINEAR_PIXEL_RESIZE_BF16_WRAPPER_CC_

#include "qdq/qdq_kernel_helpers.h"
#include "qdq/qdq_int16_bfloat16.hpp"
#include "kernel_helpers.h"
#include "bilinear_pixel_resize_bf16_impl.hpp"

void __attribute__((noinline)) run_bilinear_resize_bf16(KernelArgs& args)
{
    set_sat();
    set_rnd(rnd_conv_even);
    struct bilinear_resize_bf16_params
    {
        uint32_t wgt_offset;
        uint32_t ifm_elems;
        uint32_t ofm_elems;
        uint32_t sign;
        BilinearPixelResizeBf16Params kernel_params;
    };
    struct BilinearQDQParams
    {
        uint16_t dq_enable;
        bfloat16 dq_sc;
        uint16_t dq_zp;
        uint16_t q_enable;
        bfloat16 q_sc;
        uint16_t q_zp;
        uint16_t reserved[26]; // Reserved fields to align to 64 bytes

    };
    bilinear_resize_bf16_params* layer_params = static_cast<bilinear_resize_bf16_params*>(args.params_data);
    BilinearPixelResizeBf16Params& kernel_params = layer_params->kernel_params;
    BilinearQDQParams* qdq_param = static_cast<BilinearQDQParams*>(args.s2mm_ch1_data);
    int8_t* ifm = static_cast<int8_t*>(args.s2mm_ch0_data);
    int8_t* wgt = reinterpret_cast<int8_t*>(byte_incr(ifm, layer_params->wgt_offset)); 
    int8_t* ofm = static_cast<int8_t*>(args.mm2s_ch0_data);
    dequant_int16_to_bf16(ifm, ifm, layer_params->ifm_elems, qdq_param->dq_zp, qdq_param->dq_sc, layer_params->sign, qdq_param->dq_enable);
    bilinear_pixel_resize_bf16_inner((bfloat16*)ifm, (int16_t*)wgt, (bfloat16*)ofm, kernel_params);
    quant_bf16_to_int16(ofm, ofm, layer_params->ofm_elems, qdq_param->q_zp, qdq_param->q_sc, layer_params->sign, qdq_param->q_enable);
}


#endif // _BILINEAR_PIXEL_RESIZE_BF16_WRAPPER_CC_