#ifndef __CORE_BUF_H__
#define __CORE_BUF_H__

/*
 *
 */
struct CoreBuff {
    uint32_t addr;
    uint32_t size;
    constexpr CoreBuff(uint32_t addr, uint32_t size)
        : addr(addr)
        , size(size)
    {
    }

};

// Core buffer allocation for A16W8 gemm+qdq
constexpr CoreBuff gemm_tdm1(8192, 8192);
constexpr CoreBuff gemm_tdm2(24576, 8192);
constexpr CoreBuff gemm_ifm_sum(54336, 8192);

#endif