/*
    Copyright (C) 2019 - 2022 Xilinx, Inc. All rights reserved.
    Copyright (C) 2022 - 2024 Advanced Micro Devices, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */


#ifndef __MMULT_COMMON_H__
#define __MMULT_COMMON_H__

#include <stdint.h>
#include "kernel_helpers.h"
#include "ml_params.h"

struct MMultIncrements property(keep_in_registers) {
    int numA1;
    int incA1;
    int numA2;
    int incA2;
    int incA3;

    int numB1;
    int incB1;
    int numB2;
    int incB2;
    int incB3;

    int numS;
    int incS1;
    int incS2;

    int incAI;
    int incBI;
    int incSI;

    int shfl_0;
    int shfl_1;
};


#ifndef ALWAYS_INLINE
#ifdef  __clang__
#define ALWAYS_INLINE inline __attribute__((always_inline))
#else
#define ALWAYS_INLINE inline
#endif
#endif


inline int min(int a, int b) { return a<b ? a : b; }
inline int max(int a, int b) { return a>b ? a : b; }
inline long min(long a, long b) { return a<b ? a : b; }
inline long max(long a, long b) { return a>b ? a : b; }
inline unsigned min(unsigned a, unsigned b) { return a<b ? a : b; }
inline unsigned max(unsigned a, unsigned b) { return a>b ? a : b; }
inline unsigned long min(unsigned long a, unsigned long b) { return a<b ? a : b; }
inline unsigned long max(unsigned long a, unsigned long b) { return a>b ? a : b; }

inline int ceil(     int val, int div) { return (val+(div-1)) /  div; }
inline int ceil_byte(int val, int div) { return (val+(div-1)) & ~div; }

#endif //__MMULT_COMMON_H__