#ifndef __WRAPPER_CONCAT_CC__
#define __WRAPPER_CONCAT_CC__
#include "concat_16b_c6463_impl.hpp"

void run_concat_c6463(KernelArgs& args)
{
    struct LayerParams
    {
        uint32_t offset_bytes;
        ConcatParams kernel_params;
    };
    LayerParams* layer_params = static_cast<LayerParams*>(args.params_data);
    ConcatParams& kernel_params = layer_params->kernel_params;
    int16_t* inputA = static_cast<int16_t*>(args.s2mm_ch0_data);
    int16_t* inputB = byte_incr(inputA,layer_params->offset_bytes);
    int16_t* output = static_cast<int16_t*>(args.mm2s_ch0_data);
    concat_16b_c6463 (
        inputA,
        inputB,
        output,
        kernel_params
    );
}

#endif