/*  (c) Copyright 2019 - 2021 Xilinx, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __DIRECT_CONV_INT16X8_GENERIC_HPP__
#define __DIRECT_CONV_INT16X8_GENERIC_HPP__

#include "ml_params.h"

namespace DirectConvInt8x8{
    enum OPMode {
        //OP_NONE,
        OP_CONV=1,
        OP_SUM=2,
        OP_SUM_2=16,
        OP_SUM_T=18,
        OP_CONV_SYM=9,
        OP_CONV_ASYM=11,
        OP_ASYM=10,
        OP_DWC=4,
        OP_DWC_SUM=6,
        OP_DWC_SYM=12,
        OP_DWC_ASYM=14,
        OP_QDQ=8
    };
}


namespace DirectConvInt16x8Generic {

    struct BaseParams {
        uint16_t outer_g;
        uint16_t inner_g;
        struct Control {
            uint8_t sign_A:1;
            uint8_t sign_W:1;
            uint8_t is_conv:1;
            uint8_t is_sum:1;
            uint8_t tdm_overwrite:1;
        } ctrl;
        uint8_t step_align;
        uint8_t shfl_0;
        uint8_t shfl_1;
        dims_3d_param_s16 dimsW;
        dims_3d_param_s16 dimsA;
    };

    struct ConvAddParams {
        dims_3d_param_s16 dimsAO;
    };

    struct SumAddParams {
        uint8_t is_2k_mode;
        uint8_t shfl_sum_0;
        uint8_t shfl_sum_1;
        dims_3d_param_s16 dimsSum;
    };

    struct ConvSumAddParams : SumAddParams {
        dims_2d_param_s16 dimsKsumI;
        dims_2d_param_s16 dimsKsumO;
        uint8_t kernel_size;
        uint8_t pixels_out_g;
        uint8_t shfl_sum_2;
    };

    struct DwcAddParams : ConvAddParams {
        int16_t weight_size;
        int8_t zp_wght;
    };


    struct ConvParams : BaseParams, ConvAddParams { };
    struct SumParams : BaseParams, SumAddParams { };
    struct ConvSumParams : BaseParams, ConvSumAddParams { };
    struct DwcParams : BaseParams, DwcAddParams { };


    struct LowParams : BaseParams {
        union {
            ConvAddParams conv;
            ConvSumAddParams sum;
            DwcAddParams dwc;
        };
    };

    struct QDQParams {
        int16_t loop;
        uint8_t split_mode:1;
        uint8_t sign_out:1;
        int8_t vector_coeffs;
        int16_t dims_in1_wrap0;
        int16_t dims_in1_wrap1;
        int16_t dims_in1_step;
        //dims_3d_param_s16 dims_in2;
        dims_2d_param_s16 dims_sum;
        dims_2d_param_s16 dims_qnt;
        dims_3d_param_s16 dims_out;
    };
};


struct DirectConvInt16x8GenericKernelParams {
    union {
        struct {
            DirectConvInt16x8Generic::ConvParams conv;
            DirectConvInt16x8Generic::ConvSumParams ifm_sum;
        };
        DirectConvInt16x8Generic::DwcParams dwc;
    };
    DirectConvInt16x8Generic::QDQParams qdq;
};


template<bool has_dwc, bool has_conv, bool has_sum>
void direct_conv_int16x8_generic
(
        int16_t * input,
        int8_t * weights,
        int8_t * weight_unpack,
        int32_t * restrict tdm1,
        int32_t * restrict tdm2,
        bool zero_init,
        bool final_tdm_iter,
        int op_mode,
        int shift_tdm,
        const DirectConvInt16x8Generic::LowParams &params
);

#endif //__DIRECT_CONV_INT16X8_GENERIC_KERNEL_H__
