/*  (c) Copyright 2019 - 2021 Xilinx, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __DIRECT_CONV_INT16X8_GENERIC_IMPL_HPP__
#define __DIRECT_CONV_INT16X8_GENERIC_IMPL_HPP__

#include <stdint.h>
#include "direct_conv_int16x8_generic.hpp"
#include "aie_api/aie.hpp"
#include "access_helpers.hpp"
#include "kernel_helpers.h"
#include "ml_params.h"

namespace DirectConvInt8x8
{
    template<typename Ta, typename Tv>
    inline Ta from_vector_sign( Tv v, bool sign, int shift=0 ) {
        Ta a;
        a.from_vector_sign( v, sign, shift );
        return a;
    }
}


__aie_inline void direct_conv_int16x8_generic_base
(
        int16 * input,
        int8  * weights,
        int32 * tdm1,
        int32 * tdm2,
        int shift_tdm,
        bool zero_init,
        const DirectConvInt16x8Generic::LowParams &params,
        dims_3d_param_s16 dimsAO,
        dims_3d_param_s16 dimsW,
        int incT_0,
        int incT_1,
        bool is_sub
) {
    using mm_t = aie::mmul<4,8,8,int16,int8>;
    using acc_t = mm_t::accum_type;
    constexpr unsigned Va = 32;

    v32int16 * pA = ( v32int16 * ) input;
    int8  * pW = weights;

    int32 * pTdm1 = tdm1;
    int32 * pTdm2 = tdm2;
    int32 * restrict pOut1 = chess_copy( tdm1 );
    int32 * restrict pOut2 = chess_copy( tdm2 );

    fifo_state_t fA;
    fA.pos = 0;

    dims_3d_t dimsAI = params.dimsA.instantiate( 8 );
    dims_3d_t dimsAO_i = dimsAO.instantiate( 8 );
    dims_3d_t dimsW_i  = dimsW.instantiate( 8 );
    DirectConvInt16x8Generic::BaseParams::Control ctrl = params.ctrl;

    int incTi = incT_0;
    int incT_flag = 0;

    for (unsigned j=0; j<params.outer_g; j++)
        chess_prepare_for_pipelining
        chess_loop_range(2,)
    {
        int zero_acc = zero_init;
        mm_t m[2];

        acc_t tdm1, tdm2;
        using acc_h_t = decltype( tdm1.extract<Va/2>( 0 ));
        tdm1.insert( 1, acc_h_t( aie::load_v<Va/2>( pTdm1 + Va / 2 ), shift_tdm ));
        tdm1.insert( 0, acc_h_t( aie::load_v<Va/2>( pTdm1 ),          shift_tdm ));
        tdm2.insert( 1, acc_h_t( aie::load_v<Va/2>( pTdm2 + Va / 2 ), shift_tdm ));
        tdm2.insert( 0, acc_h_t( aie::load_v<Va/2>( pTdm2 ),          shift_tdm ));
        m[0] = mm_t( aie::op_zero( tdm1, zero_acc ));
        m[1] = mm_t( aie::op_zero( tdm2, zero_acc ));
        pTdm1 = byte_incr( pTdm1, incTi );
        pTdm2 = byte_incr( pTdm2, incTi );

        int incTo = chess_copy( incTi );
        incT_flag ^= 1;
        incTi = incT_flag ? incT_1 : incT_0;

        int bound = params.inner_g;

            aie::vector<int16,32> s0 = fifo_ld_popx( pA, fA, params.step_align, 63);
            aie::vector<int16,32> s1 = fifo_ld_pop_3d_byte(pA, fA, dimsAI);

            aie::vector<int16,32> x0 = shuffle(s0, s1, params.shfl_0);
            aie::vector<int16,32> x1 = shuffle(x0, s1, params.shfl_1);

            aie::vector<int8, 64> y = aie::load_v<64>( pW );
            pW = add_3d_byte( pW, dimsW_i );

            //m[0].mac( aie::op_sign( x0, ctrl.sign_A ), aie::op_sign( y, ctrl.sign_W ));
            //m[1].mac( aie::op_sign( x1, ctrl.sign_A ), aie::op_sign( y, ctrl.sign_W ));
            m[0] = acc_t( mac_4x8_8x8_conf( x0, ctrl.sign_A, y, ctrl.sign_W, m[0].to_accum( ), zero_acc, 0, is_sub, 0 ));
            m[1] = acc_t( mac_4x8_8x8_conf( x1, ctrl.sign_A, y, ctrl.sign_W, m[1].to_accum( ), zero_acc, 0, is_sub, 0 ));


        for (int i=1; i<bound; i++)
            chess_prepare_for_pipelining
            //chess_peel_pipelined_loop(2)
            //chess_pipeline_adjust_preamble(-3)
            chess_loop_range(7,)
        {
            aie::vector<int16,32> s0 = fifo_ld_popx( pA, fA, params.step_align, 63);
            aie::vector<int16,32> s1 = fifo_ld_pop_3d_byte(pA, fA, dimsAI);

            aie::vector<int16,32> x0 = shuffle(s0, s1, params.shfl_0);
            aie::vector<int16,32> x1 = shuffle(x0, s1, params.shfl_1);

            aie::vector<int8, 64> y = aie::load_v<64>( pW );
            pW = add_3d_byte( pW, dimsW_i );

            //m[0].mac( aie::op_sign( x0, ctrl.sign_A ), aie::op_sign( y, ctrl.sign_W ));
            //m[1].mac( aie::op_sign( x1, ctrl.sign_A ), aie::op_sign( y, ctrl.sign_W ));
            m[0] = acc_t( mac_4x8_8x8_conf( x0, ctrl.sign_A, y, ctrl.sign_W, m[0].to_accum( ), 0, 0, is_sub, 0 ));
            m[1] = acc_t( mac_4x8_8x8_conf( x1, ctrl.sign_A, y, ctrl.sign_W, m[1].to_accum( ), 0, 0, is_sub, 0 ));
        }

        pA = add_3d_byte( pA, dimsAO_i );
        aie::store_v( pOut1 + Va / 2, m[0].to_accum( ).extract<Va/2>( 1 ).to_vector<int32>( shift_tdm ));
        aie::store_v( pOut1,          m[0].to_accum( ).extract<Va/2>( 0 ).to_vector<int32>( shift_tdm ));
        aie::store_v( pOut2 + Va / 2, m[1].to_accum( ).extract<Va/2>( 1 ).to_vector<int32>( shift_tdm ));
        aie::store_v( pOut2,          m[1].to_accum( ).extract<Va/2>( 0 ).to_vector<int32>( shift_tdm ));
        pOut1 = byte_incr( pOut1, incTo );
        pOut2 = byte_incr( pOut2, incTo );
    }
    //event1();
}



__aie_inline void sum_conv_2d_c1( int32 * in, int32 * restrict out, const DirectConvInt16x8Generic::ConvSumAddParams &params ) {
    v16int32 * pI = ( v16int32 * ) in;
    int32 * pO = out;
    constexpr unsigned N = 8;
    fifo_state_t f;
    f.pos = 0;
    addr_t cntI = 0;
    dims_2d_t dimsO = params.dimsKsumO.instantiate( );
    for ( unsigned pix = 0; pix < params.pixels_out_g; pix++ )
        chess_no_hw_loop
    {
        constexpr unsigned Nop = std::max( 16u, N );
        aie::vector<int32,Nop> sum = aie::zeros<int32,Nop>( );
        fifo_ld_fill( pI, f );
        aie::vector<int32,Nop> val = fifo_ld_pop_2d_byte( pI, f, params.dimsKsumI.inc1, params.dimsKsumI.num0, cntI, params.dimsKsumI.inc0 );
        for ( unsigned k = 1; k < params.kernel_size; k++ )
            chess_no_hw_loop
        {
            sum = aie::add( sum, aie::vector( shuffle( val, params.shfl_sum_2 )));
            fifo_ld_fill( pI, f );
            val = fifo_ld_pop_2d_byte( pI, f, params.dimsKsumI.inc1, params.dimsKsumI.num0, cntI, params.dimsKsumI.inc0 );
        }
        sum = aie::add( sum, aie::vector( shuffle( val, params.shfl_sum_2 )));
        aie::store_v( pO, sum.extract<N>( 0 ));
        pO += N;
        pI = add_2d_byte( pI, dimsO );
    }
}

template<bool has_dwc, bool has_conv, bool has_sum>
void direct_conv_int16x8_generic
(
        int16_t * input,
        int8_t * weights,
        int8_t * weight_unpack,
        int32_t * restrict tdm1,
        int32_t * restrict tdm2,
        bool zero_init,
        bool final_tdm_iter,
        int op_mode,
        int shift_tdm,
        const DirectConvInt16x8Generic::LowParams &params
) {
    constexpr bool has_any_conv = has_conv || has_dwc;

    DirectConvInt16x8Generic::BaseParams::Control ctrl = params.ctrl;
    int8_t * pW = weights;
    int32_t * pTdm2 = ctrl.tdm_overwrite ? tdm1 : tdm2;
    int Xi_g, Yi_g, Xi_block_words;
    dims_3d_param_s16 dimsAO = { 0, 0, 0, 0, 0 };
    dims_3d_param_s16 dimsW = params.dimsW;
    int delta_tdm = (long)tdm2 - (long)tdm1;
    int incT_0 = has_conv && ctrl.tdm_overwrite ? delta_tdm : 128;
    int incT_1 = has_conv && ctrl.tdm_overwrite ? 128 - delta_tdm : 128;
    bool is_sub = 0;

    if ( has_any_conv && ctrl.is_conv && !ctrl.is_sum ) {
        dimsAO = params.conv.dimsAO;
    }
    if ( has_dwc && (( op_mode & DirectConvInt8x8::OP_DWC ) != 0 )) {
        unsigned wghts = params.dwc.weight_size;
        v8int8 * pI = (v8int8*) weights;
        v64int8 * restrict pO = (v64int8*) weight_unpack;
        pW = weight_unpack;
        #define AIE_ATTRIBUTES chess
        [[ using AIE_ATTRIBUTES: prepare_for_pipelining, min_loop_count( 2 ), no_hw_loop ]]
        for ( unsigned kc = 0; kc < wghts; kc++ )
        {
            aie::vector<int8, 64> w = broadcast_to_v64int8( *pI++ );
            *pO++ = aie::select( int8( 0 ), w, aie::mask<64>::from_uint64( 0x8040201008040201ull ));
        }
        if (( op_mode & DirectConvInt8x8::OP_SUM ) != 0 ) {
            aie::store_v( pW, aie::select( int8( 0 ), params.dwc.zp_wght, aie::mask<64>::from_uint64( 0x8040201008040201ull )));
            dimsW.num0 = 0;
            dimsW.num1 = 0;
            dimsW.inc2 = 0;
            is_sub = 1;
        }
    } else if ( has_sum && (( op_mode & DirectConvInt8x8::OP_SUM ) != 0 )) {
        shift_tdm = 0;
        pW = weight_unpack;
        bool is_transpose = op_mode == DirectConvInt8x8::OP_SUM_T;
        unsigned wghts = is_transpose ? 8 * params.outer_g : 8;
        uint64_t mask = 0x0101010101010101ull;
        aie::vector<int8,64> mask_v = aie::select( int8( 0 ), int8( 1 ), aie::mask<64>::from_uint64( mask ));
        for ( unsigned i=0; i < wghts ; i++ ) {
            aie::store_v( pW + 64*i, mask_v );
            mask_v = aie::shuffle_up_rotate( mask_v, 1 );
        }
        incT_0 = 128 + 128 * !is_transpose;
        incT_1 = 128 + 128 * !is_transpose;
        pTdm2 = byte_incr( pTdm2, 128 * !is_transpose );
    }

    direct_conv_int16x8_generic_base(
        input, pW, tdm1, pTdm2,
        shift_tdm, zero_init, params, dimsAO, dimsW, incT_0, incT_1, is_sub
    );

    bool sum_pp_cond = chess_copy( final_tdm_iter && (( op_mode & ( DirectConvInt8x8::OP_SUM | DirectConvInt8x8::OP_DWC )) == DirectConvInt8x8::OP_SUM ));
    if ( has_sum && sum_pp_cond ) {
        int32_t * pI = tdm1;
        int32_t * pO = tdm1;
        dims_3d_t dimsO = params.sum.dimsSum.instantiate( );
        if ( has_conv && ctrl.is_conv ) {
            pO = ( int32_t * )weight_unpack;
        }
        int32_t * pS = pO;
        bool is_2k_mode = params.sum.is_2k_mode;
        for ( unsigned pix = 0; pix < params.outer_g; pix++ )
            chess_no_hw_loop
        {
            aie::vector a0 = aie::load_v<16>( pI + 64 * pix );
            aie::vector a1 = aie::load_v<16>( pI + 64 * pix + 16 * ( 2 - is_2k_mode ));
            aie::vector a2 = aie::load_v<16>( pI + 64 * pix + 16 * ( 1 + is_2k_mode ));
            aie::vector a3 = aie::load_v<16>( pI + 64 * pix + 16 * 3 );
            aie::vector b0 = shuffle( a0, a1, params.sum.shfl_sum_0 );
            aie::vector b1 = shuffle( a2, a3, params.sum.shfl_sum_0 );
            aie::vector b2 = shuffle( a0, a1, params.sum.shfl_sum_0 + 1 );
            aie::vector b3 = shuffle( a2, a3, params.sum.shfl_sum_0 + 1 );
            aie::vector c0 = shuffle( b0, b1, params.sum.shfl_sum_1 );
            aie::vector c1 = shuffle( b0, b1, params.sum.shfl_sum_1 + 1 );
            aie::vector c2 = shuffle( b2, b3, params.sum.shfl_sum_1 );
            aie::vector c3 = shuffle( b2, b3, params.sum.shfl_sum_1 + 1 );
            aie::store_v( pO, c0.extract<8>( 0 ));     pO = add_3d_byte( pO, dimsO );
            aie::store_v( pO, c0.extract<8>( 1 ));     pO = add_3d_byte( pO, dimsO );
            aie::store_v( pO, c1.extract<8>( 0 ));     pO = add_3d_byte( pO, dimsO );
            aie::store_v( pO, c1.extract<8>( 1 ));     pO = add_3d_byte( pO, dimsO );
            aie::store_v( pO, c2.extract<8>( 0 ));     pO = add_3d_byte( pO, dimsO );
            aie::store_v( pO, c2.extract<8>( 1 ));     pO = add_3d_byte( pO, dimsO );
            aie::store_v( pO, c3.extract<8>( 0 ));     pO = add_3d_byte( pO, dimsO );
            aie::store_v( pO, c3.extract<8>( 1 ));     pO = add_3d_byte( pO, dimsO );
        }
        if ( has_conv && ctrl.is_conv ) {
            sum_conv_2d_c1( pS, tdm1, params.sum );
        }
    }
}


chess_used int32 * test( int32 * p ) {
    return p + chess_copy( 8 );
}


template<bool has_sum, bool has_vector_coeffs, typename To> __aie_inline
void qdq( int32_t * tdm1, int32_t * tdm2, int32_t * ifm_sum, int64_t * coeff, int32_t c1, int32_t c2, int8_t shift_res, To * __restrict ofm, DirectConvInt16x8Generic::QDQParams &params )
{
    dims_3d_t dims_in1;
    int32_t step0 =  params.split_mode ? params.dims_in1_step * 32 : ( long )tdm2 - ( long )tdm1;
    int32_t step1 = !params.split_mode ? params.dims_in1_step * 32 : ( long )tdm2 - ( long )tdm1;
    AddByte<dims_3d_t> add_3d_in1( dims_3d_from_steps( params.dims_in1_wrap0, step0, params.dims_in1_wrap1, step1, 128 ));
    //AddByte<dims_3d_t> add_3d_in2( params.dims_in2.instantiate( 32 ));
    AddByte<dims_2d_t> add_2d_sum( params.dims_sum.instantiate( ));
    AddByte<dims_2d_t> add_2d_cf0( params.dims_qnt.instantiate( ));
    AddByte<dims_2d_t> add_2d_cf1( params.dims_qnt.instantiate( ));
    AddByte<dims_3d_t> add_3d_out( params.dims_out.instantiate( 8 * sizeof( To )));
    int bypass_value = params.loop;
    if ( params.vector_coeffs <= 0 )
        add_2d_cf1.num0 = bypass_value;

    auto pI = aie::begin_vector<32, aie_dm_resource::a>( tdm1 );
    auto pS = aie::begin_vector<4, aie_dm_resource::b>( ifm_sum );
    int64_t __aie_dm_resource_b * pC0 = (int64_t __aie_dm_resource_b *) coeff;
    auto pO = aie::begin_restrict_vector<32, aie_dm_resource::c>( ofm );

    alignas( 32 ) int32_t cf_spill[16];
    aie::store_v( cf_spill, aie::broadcast<int32_t,8>( c1 ));
    aie::store_v( cf_spill + 8 * has_sum, aie::broadcast<int32_t,8>( c2 ));
    int32_t * pC1 = params.vector_coeffs > 0 ? ( int32_t * )( pC0 + 8 ) : cf_spill;

    [[ using chess: prepare_for_pipelining, min_loop_count( 4 )]]
    for ( unsigned o=0; o<params.loop; o++ )
    {
        v32acc64 a = set_v32acc64( 0, *( v8acc64* )pC0 );
        a = insert( a, 1, *( v8acc64* )pC0 );
        aie::accum<acc64, 32> acc = insert( a, 1, extract_v16acc64( a, 0 ));

        if constexpr( has_vector_coeffs ) {
            aie::vector c2v = aie::load_v<8, aie_dm_resource::b>( pC1 + 8 * has_sum );
            if constexpr( has_sum ) {
                pC1 = chess_copy( pC1 );
                acc = mac_outer_prod( acc, *pS, aie::load_v<8, aie_dm_resource::b>( pC1 ));
            }
            acc = aie::mac( acc, *pI, c2v.grow_replicate<32>( ));
        } else {
            if constexpr( has_sum ) {
                acc = mac_outer_prod( acc, *pS, aie::broadcast<int32_t, 8>( c1 ));
            }
            acc = aie::mac( acc, *pI, c2 );
        }
        *pO = acc.template to_vector_sign<To>( params.sign_out, shift_res );

        pI = add_3d_in1( pI );
        //pI = add_3d_in2( pI );
        pS = add_2d_sum( pS );
        pC0 = add_2d_cf0( pC0 );
        pC1 = add_2d_cf1( pC1 );
        pO = add_3d_out( pO );
    }
}



template<bool has_dwc, bool has_conv, bool has_sum, bool has_vector_coeffs>
void direct_conv_int16x8_generic
(
        int16_t * input,
        int8_t * weights,
        int8_t * weight_unpack,
        int32_t * tdm1,
        int32_t * tdm2,
        int32_t * ifm_sum,
        int64_t * qdq_c0,
        int16_t * restrict output,
        bool zero_init,
        bool final_tdm_iter,
        int op_mode,
        int32_t qdq_c1,
        int32_t qdq_c2,
        int8_t shift_tdm,
        int8_t shift_res,
        DirectConvInt16x8GenericKernelParams &params
) {
    void * prm_ptr = &params;
    DirectConvInt16x8Generic::LowParams &prm_conv = *( DirectConvInt16x8Generic::LowParams* ) prm_ptr;

    if (( op_mode & ( DirectConvInt8x8::OP_CONV | DirectConvInt8x8::OP_DWC )) != 0 ) {
        int conv_param_size = prm_conv.ctrl.is_conv ? sizeof( DirectConvInt16x8Generic::ConvParams ) : sizeof( DirectConvInt16x8Generic::BaseParams );
        prm_ptr = byte_incr( prm_ptr, ( op_mode & DirectConvInt8x8::OP_DWC ) != 0 ? sizeof( DirectConvInt16x8Generic::DwcParams ) : conv_param_size );
        direct_conv_int16x8_generic<has_dwc, has_conv, has_sum>( input, weights, weight_unpack, tdm1, tdm2, zero_init, final_tdm_iter, op_mode & ( DirectConvInt8x8::OP_CONV | DirectConvInt8x8::OP_DWC ), shift_tdm, prm_conv );
    }

    if ( has_sum && (( op_mode & ( DirectConvInt8x8::OP_SUM | DirectConvInt8x8::OP_DWC )) == DirectConvInt8x8::OP_SUM )) {
        DirectConvInt16x8Generic::LowParams &prm_sum  = *( DirectConvInt16x8Generic::LowParams* ) prm_ptr;
        prm_ptr = byte_incr( prm_ptr, prm_sum.ctrl.is_conv ? sizeof( DirectConvInt16x8Generic::ConvSumParams ) : sizeof( DirectConvInt16x8Generic::SumParams ));
        direct_conv_int16x8_generic<has_dwc, has_conv, has_sum>( input, nullptr, weight_unpack, ifm_sum, nullptr, zero_init, final_tdm_iter, op_mode & ( DirectConvInt8x8::OP_SUM |  DirectConvInt8x8::OP_SUM_T ), 0, prm_sum );

    } else if ( has_dwc && (( op_mode & ( DirectConvInt8x8::OP_SUM | DirectConvInt8x8::OP_DWC )) == ( DirectConvInt8x8::OP_SUM | DirectConvInt8x8::OP_DWC ))) {
        direct_conv_int16x8_generic<has_dwc, has_conv, has_sum>( input, weights, weight_unpack, tdm1, tdm2, 0, final_tdm_iter, DirectConvInt8x8::OP_SUM | DirectConvInt8x8::OP_DWC, shift_tdm, prm_conv );
    }

    if ( final_tdm_iter && (( op_mode & DirectConvInt8x8::OP_QDQ ) != 0 )) {
        DirectConvInt16x8Generic::QDQParams &prm_qdq  = *( DirectConvInt16x8Generic::QDQParams* ) prm_ptr;
        qdq<has_sum, has_vector_coeffs>( tdm1, tdm2, ifm_sum, qdq_c0, qdq_c1, qdq_c2, shift_res, output, prm_qdq );
    }
}
#endif // __DIRECT_CONV_INT16X8_GENERIC_TEMPLATE_H__
