#ifndef DIRECT_CONV_INT8x8_GENERIC_CONV_WRAPPER
#define DIRECT_CONV_INT8x8_GENERIC_CONV_WRAPPER

#include "direct_conv_int8x8_generic_impl.hpp"

void run_conv_a8w8_qdq(KernelArgs& args)
{
    struct alignas(4) LayerParams
    {
        uint8_t zero_init;
        uint8_t final_tdm_iter;
        uint16_t wgt_size;
        uint16_t qdq_c0_size;
        uint16_t tdm1_addr;
        uint16_t tdm2_addr;
        uint16_t ifmsum_addr;
        uint16_t scratch_buf;
        uint16_t op_mode;
        uint16_t dummy;
        DirectConvInt8x8GenericKernelParams  kernel_params;
    };

    set_sat();
    set_rnd(rnd_conv_even);

    LayerParams* layer_params = static_cast<LayerParams*>(args.params_data);
    DirectConvInt8x8GenericKernelParams& kernel_params = layer_params->kernel_params;

    int zero_init = layer_params->zero_init;
    int final_tdm_iter = layer_params->final_tdm_iter;
    int op_mode = layer_params->op_mode;

    int8_t* input = static_cast<int8_t*>(args.s2mm_ch0_data);
    int8_t* weights = static_cast<int8_t*>(args.s2mm_ch1_data);
    int8_t* output = static_cast<int8_t*>(args.mm2s_ch0_data);

    int8_t* weights_unpack = static_cast<int8_t*>(conv_to_local_ptr(layer_params->scratch_buf));
    int32_t* tdm1 = static_cast<int32_t*>(conv_to_local_ptr(layer_params->tdm1_addr));
    int32_t* tdm2 = static_cast<int32_t*>(conv_to_local_ptr(layer_params->tdm2_addr));
    int32_t* ifm_sum = static_cast<int32_t*>(conv_to_local_ptr(layer_params->ifmsum_addr));

    int64_t* qdq_c0 = reinterpret_cast<int64_t*>(byte_incr(weights, layer_params->wgt_size));
    int32_t* qdq_params = reinterpret_cast<int32_t*>(byte_incr(weights, layer_params->wgt_size + (layer_params->qdq_c0_size) * sizeof(int64_t)));
    int32_t qdq_c1 = qdq_params[0];
    int32_t qdq_c2 = qdq_params[1];
    int32_t qdq_c3 = qdq_params[2];
    int32_t shift_res = qdq_params[3];
    int32_t c0 = 0;

    direct_conv_int8x8_generic<true, true, true, true>
    (
        input,
        weights,
        weights_unpack,
        tdm1,
        tdm2,
        ifm_sum,
        qdq_c0,
        output,
        zero_init,
        final_tdm_iter,
        op_mode,
        c0,
        qdq_c1,
        qdq_c2,
        qdq_c3,
        shift_res,
        kernel_params
    );

}
#endif// DIRECT_CONV_INT8x8_GENERIC_CONV_WRAPPER