#ifndef __ACCESS_CASC_STREAM_H__
#define __ACCESS_CASC_STREAM_H__

volatile int chess_storage(TM:0xB6060) casc_mode;


inline __attribute__((always_inline))
v16accfloat read_casc_stream()
{
    return extract_v16accfloat(get_scd_expand_v32accfloat(0), 0);
}

v16accfloat read_casc_stream( bool en )
{
    return  get_scd_v16accfloat( en );
}

inline __attribute__((always_inline))
void write_casc_stream(v16accfloat& v)
{
    //void put_mcd(v16accfloat a)	//put_mcd() [13/56]
    put_mcd(v);
}


inline __attribute__((always_inline))
v32accfloat read_casc_stream_32_lane()
{
        return get_scd_v32accfloat(1);
}


inline __attribute__((always_inline))
void write_casc_stream_32_lane(v32accfloat& v0)
{
        put_mcd(v32int32(v0));
}

#endif
