/*
    Copyright (C) 2019 - 2022 Xilinx, Inc. All rights reserved.
    Copyright (C) 2022 - 2024 Advanced Micro Devices, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __C_TYPE_TEMPLATES_H__
#define __C_TYPE_TEMPLATES_H__

#include "pp.h"

#define CHECK_SIGN_u false
#define CHECK_SIGN_s true
#define CHECK_SIGN(sgn) PP_CAT3(CHECK_, SIGN_, sgn)

#define INT_SIGN_u  u
#define INT_SIGN_s
#define INT_SIGN(sgn) PP_CAT(INT_SIGN_, sgn)

#define TYPE_i4(sgn)  PP_CAT( INT_SIGN(sgn), int8_t )
#define TYPE_i8(sgn)  PP_CAT( INT_SIGN(sgn), int8_t )
#define TYPE_i16(sgn) PP_CAT( INT_SIGN(sgn), int16_t )
#define TYPE_i32(sgn) PP_CAT( INT_SIGN(sgn), int32_t )
#define TYPE_i64(sgn) PP_CAT( INT_SIGN(sgn), int64_t )

#define TYPE_v64i4(sgn)   PP_CAT3(       v64,  INT_SIGN(sgn), int4 )
#define TYPE_v128i4(sgn)  PP_CAT3(       v128, INT_SIGN(sgn), int4 )
#define UNDEF_v64i4(sgn)  PP_CAT3( undef_v64,  INT_SIGN(sgn), int4 )()
#define UNDEF_v128i4(sgn) PP_CAT3( undef_v128, INT_SIGN(sgn), int4 )()

#define TYPE_v32i8(sgn)   PP_CAT3(       v32,  INT_SIGN(sgn), int8 )
#define TYPE_v64i8(sgn)   PP_CAT3(       v64,  INT_SIGN(sgn), int8 )
#define UNDEF_v32i8(sgn)  PP_CAT3( undef_v32,  INT_SIGN(sgn), int8 )()
#define UNDEF_v64i8(sgn)  PP_CAT3( undef_v64,  INT_SIGN(sgn), int8 )()

#define TYPE_v16i16(sgn)  PP_CAT3(       v16,  INT_SIGN(sgn), int16 )
#define TYPE_v32i16(sgn)  PP_CAT3(       v32,  INT_SIGN(sgn), int16 )
#define UNDEF_v16i16(sgn) PP_CAT3( undef_v16,  INT_SIGN(sgn), int16 )()
#define UNDEF_v32i16(sgn) PP_CAT3( undef_v32,  INT_SIGN(sgn), int16 )()

#define TYPE_v8i32(sgn)   PP_CAT3(       v8,   INT_SIGN(sgn), int32 )
#define TYPE_v16i32(sgn)  PP_CAT3(       v16,  INT_SIGN(sgn), int32 )
#define UNDEF_v8i32(sgn)  PP_CAT3( undef_v8,   INT_SIGN(sgn), int32 )()
#define UNDEF_v16i32(sgn) PP_CAT3( undef_v16,  INT_SIGN(sgn), int32 )()

#define VECS2_i8(sgn)     PP_CAT3(    Vecs2_,  INT_SIGN(sgn), i8 )
#define VECS2_i16(sgn)    PP_CAT3(    Vecs2_,  INT_SIGN(sgn), i16 )
#define VECS2_i32(sgn)    PP_CAT3(    Vecs2_,  INT_SIGN(sgn), i32 )

#define VECS4_i8(sgn)     PP_CAT3(    Vecs4_,  INT_SIGN(sgn), i8 )
#define VECS4_i16(sgn)    PP_CAT3(    Vecs4_,  INT_SIGN(sgn), i16 )
#define VECS4_i32(sgn)    PP_CAT3(    Vecs4_,  INT_SIGN(sgn), i32 )

#define SSRS(sgn)               PP_CAT( INT_SIGN(sgn), ssrs )
#define LSRS(sgn)               PP_CAT( INT_SIGN(sgn), lsrs )

#define BC_ELEM_8(sgn)          PP_CAT3( broadcast_, sgn, 8 )
#define BC_ELEM_16(sgn)         PP_CAT3( broadcast_, sgn, 16 )
#define BC_ELEM_32(sgn)         PP_CAT3( broadcast_, sgn, 32 )

#define SET_v128i4(sgn)         PP_CAT3( set_v128, INT_SIGN(sgn), int4 )
#define SET_v64i8(sgn)          PP_CAT3( set_v64,  INT_SIGN(sgn), int8 )
#define SET_v32i16(sgn)         PP_CAT3( set_v32,  INT_SIGN(sgn), int16 )
#define SET_v16i32(sgn)         PP_CAT3( set_v16,  INT_SIGN(sgn), int32 )

#define EXTRACT_v64i4(sgn)      PP_CAT3( extract_v64, INT_SIGN(sgn), int4 )
#define EXTRACT_v32i8(sgn)      PP_CAT3( extract_v32, INT_SIGN(sgn), int8 )
#define EXTRACT_v16i16(sgn)     PP_CAT3( extract_v16, INT_SIGN(sgn), int16 )
#define EXTRACT_v8i32(sgn)      PP_CAT3( extract_v8,  INT_SIGN(sgn), int32 )

#define NULL_v128i4(sgn)  ((TYPE_v128i4(sgn))BC_ELEM_8(sgn)(0))
#define NULL_v64i8(sgn)   BC_ELEM_8( sgn)(0)
#define NULL_v32i16(sgn)  BC_ELEM_16(sgn)(0)
#define NULL_v16i32(sgn)  BC_ELEM_32(sgn)(0)

#define NULL_v64i4(sgn)   EXTRACT_v64i4( sgn)(NULL_v128i4(sgn), 0)
#define NULL_v32i8(sgn)   EXTRACT_v32i8( sgn)(NULL_v64i8( sgn), 0)
#define NULL_v16i16(sgn)  EXTRACT_v16i16(sgn)(NULL_v32i16(sgn), 0)
#define NULL_v8i32(sgn)   EXTRACT_v8i32( sgn)(NULL_v16i32(sgn), 0)


#endif //__C_TYPE_TEMPLATES_H__

