// ess_shim.hpp
#pragma once
#include <cstddef>
#include <cstdint>

// Your original uses "uint"; make it an alias to a standard width.
using uint = uint32_t;

#ifdef __cplusplus
extern "C" {
#endif

// NOTE: keeping your exact signatures & behavior.
// If you ever see multiple-definition linker errors,
// change each function to `static inline`.

// write 32
void ess_Write32(uint64_t Addr, uint Data) {
  (void)Addr;
  (void)Data;
  return;
}

// read 32
uint32_t ess_Read32(uint64_t Addr) {
  (void)Addr;
  return 0;
}

// write 128
void ess_Write128(uint64_t Addr, uint32_t *Data) {
  (void)Addr;
  (void)Data;
  return;
}

// read 128
void ess_Read128(uint64_t Addr, uint32_t *Data) {
  (void)Addr;
  (void)Data;
  return;
}

// global memory helpers
void ess_WriteGM(uint64_t addr, const void *data, uint64_t size) {
  (void)addr;
  (void)data;
  (void)size;
  return;
}

void ess_ReadGM(uint64_t addr, void *data, uint64_t size) {
  (void)addr;
  (void)data;
  (void)size;
  return;
}

// command
void ess_WriteCmd(unsigned char Command, unsigned char ColId,
                  unsigned char RowId, unsigned int CmdWd0, unsigned int CmdWd1,
                  unsigned char *CmdStr) {
  (void)Command;
  (void)ColId;
  (void)RowId;
  (void)CmdWd0;
  (void)CmdWd1;
  (void)CmdStr;
  return;
}

// npi access
void ess_NpiWrite32(uint64_t Addr, uint Data) {
  (void)Addr;
  (void)Data;
  return;
}

uint ess_NpiRead32(uint64_t Addr) {
  (void)Addr;
  return 0;
}

#ifdef __cplusplus
} // extern "C"
#endif
