/*
    Copyright (C) 2019 - 2022 Xilinx, Inc. All rights reserved.
    Copyright (C) 2022 - 2024 Advanced Micro Devices, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: ( 1 ) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    ( 2 ) Xilinx shall not be liable ( whether in contract or tort,
    including negligence, or under any other theory of
    liability ) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    ( including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party ) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    ( individually and collectively, "Critical
    Applications" ). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __SPLIT_IO_HELPERS_H__
#define __SPLIT_IO_HELPERS_H__

#ifndef DIRECT_STREAM_IO
#include "io_helpers.h"


void split_write_file( int8_t *output_a, int8_t *output_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "w+" );

    for ( int i=0; i < num/2; i++ ) {
        fprintf( fp, "%4d%c", output_a[i], new_line_per_min_bytes( i, sizeof( int8_t )));
    }
    for ( int i=0; i < num-num/2; i++ ) {
        fprintf( fp, "%4d%c", output_b[i], new_line_per_min_bytes( i, sizeof( int8_t )));
    }

    fclose( fp );
}

void split_write_file( uint8_t *output_a, uint8_t *output_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "w+" );

    for ( int i=0; i < num/2; i++ ) {
        fprintf( fp, "%4u%c", output_a[i], new_line_per_min_bytes( i, sizeof( uint8_t )));
    }
    for ( int i=0; i < num-num/2; i++ ) {
        fprintf( fp, "%4u%c", output_b[i], new_line_per_min_bytes( i, sizeof( uint8_t )));
    }

    fclose( fp );
}

void split_write_file( int16_t *output_a, int16_t *output_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "w+" );

    for ( int i=0; i < num/2; i++ ) {
        fprintf( fp, "%6d%c", output_a[i], new_line_per_min_bytes( i, sizeof( int16_t )));
    }
    for ( int i=0; i < num-num/2; i++ ) {
        fprintf( fp, "%6d%c", output_b[i], new_line_per_min_bytes( i, sizeof( int16_t )));
    }

    fclose( fp );
}

void split_write_file( uint16_t *output_a, uint16_t *output_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "w+" );

    for ( int i=0; i < num/2; i++ ) {
        fprintf( fp, "%6u%c", output_a[i], new_line_per_min_bytes( i, sizeof( uint16_t )));
    }
    for ( int i=0; i < num-num/2; i++ ) {
        fprintf( fp, "%6u%c", output_b[i], new_line_per_min_bytes( i, sizeof( uint16_t )));
    }

    fclose( fp );
}

void split_write_file( int32_t *output_a, int32_t *output_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "w+" );

    for ( int i=0; i < num/2; i++ ) {
        fprintf( fp, "%10d%c", output_a[i], new_line_per_min_bytes( i, sizeof( int32_t )));
    }
    for ( int i=0; i < num-num/2; i++ ) {
        fprintf( fp, "%10d%c", output_b[i], new_line_per_min_bytes( i, sizeof( int32_t )));
    }

    fclose( fp );
}

void split_write_file( uint32_t *output_a, uint32_t *output_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "w+" );

    for ( int i=0; i < num/2; i++ ) {
        fprintf( fp, "%10u%c", output_a[i], new_line_per_min_bytes( i, sizeof( uint32_t )));
    }
    for ( int i=0; i < num-num/2; i++ ) {
        fprintf( fp, "%10u%c", output_b[i], new_line_per_min_bytes( i, sizeof( uint32_t )));
    }

    fclose( fp );
}

void split_write_file( int64_t *output_a, int64_t *output_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "w+" );

    for ( int i=0; i < num/2; i++ ) {
        fprintf( fp, "%10lld%c", output_a[i], new_line_per_min_bytes( i, sizeof( int64_t )));
    }
    for ( int i=0; i < num-num/2; i++ ) {
        fprintf( fp, "%10lld%c", output_b[i], new_line_per_min_bytes( i, sizeof( int64_t )));
    }

    fclose( fp );
}

void split_write_file( uint64_t *output_a, uint64_t *output_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "w+" );

    for ( int i=0; i < num/2; i++ ) {
        fprintf( fp, "%10llu%c", output_a[i], new_line_per_min_bytes( i, sizeof( uint64_t )));
    }
    for ( int i=0; i < num-num/2; i++ ) {
        fprintf( fp, "%10llu%c", output_b[i], new_line_per_min_bytes( i, sizeof( uint64_t )));
    }

    fclose( fp );
}


void split_write_file( int8_t *output_a, int8_t *output_b, int num, bool sign, const char * filename ) {
    if ( sign ) split_write_file(           output_a,            output_b, num, filename );
    else      split_write_file(( uint8_t* )output_a, ( uint8_t* )output_b, num, filename );
}
void split_write_file( int16_t *output_a, int16_t *output_b, int num, bool sign, const char * filename ) {
    if ( sign ) split_write_file(           output_a,            output_b, num, filename );
    else      split_write_file(( uint16_t* )output_a, ( uint16_t* )output_b, num, filename );
}
void split_write_file( int32_t *output_a, int32_t *output_b, int num, bool sign, const char * filename ) {
    if ( sign ) split_write_file(           output_a,            output_b, num, filename );
    else      split_write_file(( uint32_t* )output_a, ( uint32_t* )output_b, num, filename );
}
void split_write_file( int64_t *output_a, int64_t *output_b, int num, bool sign, const char * filename ) {
    if ( sign ) split_write_file(           output_a,            output_b, num, filename );
    else      split_write_file(( uint64_t* )output_a, ( uint64_t* )output_b, num, filename );
}


void split_read_file( int8_t *dest_a, int8_t *dest_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "r" );
    int i = 0, re, ret;

    for ( ; i < num/2; ++i ) {
        ret = fscanf( fp, "%d", &re );
        assert( ret == 1 );
        *dest_a++ = re;
    }
    for ( ; i < num; ++i ) {
        ret = fscanf( fp, "%d", &re );
        assert( ret == 1 );
        *dest_b++ = re;
    }

    fclose( fp );
}

void split_read_file( int16_t *dest_a, int16_t *dest_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "r" );
    int i = 0, re, ret;

    for ( ; i < num/2; ++i ) {
        ret = fscanf( fp, "%d", &re );
        assert( ret == 1 );
        *dest_a++ = re;
    }
    for ( ; i < num; ++i ) {
        ret = fscanf( fp, "%d", &re );
        assert( ret == 1 );
        *dest_b++ = re;
    }

    fclose( fp );
}

void split_read_file( int32_t *dest_a, int32_t *dest_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "r" );
    int i = 0, re, ret;

    for ( ; i < num/2; ++i ) {
        ret = fscanf( fp, "%d", &re );
        assert( ret == 1 );
        *dest_a++ = re;
    }
    for ( ; i < num; ++i ) {
        ret = fscanf( fp, "%d", &re );
        assert( ret == 1 );
        *dest_b++ = re;
    }

    fclose( fp );
}

void split_read_file( int64_t *dest_a, int64_t *dest_b, int num, const char* filename )
{
    FILE *fp = open_file( filename, "r" );
    int i = 0, ret;
    int64_t re;

    for ( ; i < num/2; ++i ) {
        ret = fscanf( fp, "%lld", &re );
        assert( ret == 1 );
        *dest_a++ = re;
    }
    for ( ; i < num; ++i ) {
        ret = fscanf( fp, "%lld", &re );
        assert( ret == 1 );
        *dest_b++ = re;
    }

    fclose( fp );
}


#else //DIRECT_STREAM_IO

#define split_write_file( ptr_a, ptr_b, size, ... ) write_stream( ptr_a, ptr_b, size*sizeof( *ptr_a ))
#define split_read_file( ptr_a, ptr_b, size, ... ) read_stream( ptr_a, ptr_b, size*sizeof( *ptr_a ))

inline void write_stream( void *output_a, void *output_b, int size )
{
    for ( int i=0; i < ( size+3 )/8; i++ ) chess_prepare_for_pipelining put_ms((( int* )output_a )[i] );
    for ( int i=0; i < ( size+7 )/8; i++ ) chess_prepare_for_pipelining put_ms((( int* )output_b )[i] );
}

inline void read_stream( void *dest_a, void *dest_b, int size )
{
    for ( int i=0; i < ( size+3 )/8; i++ ) chess_prepare_for_pipelining (( int* )dest_a )[i] = get_ss( );
    for ( int i=0; i < ( size+7 )/8; i++ ) chess_prepare_for_pipelining (( int* )dest_b )[i] = get_ss( );
}

#endif //DIRECT_STREAM_IO
#endif //__SPLIT_IO_HELPERS_H__
