/*
    Copyright (C) 2019 - 2022 Xilinx, Inc. All rights reserved.
    Copyright (C) 2022 - 2024 Advanced Micro Devices, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __TESTBENCH_HELPERS_H__
#define __TESTBENCH_HELPERS_H__

#include <stdint.h>
#include "pp.h"
#include "stringify.h"
#include "c_type_templates.h"

#define DIRECT_STREAM_IO

#if defined(NO_FILE_IO) && defined(FILE_IO)
#undef FILE_IO
#endif
#if (defined(NO_FILE_IO) || defined(NO_DIRECT_STREAM_IO)) && defined(DIRECT_STREAM_IO)
#undef DIRECT_STREAM_IO
#elif defined(DIRECT_STREAM_IO) && !defined(FILE_IO)
#define FILE_IO
#endif

#ifndef ITERATIONS
#define ITERATIONS 1
#endif
#ifndef LOCK_OFFSET
#define LOCK_OFFSET 48
#endif

#define INPUT_LOCK(X)       LOCK_OFFSET+(X)+8
#define WEIGHT_LOCK(X)      LOCK_OFFSET+(X)+2
#define OUTPUT_LOCK(X)      LOCK_OFFSET+(X)+4
#define PARAM_LOCK(X)       LOCK_OFFSET+(X)+6
#define CASC_IN_LOCK        LOCK_OFFSET+10
#define CASC_OUT_LOCK       LOCK_OFFSET+11

#define EMPTY_LOCK 0
#define FULL_LOCK  1


#ifdef FILE_IO
    #include <stdio.h>
    #include <assert.h>

  #ifdef DIRECT_STREAM_IO
    void read_stream(void * buffer, int size) {
        for (int i=0; i<(size+3)/4; i++) chess_prepare_for_pipelining {
            ((int*)buffer)[i] = get_ss();
        }
    }
    void write_stream(void * buffer, int size) {
        for (int i=0; i<(size+3)/4; i++) chess_prepare_for_pipelining {
            put_ms(((int*)buffer)[i]);
        }
    }
    #define read_file( ptr, size, ...) read_stream( ptr, size*sizeof(*ptr))
    #define write_file(ptr, size, ...) write_stream(ptr, size*sizeof(*ptr))

  #else
    #include "io_helpers.h"

    #if !ITERATIONS
    #define ADD_INDEX(str, iter) STRINGIFY(PP_CAT(DATA_PATH,str))
    #else
    char* add_index_str(const char* str, int len, int iter) {
        static char str_buf[320];
        assert(len<320-4);
        int ret = sprintf(str_buf, str, iter);
        return str_buf;
    }
    char* add_size_str(const char* str, int len) {
        static char str_buf[320];
        assert(len<320-4);
        bool skip = false;
        int p = 0;
        for (int i=0; i<len; i++) {
            if (str[i] == '%') {
                str_buf[p++] = 's';
                str_buf[p++] = 'i';
                str_buf[p++] = 'z';
                str_buf[p++] = 'e';
                skip = true;
            } else if (skip)
                skip = false;
            else
                str_buf[p++] = str[i];
        }
        return str_buf;
    }
    #define ADD_INDEX(str, iter) add_index_str(STRINGIFY(DATA_PATH) STRINGIFY(str), sizeof(STRINGIFY(DATA_PATH) STRINGIFY(str)), iter)
    #define ADD_SIZE( str      ) add_size_str( STRINGIFY(DATA_PATH) STRINGIFY(str), sizeof(STRINGIFY(DATA_PATH) STRINGIFY(str)))
    #endif
  #endif
#endif

#ifndef NULL
#define NULL ((void*)0)
#endif

#ifndef BITSW
  #ifdef BITSB
    #define BITSW BITSB
  #else
    #define BITSW BITSA
  #endif
#endif

#define BITS_KC_ZERO       8
#define BITS_KC_RESULT4    8
#define BITS_KC_RESULT8    8
#ifdef EBS
#define BITS_KC_RESULT16   8
#else
#define BITS_KC_RESULT16   16
#endif
#define BITS_KC_RESULT32   32
#define BITS_KC_RESULT32_CASC 32
#ifndef BFLOAT
#define BITS_KC_CASC       PP_IFOR(PP_CMP(BITSA, 8), PP_CMP(BITSA, 4), 32, 64)
#else
#define BITS_KC_CASC       32
#endif
#define BITS_KC_CASC2      PP_IFOR(PP_CMP(BITSA, 8), PP_CMP(BITSA, 4), 16, 32)
#define BITS_KC_TDM16      16
#define BITS_KC_TDM32      32
#define BITS_KC_TDM64      64
#define BITS_KC_TDM16_CASC 16
#define BITS_KC_TDM32_CASC 32
#define BITS_KC_TDM64_CASC 64
#define BITS_KC_TDM16_CASC2 16
#define BITS_KC_TDM32_CASC2 32
#define BITS_KC_TDM64_CASC2 64
#define BITS(MODE) PP_CAT(BITS_, MODE)

#define STEP_SIZE_KC_ZERO       max(max(1,BITSA/8), BITSW/8)
#define STEP_SIZE_KC_RESULT4    1
#define STEP_SIZE_KC_RESULT8    1
#define STEP_SIZE_KC_RESULT16   2
#define STEP_SIZE_KC_RESULT32   4
#define STEP_SIZE_KC_RESULT32_CASC 4
#define STEP_SIZE_KC_CASC       STEP_SIZE_KC_ZERO
#define STEP_SIZE_KC_TDM16      STEP_SIZE_KC_ZERO
#define STEP_SIZE_KC_TDM32      STEP_SIZE_KC_ZERO
#define STEP_SIZE_KC_TDM64      STEP_SIZE_KC_ZERO
#define STEP_SIZE_KC_TDM16_CASC STEP_SIZE_KC_ZERO
#define STEP_SIZE_KC_TDM32_CASC STEP_SIZE_KC_ZERO
#define STEP_SIZE_KC_TDM64_CASC STEP_SIZE_KC_ZERO
#define STEP_SIZE(MODE) PP_CAT(STEP_SIZE_, MODE)

#define BITS_TDM                    BITS_TDM_I( BITS( IN_MODE ), BITS( OUT_MODE ), BITS( KC_CASC ))
#define BITS_TDM_I( in, out, casc ) BITS_TDM_II( PP_MIN( in, out ), PP_MAX( in, out ), casc, PP_DIV( casc, 2 ))
#define BITS_TDM_II( min, max, casc, casc2 ) PP_IFOR( PP_LT( min, casc2 ), PP_NOT( PP_CMP( max, casc )), max, min )

#ifdef EBS
    #define OUT_T   int8_t
    #define INA_T   int8_t
    #define INW_T   int8_t
#else
    #define OUT_T   PP_CAT(TYPE_i,BITS(OUT_MODE))(s)
    #define INA_T   PP_CAT(TYPE_i,BITSA)(s)
    #if defined(COMPRW) || defined(SPARSE)
        #define INW_T   int8_t
    #else
        #define INW_T   PP_CAT(TYPE_i,BITSW)(s)
    #endif
#endif
#define OTDM_T  PP_CAT(TYPE_i,BITS(OUT_MODE))(s)
#define ITDM_T  PP_CAT(TYPE_i,BITS(IN_MODE))(s)
#define IOTDM_T PP_CAT(TYPE_i,BITS_TDM)(s)

#define SCALE_A(x) ((x)*BITSA/8/sizeof(INA_T))
#define SCALE_W(x) ((x)*BITSW/8/sizeof(INW_T))
#define IS_TDM(MODE)  (MODE == KC_TDM16 || MODE == KC_TDM32 || MODE == KC_RESULT32 || MODE == KC_TDM64 || MODE == KC_TDM16_CASC || MODE == KC_TDM32_CASC || MODE == KC_RESULT32_CASC || MODE == KC_TDM64_CASC)
#define IS_CASC(MODE) (MODE == KC_CASC                                                                 || MODE == KC_TDM16_CASC || MODE == KC_TDM32_CASC || MODE == KC_RESULT32_CASC || MODE == KC_TDM64_CASC)


#endif //__TESTBENCH_HELPERS_H__
