/*
    Copyright (C) 2019 - 2022 Xilinx, Inc. All rights reserved.
    Copyright (C) 2022 - 2024 Advanced Micro Devices, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __TREE_ADD_H__
#define __TREE_ADD_H__

#include "kernel_helpers.h"

const int tree_acuracy = 21; // Valid are 8 ( bf16 ), 21 ( 3x bfp16 ), 24 ( fp32 )


inline v16accfloat tree_add_8x8 ( v64accfloat acc ) {
    if ( tree_acuracy == 8 ) {
        v32bfloat16 ones = broadcast_bfloat16( 1.0 );
        v32accfloat sum;
        v32bfloat16 bf0, bf1;
        bf0 = to_v32bfloat16( extract_v32accfloat( acc, 0 ));
        bf1 = to_v32bfloat16( extract_v32accfloat( acc, 1 ));
        sum = to_v32accfloat( shuffle( bf0, bf1, T16_8x8_lo ));
        sum = mac_elem_32(    shuffle( bf0, bf1, T16_8x8_hi ), ones, sum );
        sum += set_v32accfloat( 0, extract_v16accfloat( sum, 1 ));
        sum += set_v32accfloat( 0, shuffle( extract_v16accfloat( sum, 0 ), T256_2x2_hi ));
        return extract_v16accfloat( sum, 0 );

    } else if ( tree_acuracy == 21 ) {
        v64bfp16ebs8 eye, sum_mat;
        eye  = insert( eye,  0, get_expo( 0 ));
        eye  = insert( eye,  1, get_expo( 0 ));
        eye  = insert( eye, sel( broadcast_zero_s8( ), broadcast_s8( 0x40 ), 0x8040201008040201ll ));
        sum_mat = insert( eye, sel( broadcast_zero_s8( ), broadcast_s8( 0x40 ), 0xFF ));

        v64accfloat sum;
        v64bfp16ebs8 bfp;
        bfp = to_v64bfp16ebs8( acc );
        acc = msc_8x8_8x8T( bfp, eye, acc );
        sum = mul_8x8_8x8T( sum_mat, bfp );
        bfp = to_v64bfp16ebs8( acc );
        acc = msc_8x8_8x8T( bfp, eye, acc );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = to_v64bfp16ebs8( acc );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        return extract_v16accfloat( sum, 0 );

    } else {
        v32accfloat accA, accB, accC;
        accA  = set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 0 ), extract_v16accfloat( acc, 1 ), T32_4x8_lo ));
        accA += set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 0 ), extract_v16accfloat( acc, 1 ), T32_4x8_hi ));
        accB  = set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 2 ), extract_v16accfloat( acc, 3 ), T32_4x8_lo ));
        accB += set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 2 ), extract_v16accfloat( acc, 3 ), T32_4x8_hi ));
        accC  = set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), extract_v16accfloat( accB, 0 ), T128_2x4_lo ));
        accC += set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), extract_v16accfloat( accB, 0 ), T128_2x4_hi ));
        accC += set_v32accfloat( 0, shuffle( extract_v16accfloat( accC, 0 ), T256_2x2_hi ));
        return extract_v16accfloat( accC, 0 );
    }
}

inline v16accfloat tree_add_4x8 ( v32accfloat acc ) {
    if ( tree_acuracy == 8 ) {
        v32bfloat16 ones = broadcast_bfloat16( 1.0 );
        v32accfloat sum;
        v32bfloat16 bf;
        bf = to_v32bfloat16( acc );
        sum = to_v32accfloat( shuffle( bf, T16_8x8_lo ));
        sum = mac_elem_32(    shuffle( bf, T16_8x8_hi ), ones, sum );
        sum += set_v32accfloat( 0, extract_v16accfloat( sum, 1 ));
        sum += set_v32accfloat( 0, shuffle( extract_v16accfloat( sum, 0 ), T256_2x2_hi ));
        return extract_v16accfloat( sum, 0 );

    } else if ( tree_acuracy == 21 ) {
        v64bfp16ebs8 eye, sum_mat;
        eye  = insert( eye,  0, get_expo( 0 ));
        eye  = insert( eye,  1, get_expo( 0 ));
        eye  = insert( eye, sel( broadcast_zero_s8( ), broadcast_s8( 0x40 ), 0x8040201008040201ll ));
        sum_mat = insert( eye, sel( broadcast_zero_s8( ), broadcast_s8( 0x40 ), 0xFF ));

        v64accfloat sum, rem = set_v64accfloat( 0, acc );
        v64bfp16ebs8 bfp;
        bfp = to_v64bfp16ebs8( rem );
        rem = msc_8x8_8x8T( bfp, eye, rem );
        sum = mul_8x8_8x8T( sum_mat, bfp );
        bfp = to_v64bfp16ebs8( rem );
        rem = msc_8x8_8x8T( bfp, eye, rem );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = to_v64bfp16ebs8( rem );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        return extract_v16accfloat( sum, 0 );

    } else {
        v32accfloat accA;
        accA  = set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 0 ), extract_v16accfloat( acc, 1 ), T32_4x8_lo ));
        accA += set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 0 ), extract_v16accfloat( acc, 1 ), T32_4x8_hi ));
        accA += set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), T256_2x2_hi ));
        accA += set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), T128_2x4_hi ));
        return extract_v16accfloat( accA, 0 );
    }
}

inline v16accfloat tree_add_2x4x8 ( v64accfloat acc ) {
    if ( tree_acuracy == 8 ) {
        v32bfloat16 ones = broadcast_bfloat16( 1.0 );
        v32accfloat sum;
        v32bfloat16 bf;
        bf = to_v32bfloat16( extract_v32accfloat( acc, 0 ) + extract_v32accfloat( acc, 1 ));
        sum = to_v32accfloat( shuffle( bf, T16_8x8_lo ));
        sum = mac_elem_32(    shuffle( bf, T16_8x8_hi ), ones, sum );
        sum += set_v32accfloat( 0, extract_v16accfloat( sum, 1 ));
        sum += set_v32accfloat( 0, shuffle( extract_v16accfloat( sum, 0 ), T256_2x2_hi ));
        return extract_v16accfloat( sum, 0 );

    } else if ( tree_acuracy == 21 ) {
        v64bfp16ebs8 eye, sum_mat;
        eye  = insert( eye,  0, get_expo( 0 ));
        eye  = insert( eye,  1, get_expo( 0 ));
        eye  = insert( eye, sel( broadcast_zero_s8( ), broadcast_s8( 0x40 ), 0x8040201008040201ll ));
        sum_mat = insert( eye, sel( broadcast_zero_s8( ), broadcast_s8( 0x40 ), 0xFF ));

        v64accfloat sum;
        v64bfp16ebs8 bfp;
        bfp = to_v64bfp16ebs8( acc );
        acc = msc_8x8_8x8T( bfp, eye, acc );
        sum = mul_8x8_8x8T( sum_mat, bfp );
        bfp = shuffle( bfp, T256_2x2_hi | T32_2x2_hi );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = to_v64bfp16ebs8( acc );
        acc = msc_8x8_8x8T( bfp, eye, acc );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = shuffle( bfp, T256_2x2_hi | T32_2x2_hi );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = to_v64bfp16ebs8( acc );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = shuffle( bfp, T256_2x2_hi | T32_2x2_hi );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        return extract_v16accfloat( sum, 0 );

    } else {
        v32accfloat accA, accB;
        accA  = extract_v32accfloat( acc, 0 ) + extract_v32accfloat( acc, 1 );
        accB  = set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), extract_v16accfloat( accA, 1 ), T32_4x8_lo ));
        accB += set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), extract_v16accfloat( accA, 1 ), T32_4x8_hi ));
        accB += set_v32accfloat( 0, shuffle( extract_v16accfloat( accB, 0 ), T256_2x2_hi ));
        accB += set_v32accfloat( 0, shuffle( extract_v16accfloat( accB, 0 ), T128_2x4_hi ));
        return extract_v16accfloat( accB, 0 );
    }
}



inline v16accfloat tree_add_8x8 ( v64accfloat acc, int scale ) {
    if ( tree_acuracy == 8 ) {
        v32bfloat16 ones = broadcast_bfloat16( inv( scale ));
        v32accfloat sum;
        v32bfloat16 bf0, bf1;
        bf0 = to_v32bfloat16( extract_v32accfloat( acc, 0 ));
        bf1 = to_v32bfloat16( extract_v32accfloat( acc, 1 ));
        sum = mul_elem_32( shuffle( bf0, bf1, T16_8x8_lo ), ones );
        sum = mac_elem_32( shuffle( bf0, bf1, T16_8x8_hi ), ones, sum );
        sum += set_v32accfloat( 0, extract_v16accfloat( sum, 1 ));
        sum += set_v32accfloat( 0, shuffle( extract_v16accfloat( sum, 0 ), T256_2x2_hi ));
        return extract_v16accfloat( sum, 0 );

    } else if ( tree_acuracy == 21 ) {
        v64bfp16ebs8 eye, sum_mat;
        eye  = insert( eye,  0, get_expo( 0 ));
        eye  = insert( eye,  1, get_expo( 0 ));
        eye  = insert( eye, sel( broadcast_zero_s8( ), broadcast_s8( 0x40 ), 0x8040201008040201ll ));
        sum_mat = to_v64bfp16ebs8( broadcast_to_v64float( inv( fix2float( scale ))));
        sum_mat = insert( sum_mat, sel( broadcast_zero_s8( ), extract_data( sum_mat ), 0xFF ));

        v64accfloat sum;
        v64bfp16ebs8 bfp;
        bfp = to_v64bfp16ebs8( acc );
        acc = msc_8x8_8x8T( bfp, eye, acc );
        sum = mul_8x8_8x8T( sum_mat, bfp );
        bfp = to_v64bfp16ebs8( acc );
        acc = msc_8x8_8x8T( bfp, eye, acc );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = to_v64bfp16ebs8( acc );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        return extract_v16accfloat( sum, 0 );

    } else {
        v32accfloat accA, accB, accC;
        accA  = set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 0 ), extract_v16accfloat( acc, 1 ), T32_4x8_lo ));
        accA += set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 0 ), extract_v16accfloat( acc, 1 ), T32_4x8_hi ));
        accB  = set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 2 ), extract_v16accfloat( acc, 3 ), T32_4x8_lo ));
        accB += set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 2 ), extract_v16accfloat( acc, 3 ), T32_4x8_hi ));
        accC  = set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), extract_v16accfloat( accB, 0 ), T128_2x4_lo ));
        accC += set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), extract_v16accfloat( accB, 0 ), T128_2x4_hi ));
        accC += set_v32accfloat( 0, shuffle( extract_v16accfloat( accC, 0 ), T256_2x2_hi ));
        v32bfloat16 ones = broadcast_bfloat16( inv( scale ));
        return extract_v16accfloat( mul_elem_32( to_v32bfloat16( accC ), ones ), 0 );
    }
}

inline v16accfloat tree_add_4x8 ( v32accfloat acc, int scale ) {
    if ( tree_acuracy == 8 ) {
        v32bfloat16 ones = broadcast_bfloat16( inv( scale ));
        v32accfloat sum;
        v32bfloat16 bf;
        bf = to_v32bfloat16( acc );
        sum = mul_elem_32( shuffle( bf, T16_8x8_lo ), ones );
        sum = mac_elem_32( shuffle( bf, T16_8x8_hi ), ones, sum );
        sum += set_v32accfloat( 0, extract_v16accfloat( sum, 1 ));
        sum += set_v32accfloat( 0, shuffle( extract_v16accfloat( sum, 0 ), T256_2x2_hi ));
        return extract_v16accfloat( sum, 0 );

    } else if ( tree_acuracy == 21 ) {
        v64bfp16ebs8 eye, sum_mat;
        eye  = insert( eye,  0, get_expo( 0 ));
        eye  = insert( eye,  1, get_expo( 0 ));
        eye  = insert( eye, sel( broadcast_zero_s8( ), broadcast_s8( 0x40 ), 0x8040201008040201ll ));
        sum_mat = to_v64bfp16ebs8( broadcast_to_v64float( inv( fix2float( scale ))));
        sum_mat = insert( sum_mat, sel( broadcast_zero_s8( ), extract_data( sum_mat ), 0xFF ));

        v64accfloat sum, rem = set_v64accfloat( 0, acc );
        v64bfp16ebs8 bfp;
        bfp = to_v64bfp16ebs8( rem );
        rem = msc_8x8_8x8T( bfp, eye, rem );
        sum = mul_8x8_8x8T( sum_mat, bfp );
        bfp = to_v64bfp16ebs8( rem );
        rem = msc_8x8_8x8T( bfp, eye, rem );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = to_v64bfp16ebs8( rem );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        return extract_v16accfloat( sum, 0 );

    } else {
        v32accfloat accA;
        accA  = set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 0 ), extract_v16accfloat( acc, 1 ), T32_4x8_lo ));
        accA += set_v32accfloat( 0, shuffle( extract_v16accfloat( acc, 0 ), extract_v16accfloat( acc, 1 ), T32_4x8_hi ));
        accA += set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), T256_2x2_hi ));
        accA += set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), T128_2x4_hi ));
        v32bfloat16 ones = broadcast_bfloat16( inv( scale ));
        return extract_v16accfloat( mul_elem_32( to_v32bfloat16( accA ), ones ), 0 );
    }
}

inline v16accfloat tree_add_2x4x8 ( v64accfloat acc, int scale ) {
    if ( tree_acuracy == 8 ) {
        v32bfloat16 ones = broadcast_bfloat16( inv( scale ));
        v32accfloat sum;
        v32bfloat16 bf;
        bf = to_v32bfloat16( extract_v32accfloat( acc, 0 ) + extract_v32accfloat( acc, 1 ));
        sum = mul_elem_32( shuffle( bf, T16_8x8_lo ), ones );
        sum = mac_elem_32( shuffle( bf, T16_8x8_hi ), ones, sum );
        sum += set_v32accfloat( 0, extract_v16accfloat( sum, 1 ));
        sum += set_v32accfloat( 0, shuffle( extract_v16accfloat( sum, 0 ), T256_2x2_hi ));
        return extract_v16accfloat( sum, 0 );

    } else if ( tree_acuracy == 21 ) {
        v64bfp16ebs8 eye, sum_mat;
        eye  = insert( eye,  0, get_expo( 0 ));
        eye  = insert( eye,  1, get_expo( 0 ));
        eye  = insert( eye, sel( broadcast_zero_s8( ), broadcast_s8( 0x40 ), 0x8040201008040201ll ));
        sum_mat = to_v64bfp16ebs8( broadcast_to_v64float( inv( fix2float( scale ))));
        sum_mat = insert( sum_mat, sel( broadcast_zero_s8( ), extract_data( sum_mat ), 0xFF ));

        v64accfloat sum;
        v64bfp16ebs8 bfp;
        bfp = to_v64bfp16ebs8( acc );
        acc = msc_8x8_8x8T( bfp, eye, acc );
        sum = mul_8x8_8x8T( sum_mat, bfp );
        bfp = shuffle( bfp, T256_2x2_hi | T32_2x2_hi );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = to_v64bfp16ebs8( acc );
        acc = msc_8x8_8x8T( bfp, eye, acc );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = shuffle( bfp, T256_2x2_hi | T32_2x2_hi );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = to_v64bfp16ebs8( acc );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        bfp = shuffle( bfp, T256_2x2_hi | T32_2x2_hi );
        sum = mac_8x8_8x8T( sum_mat, bfp, sum );
        return extract_v16accfloat( sum, 0 );

    } else {
        v32accfloat accA, accB;
        accA  = extract_v32accfloat( acc, 0 ) + extract_v32accfloat( acc, 1 );
        accB  = set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), extract_v16accfloat( accA, 1 ), T32_4x8_lo ));
        accB += set_v32accfloat( 0, shuffle( extract_v16accfloat( accA, 0 ), extract_v16accfloat( accA, 1 ), T32_4x8_hi ));
        accB += set_v32accfloat( 0, shuffle( extract_v16accfloat( accB, 0 ), T256_2x2_hi ));
        accB += set_v32accfloat( 0, shuffle( extract_v16accfloat( accB, 0 ), T128_2x4_hi ));
        v32bfloat16 ones = broadcast_bfloat16( inv( scale ));
        return extract_v16accfloat( mul_elem_32( to_v32bfloat16( accA ), ones ), 0 );
    }
}

#endif //__TREE_ADD_H__
