/*
    Copyright (C) 2019 - 2022 Xilinx, Inc. All rights reserved.
    Copyright (C) 2022 - 2025 Advanced Micro Devices, Inc. All rights reserved.
    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.
    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.
    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.
    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */

#ifndef __GLBSUM_H__
#define __GLBSUM_H__

#include <adf.h>
#include <aie_api/aie.hpp>
#include <aie_api/aie_adf.hpp>
#include <aie_api/utils.hpp>


#include "../include/access_casc_stream.h"


void __attribute__((noinline)) global_reduce_sum_int32xint32
(
	int8_t* input,
    int8_t* output,
	int8_t* tmpad,
	int num_iterations,
	int colIdx, //int rowIdx = (get_coreid() & 0xF);
	int rowIdx  //int colIdx = (get_coreid() >> 16);
)
{
	v16int32 v16x1_ucore;
	v16int32 v16x1_local;

	v16int32* pIn1          = (v16int32*)input ;
	v16int32* restrict pIn2 = (v16int32*)tmpad ;
	v16int32* pOut1_32b     = (v16int32*)tmpad ;
	v16int32* pOut2_32b     = (v16int32*)output;
	
	// 1st Pass : Vertical Reduction
	if( rowIdx > 2 )
	{
		for(int k = 0; k < num_iterations; k++)
		{
			v16x1_local = *pIn1++;
			v16x1_ucore = v16int32(read_casc_stream( rowIdx < 5 ));
			v16accfloat Tx_v = v16accfloat(add(v16x1_ucore, v16x1_local));
			write_casc_stream(Tx_v);
		}
	}
	else
	{
		for(int k = 0; k < num_iterations; k++)
		{
			v16x1_local = *pIn1++;
			v16x1_ucore  = v16int32(read_casc_stream());
			*pOut1_32b++ = add(v16x1_ucore, v16x1_local);
		}
	}

	// 2nd Pass : Horizontal Reduction
	if(rowIdx == 2)
	{
		casc_mode = 0x00000003;
		if(colIdx == 0)    //  Top row tiles : Type D
		{
			for(int k = 0; k < num_iterations; k++)
			{
				v16x1_local = *pIn2++;
				v16accfloat Tx_v = v16accfloat(v16x1_local);
				write_casc_stream(Tx_v);
			}
		}
		else if(colIdx == 1 || colIdx == 2)
		{
			for(int k = 0; k < num_iterations; k++)
			{
				v16x1_local = *pIn2++;
				v16x1_ucore = v16int32(read_casc_stream());
				v16accfloat Tx_v = v16accfloat(add(v16x1_ucore, v16x1_local));
				write_casc_stream(Tx_v);
			}
		}
		else // colIdx == 3
		{
			for(int k = 0; k < num_iterations; k++)
			{
				v16x1_local = *pIn2++;
				v16x1_ucore = v16int32(read_casc_stream());
				*pOut2_32b++ = v16int32(add(v16x1_ucore, v16x1_local)); 
			}
		}
		casc_mode = 0x00000000;
	}
}
#endif