/*
    Copyright (C) 2019 - 2022 Xilinx, Inc. All rights reserved.
    Copyright (C) 2022 - 2025 Advanced Micro Devices, Inc. All rights reserved.

    This file contains confidential and proprietary information
    of Xilinx, Inc. and is protected under U.S. and
    international copyright and other intellectual property
    laws.

    DISCLAIMER
    This disclaimer is not a license and does not grant any
    rights to the materials distributed herewith. Except as
    otherwise provided in a valid license issued to you by
    Xilinx, and to the maximum extent permitted by applicable
    law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
    WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
    AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
    BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
    INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
    (2) Xilinx shall not be liable (whether in contract or tort,
    including negligence, or under any other theory of
    liability) for any loss or damage of any kind or nature
    related to, arising under or in connection with these
    materials, including for any direct, or any indirect,
    special, incidental, or consequential loss or damage
    (including loss of data, profits, goodwill, or any type of
    loss or damage suffered as a result of any action brought
    by a third party) even if such damage or loss was
    reasonably foreseeable or Xilinx had been advised of the
    possibility of the same.

    CRITICAL APPLICATIONS
    Xilinx products are not designed or intended to be fail-
    safe, or for use in any application requiring fail-safe
    performance, such as life-support or safety devices or
    systems, Class III medical devices, nuclear facilities,
    applications related to the deployment of airbags, or any
    other applications that could lead to death, personal
    injury, or severe property or environmental damage
    (individually and collectively, "Critical
    Applications"). Customer assumes the sole risk and
    liability of any use of Xilinx products in Critical
    Applications, subject only to applicable laws and
    regulations governing limitations on product liability.

    THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
    PART OF THIS FILE AT ALL TIMES.                       */
#ifndef __LP_NORM_COL_SPLIT_H__
#define __LP_NORM_COL_SPLIT_H__

#define IFM_SIGNED 0x0001
#define OFM_SIGNED 0x0010
#define IFM_16BITS 0x0100
#define OFM_16BITS 0x1000

template<int CORE_TILE_HIN = 8, int PVAL = 2>
inline __attribute__((always_inline)) void lp_norm_col_split
(
        bfloat16 * restrict input,
        bfloat16 * restrict output,
        int Nsubv,
        int split_type,
        const int rowIdx, const int colIdx
)
{

    const int PER_ITERATION_ROW_BLOCK = 8;
    const int WIDTH_ALIGNMENT = 8;
    const int num_input_lanes = 64;
    const int num_output_lanes = num_input_lanes / 2;

    v32bfloat16 mac_op_1_values[2];
    v32bfloat16 mac_op_2_values[2];

    const float eps = EPSILON;
    // Accumulation happens for 8x8 block to reduce to 8x1. To reduce error accumulation due to reduction
    // Scale factor of 8 is used: EPS / 8
    aie::accum<accfloat,64> temp_broadcast( aie::broadcast<bfloat16, 64>( eps / 8.0 )); 

    auto inIter1 = aie::begin_vector<num_input_lanes>(input);
    auto inIter2 = aie::begin_vector<num_input_lanes>(input);
    auto outIter = aie::begin_vector<num_input_lanes>(output);

    for (int Row_Block = 0; Row_Block < (CORE_TILE_HIN / PER_ITERATION_ROW_BLOCK); ++Row_Block)
    chess_prepare_for_pipelining
    {

        // Per-Iteration Layer Normalization on a 16x128 block of the Input Buffer
        v64accfloat sum = temp_broadcast.to_native();
        
        v32bfloat16 one_32_lane = broadcast_bfloat16( 1.0 );
        v64bfloat16 one_64_lane = concat( one_32_lane, one_32_lane);

        // ------------------------------  Stage 1: Local Sums and Sums of Squares ---------------------------

        // Element wise accumulation  for each 8x8 block across the columns for each value in the input buffer as well as its squared value
        // sum -> top 8x8 block accumulated sum

        for (int block_8x8 = 0; block_8x8 < (Nsubv / WIDTH_ALIGNMENT); ++block_8x8)
        //chess_prepare_for_pipelining
        chess_no_hw_loop
        {
            v64bfloat16 one_8x8 = *inIter1++;
            
            if constexpr (PVAL == 1){
                sum = mac_elem_64_conf(one_8x8, one_64_lane, sum, 0, 0, 0);
            } else{
                sum = mac_elem_64_conf(one_8x8, one_8x8, sum, 0, 0, 0);
            }
        }


        // Reduce each 8x8 block to an 8x1 block by summing across the columns
        v16accfloat sums_block = tree_add_8x8(sum);

        v8accfloat local_sum_sq = extract_v8accfloat(sums_block, 0);
        v16accfloat local_sums = concat(local_sum_sq, local_sum_sq); //TODO: Use insert

        v16accfloat rec_sum;
        v16accfloat write_inter_sum;

        v16accfloat mac_op_1;

        // ------------------------------  Stage 2 : Divergent Stage: -------------------------------------
        //                                Accumulate a per-row global sum

        mac_op_1 = local_sums;
        if(split_type)
            mac_op_1 = global_add_reduce( local_sums, rowIdx, colIdx );
        
#if 0
    if(rowIdx == 2 && colIdx == 0)
    {
        aie::print(aie::accum<accfloat, 16>(mac_op_1), true, "variance = ");
        //aie::print(aie::accum<accfloat, 16>(*(v16accfloat*)(addr_var+16)), true, "variance = ");
        printf("--------------------------------------------------\n");
    }
#endif
        // ----------------------------------  Stage 3: Normlization Step ------------------------------------------
        // Use the per-row global sums to calculate the final normalized values


        // Calculate per row values of:
        //
        //              gamma                            epsilon- * gamma
        //      -------------------------  , beta  -    -------------------
        //       sqrt(Var[x] + epsilon)                 sqrt(Var[x] + epsilon)
        //
        // from the global sum and sums of square column vectors


        v16float tmp;
        for(int i = 0; i < 4; i++) 
        //chess_prepare_for_pipelining
        chess_no_hw_loop
        {
            v2float in = extract_v2float( v16float(mac_op_1), i );
            if constexpr (PVAL == 1){
                v2float out = set_v2float( 0, inv( extract_elem( in, 0 )));
                out = insert( out, 1, inv( extract_elem( in, 1 )));
                tmp = insert( tmp, i, out );
            } else{
                v2float out = set_v2float( 0, invsqrt( extract_elem( in, 0 )));
                out = insert( out, 1, invsqrt( extract_elem( in, 1 )));
                tmp = insert( tmp, i, out );
            }
        }

        v16accfloat invsqrt_val = v16accfloat(tmp);
        v16accfloat invsqrt_val2 = invsqrt_val;

        v32bfloat16 operand_1 = to_v32bfloat16(concat(invsqrt_val2, invsqrt_val));
        mac_op_1_values[0] = shuffle( broadcast_to_v32bfloat16( extract_v4bfloat16( operand_1, 0 )), T16_8x4 );
        mac_op_1_values[1] = shuffle( broadcast_to_v32bfloat16( extract_v4bfloat16( operand_1, 1 )), T16_8x4 );

        v64bfloat16 mac_op_1_st3 = concat(mac_op_1_values[0], mac_op_1_values[1]);

        for (int block_8x8 = 0; block_8x8 < (Nsubv / WIDTH_ALIGNMENT); block_8x8++)
        //chess_prepare_for_pipelining
        chess_no_hw_loop
        {
            aie::vector<bfloat16, num_input_lanes> res = to_v64bfloat16(mul_elem_64(*inIter2++, mac_op_1_st3));
            *outIter++ = res;
        }
    }
}

template<int PVAL = 1>
inline __attribute__((always_inline)) void run_lpnorm_col_split_qdq(KernelArgs& args)
{
    set_rnd(rnd_conv_even);
    const aie::saturation_mode sat = aie::tile::current().get_saturation();
    aie::tile::current().set_saturation(aie::saturation_mode::saturate);
    const int MSUB = 8;
    bfloat16 * matA   = static_cast<bfloat16*>(args.s2mm_ch0_data);
    int8_t * wgt   = static_cast<int8_t*>(args.s2mm_ch1_data);
    int8_t * output = static_cast<int8_t*>(args.mm2s_ch0_data);
    int rowIdx = (get_coreid() & 0xF);
    //int colIdx = (get_coreid() >> 16);
    uint16_t* args_params   = (uint16_t*)args.params_data;
    uint16_t Nlrn           = args_params[0];
    uint16_t Nsubv          = args_params[1];
    uint16_t colIdx         =  args_params[2]; 
    uint16_t split_type     = args_params[3]; // 0-> row split ; 1 -> col_split
    uint16_t sign_type      = args_params[4];

    bool in_sign      = sign_type & IFM_SIGNED; // true --> IFM Signed
    bool out_sign     = sign_type & OFM_SIGNED; // true --> OFM Signed
    bool is_in_int16  = sign_type & IFM_16BITS; // true --> IFM 16 bits 
    bool is_out_int16 = sign_type & OFM_16BITS; // true --> OFM 16 bits
    
    bfloat16 s_out   = *(bfloat16 *) (wgt);
    uint16_t zp_out  = *(uint16_t *) (wgt + 4);
    bool quant_en    = *(bool *) (wgt + 8);
    bfloat16 s_in    = *(bfloat16 *) (wgt + 12);  
    uint16_t zp_in   = *(uint16_t *) (wgt + 16);
    bool dequant_en  = *(bool *) (wgt + 20);

    bfloat16* lpnorm_in_ptr = (bfloat16 *) matA;
    // Overwrite the lrn input pointer for in-place compute 
    if(dequant_en){
        lpnorm_in_ptr  = (bfloat16 *) output;
    }
    bfloat16* lpnorm_out_ptr = (bfloat16 *) output;

    dequant_int16_to_bf16((int8_t *)matA, (int8_t *)output, MSUB*Nsubv, zp_in, s_in, in_sign, dequant_en, is_in_int16);

    lp_norm_col_split<MSUB, PVAL>(lpnorm_in_ptr, lpnorm_out_ptr, Nsubv, split_type, rowIdx, colIdx);
    
    quant_bf16_to_int16(output, output, MSUB*Nsubv, zp_out, s_out, out_sign, quant_en, is_out_int16);

#if 0 
    bfloat16 * input_pt = matA;
    bfloat16 * output_pt = (bfloat16 *)output;
    for(int ii = 0; ii < MSUB*Nsubv; ii++)
    {
        output_pt[ii] = input_pt[ii];
    }
#endif
}

#endif

