import numpy as np
from kernel_lib.python.data_generator.data_converter import DataConverter

def create_avgpool_weights( param ):
    c = DataConverter( )
    H = param["subvolume"]["H"]
    W = param["subvolume"]["W"]
    C = param["subvolume"]["C"]
    ky = param["subvolume"]["Kh"]
    kx = param["subvolume"]["Kw"]
    pt = param["subvolume"]["PT"]
    pb = param["subvolume"]["PB"]
    pl = param["subvolume"]["PL"]
    pr = param["subvolume"]["PR"]
    
    wghts = np.full(( H, W, C ), ( 1 / ( ky * kx ))).astype( np.float32 )
    # Adjust borders
    # First row
    wghts[0, :, :]   = (1/((ky-pt)*kx))
    # Last row
    wghts[-1, :, :]  = (1/((ky-pb)*kx))
    # Fist column
    wghts[:, 0, :]   = (1/(ky*(kx-pl)))
    # Last column
    wghts[:, -1, :]  = (1/(ky*(kx-pr)))
    # Adjust corners
    wghts[0, 0, :]   = (1/((ky-pt)*(kx-pl)))
    wghts[0, -1, :]  = (1/((ky-pt)*(kx-pr)))
    wghts[-1, 0, :]  = (1/((ky-pb)*(kx-pl)))
    wghts[-1, -1, :] = (1/((ky-pb)*(kx-pr)))
    return c.srs( wghts, 0, 16, bfloat=True, float_to_int=False )  