import numpy as np
from kernel_lib.python.data_generator.data_converter import DataConverter

def pooling_op( kernel, scale ):
    res = np.sum( kernel ) * scale
    return res.astype( np.float32 )

def model(ifm, wgt, param):
    c = DataConverter( )
    H  = param.H
    W  = param.W
    C  = param.C
    ky = param.Kh
    kx = param.Kw
    sy  = param.Sh
    sx  = param.Sw
    
    r = np.zeros( shape=( H, W, C ))
    
    for y in range( H ):
        for x in range( W ):
            for o in range( C ):
                window = ifm[y*sy:y*sy+ky, x*sx:x*sx+kx, o]
                r[y, x, o] = pooling_op( window, wgt[y, x, o] )
                
    return c.srs( r, 0, 16, bfloat=True, float_to_int=False )