import numpy as np

def model(ifm, param):
    H  = param.H
    W  = param.W
    C  = param.C
    ky = param.Kh
    kx = param.Kw
    sy  = param.Sh
    sx  = param.Sw

    r = np.zeros( shape=( H, W, C ), dtype=( np.long ))

    for y in range( H ):
        for x in range( W ):
            for o in range( C ):
                window = ifm[y*sy:y*sy+ky, x*sx:x*sx+kx, o]
                r[y, x, o] = np.max( window )

    return r