#ifndef GELU_LUT_BF16_512_H
#define GELU_LUT_BF16_512_H

namespace gelu_bf16 {
	const int lut_sz = 160*2;
	static const uint16_t lnr_lutab[lut_sz*2*2]={
	0x0000 , 0x0000 , 0xb841 , 0xb716 , 0xb85f , 0xb72e , 0xb880 , 0xb749 , 0xb893 , 0xb769 , 0xb8a9 , 0xb786 , 0xb8c2 , 0xb79b , 0xb8df , 0xb7b3 , 
	0x0000 , 0x0000 , 0xb841 , 0xb716 , 0xb85f , 0xb72e , 0xb880 , 0xb749 , 0xb893 , 0xb769 , 0xb8a9 , 0xb786 , 0xb8c2 , 0xb79b , 0xb8df , 0xb7b3 , 
	0xb8ff , 0xb7ce , 0xb912 , 0xb7ed , 0xb926 , 0xb808 , 0xb93e , 0xb81c , 0xb959 , 0xb833 , 0xb977 , 0xb84e , 0xb98c , 0xb86b , 0xb99f , 0xb887 , 
	0xb8ff , 0xb7ce , 0xb912 , 0xb7ed , 0xb926 , 0xb808 , 0xb93e , 0xb81c , 0xb959 , 0xb833 , 0xb977 , 0xb84e , 0xb98c , 0xb86b , 0xb99f , 0xb887 , 
	0xb9b5 , 0xb89a , 0xb9cd , 0xb8af , 0xb9e8 , 0xb8c8 , 0xba03 , 0xb8e4 , 0xba15 , 0xb901 , 0xba28 , 0xb913 , 0xba3d , 0xb927 , 0xba55 , 0xb93d , 
	0xb9b5 , 0xb89a , 0xb9cd , 0xb8af , 0xb9e8 , 0xb8c8 , 0xba03 , 0xb8e4 , 0xba15 , 0xb901 , 0xba28 , 0xb913 , 0xba3d , 0xb927 , 0xba55 , 0xb93d , 
	0xba70 , 0xb957 , 0xba87 , 0xb973 , 0xba97 , 0xb989 , 0xbaaa , 0xb99b , 0xbabe , 0xb9af , 0xbad5 , 0xb9c5 , 0xbaee , 0xb9de , 0xbb05 , 0xb9f9 , 
	0xba70 , 0xb957 , 0xba87 , 0xb973 , 0xba97 , 0xb989 , 0xbaaa , 0xb99b , 0xbabe , 0xb9af , 0xbad5 , 0xb9c5 , 0xbaee , 0xb9de , 0xbb05 , 0xb9f9 , 
	0xbb14 , 0xba0c , 0xbb25 , 0xba1d , 0xbb38 , 0xba30 , 0xbb4d , 0xba45 , 0xbb63 , 0xba5c , 0xbb7c , 0xba76 , 0xbb8c , 0xba89 , 0xbb9b , 0xba99 , 
	0xbb14 , 0xba0c , 0xbb25 , 0xba1d , 0xbb38 , 0xba30 , 0xbb4d , 0xba45 , 0xbb63 , 0xba5c , 0xbb7c , 0xba76 , 0xbb8c , 0xba89 , 0xbb9b , 0xba99 , 
	0xbbab , 0xbaab , 0xbbbd , 0xbabe , 0xbbd0 , 0xbad3 , 0xbbe6 , 0xbaea , 0xbbfd , 0xbb02 , 0xbc0b , 0xbb10 , 0xbc19 , 0xbb1f , 0xbc27 , 0xbb30 , 
	0xbbab , 0xbaab , 0xbbbd , 0xbabe , 0xbbd0 , 0xbad3 , 0xbbe6 , 0xbaea , 0xbbfd , 0xbb02 , 0xbc0b , 0xbb10 , 0xbc19 , 0xbb1f , 0xbc27 , 0xbb30 , 
	0xbc37 , 0xbb42 , 0xbc49 , 0xbb56 , 0xbc5b , 0xbb6c , 0xbc70 , 0xbb82 , 0xbc83 , 0xbb8f , 0xbc8e , 0xbb9d , 0xbc9b , 0xbbac , 0xbca9 , 0xbbbd , 
	0xbc37 , 0xbb42 , 0xbc49 , 0xbb56 , 0xbc5b , 0xbb6c , 0xbc70 , 0xbb82 , 0xbc83 , 0xbb8f , 0xbc8e , 0xbb9d , 0xbc9b , 0xbbac , 0xbca9 , 0xbbbd , 
	0xbcb7 , 0xbbce , 0xbcc6 , 0xbbe2 , 0xbcd7 , 0xbbf6 , 0xbce9 , 0xbc06 , 0xbcfb , 0xbc12 , 0xbd08 , 0xbc1f , 0xbd12 , 0xbc2d , 0xbd1e , 0xbc3c , 
	0xbcb7 , 0xbbce , 0xbcc6 , 0xbbe2 , 0xbcd7 , 0xbbf6 , 0xbce9 , 0xbc06 , 0xbcfb , 0xbc12 , 0xbd08 , 0xbc1f , 0xbd12 , 0xbc2d , 0xbd1e , 0xbc3c , 
	0xbd29 , 0xbc4c , 0xbd36 , 0xbc5d , 0xbd43 , 0xbc6f , 0xbd51 , 0xbc81 , 0xbd60 , 0xbc8b , 0xbd70 , 0xbc96 , 0xbd80 , 0xbca2 , 0xbd88 , 0xbcae , 
	0xbd29 , 0xbc4c , 0xbd36 , 0xbc5d , 0xbd43 , 0xbc6f , 0xbd51 , 0xbc81 , 0xbd60 , 0xbc8b , 0xbd70 , 0xbc96 , 0xbd80 , 0xbca2 , 0xbd88 , 0xbcae , 
	0xbd91 , 0xbcbb , 0xbd9b , 0xbcc9 , 0xbda4 , 0xbcd7 , 0xbdae , 0xbce6 , 0xbdb9 , 0xbcf6 , 0xbdc4 , 0xbd03 , 0xbdcf , 0xbd0c , 0xbdda , 0xbd15 , 
	0xbd91 , 0xbcbb , 0xbd9b , 0xbcc9 , 0xbda4 , 0xbcd7 , 0xbdae , 0xbce6 , 0xbdb9 , 0xbcf6 , 0xbdc4 , 0xbd03 , 0xbdcf , 0xbd0c , 0xbdda , 0xbd15 , 
	0xbde6 , 0xbd1f , 0xbdf3 , 0xbd29 , 0xbdff , 0xbd33 , 0xbe06 , 0xbd3e , 0xbe0d , 0xbd49 , 0xbe13 , 0xbd54 , 0xbe1a , 0xbd60 , 0xbe21 , 0xbd6c , 
	0xbde6 , 0xbd1f , 0xbdf3 , 0xbd29 , 0xbdff , 0xbd33 , 0xbe06 , 0xbd3e , 0xbe0d , 0xbd49 , 0xbe13 , 0xbd54 , 0xbe1a , 0xbd60 , 0xbe21 , 0xbd6c , 
	0xbe28 , 0xbd79 , 0xbe2f , 0xbd83 , 0xbe36 , 0xbd89 , 0xbe3d , 0xbd90 , 0xbe45 , 0xbd97 , 0xbe4c , 0xbd9d , 0xbe53 , 0xbda4 , 0xbe5a , 0xbdab , 
	0xbe28 , 0xbd79 , 0xbe2f , 0xbd83 , 0xbe36 , 0xbd89 , 0xbe3d , 0xbd90 , 0xbe45 , 0xbd97 , 0xbe4c , 0xbd9d , 0xbe53 , 0xbda4 , 0xbe5a , 0xbdab , 
	0xbe61 , 0xbdb2 , 0xbe67 , 0xbdb9 , 0xbe6e , 0xbdc0 , 0xbe74 , 0xbdc7 , 0xbe7b , 0xbdcd , 0xbe80 , 0xbdd4 , 0xbe83 , 0xbdda , 0xbe86 , 0xbde0 , 
	0xbe61 , 0xbdb2 , 0xbe67 , 0xbdb9 , 0xbe6e , 0xbdc0 , 0xbe74 , 0xbdc7 , 0xbe7b , 0xbdcd , 0xbe80 , 0xbdd4 , 0xbe83 , 0xbdda , 0xbe86 , 0xbde0 , 
	0xbe89 , 0xbde6 , 0xbe8b , 0xbdec , 0xbe8d , 0xbdf1 , 0xbe8f , 0xbdf6 , 0xbe91 , 0xbdfa , 0xbe92 , 0xbdfe , 0xbe94 , 0xbe01 , 0xbe95 , 0xbe02 , 
	0xbe89 , 0xbde6 , 0xbe8b , 0xbdec , 0xbe8d , 0xbdf1 , 0xbe8f , 0xbdf6 , 0xbe91 , 0xbdfa , 0xbe92 , 0xbdfe , 0xbe94 , 0xbe01 , 0xbe95 , 0xbe02 , 
	0xbe96 , 0xbe03 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe03 , 0xbe95 , 0xbe02 , 0xbe94 , 0xbe01 , 0xbe93 , 0xbdfe , 
	0xbe96 , 0xbe03 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe03 , 0xbe95 , 0xbe02 , 0xbe94 , 0xbe01 , 0xbe93 , 0xbdfe , 
	0xbe91 , 0xbdf8 , 0xbe8f , 0xbdf2 , 0xbe8d , 0xbdeb , 0xbe8b , 0xbde2 , 0xbe88 , 0xbdd8 , 0xbe85 , 0xbdcd , 0xbe81 , 0xbdc0 , 0xbe7c , 0xbdb2 , 
	0xbe91 , 0xbdf8 , 0xbe8f , 0xbdf2 , 0xbe8d , 0xbdeb , 0xbe8b , 0xbde2 , 0xbe88 , 0xbdd8 , 0xbe85 , 0xbdcd , 0xbe81 , 0xbdc0 , 0xbe7c , 0xbdb2 , 
	0xbe74 , 0xbda3 , 0xbe6c , 0xbd92 , 0xbe63 , 0xbd7e , 0xbe5a , 0xbd57 , 0xbe50 , 0xbd2c , 0xbe47 , 0xbcfb , 0xbe3d , 0xbc99 , 0xbe33 , 0xbbc0 , 
	0xbe74 , 0xbda3 , 0xbe6c , 0xbd92 , 0xbe63 , 0xbd7e , 0xbe5a , 0xbd57 , 0xbe50 , 0xbd2c , 0xbe47 , 0xbcfb , 0xbe3d , 0xbc99 , 0xbe33 , 0xbbc0 , 
	0xbe28 , 0x3bfb , 0xbe1e , 0x3cb4 , 0xbe13 , 0x3d17 , 0xbe08 , 0x3d58 , 0xbdfc , 0x3d8e , 0xbde7 , 0x3db1 , 0xbdd2 , 0x3dd6 , 0xbdbe , 0x3dfc , 
	0xbe28 , 0x3bfb , 0xbe1e , 0x3cb4 , 0xbe13 , 0x3d17 , 0xbe08 , 0x3d58 , 0xbdfc , 0x3d8e , 0xbde7 , 0x3db1 , 0xbdd2 , 0x3dd6 , 0xbdbe , 0x3dfc , 
	0xbdaa , 0x3e12 , 0xbd97 , 0x3e26 , 0xbd85 , 0x3e3b , 0xbd67 , 0x3e51 , 0xbd45 , 0x3e67 , 0xbd26 , 0x3e7d , 0xbd09 , 0x3e8a , 0xbcde , 0x3e96 , 
	0xbdaa , 0x3e12 , 0xbd97 , 0x3e26 , 0xbd85 , 0x3e3b , 0xbd67 , 0x3e51 , 0xbd45 , 0x3e67 , 0xbd26 , 0x3e7d , 0xbd09 , 0x3e8a , 0xbcde , 0x3e96 , 
	0xbcae , 0x3ea2 , 0xbc83 , 0x3eae , 0xbc3d , 0x3eba , 0xbbfd , 0x3ec7 , 0xbb98 , 0x3ed3 , 0xbb19 , 0x3ee0 , 0xba4c , 0x3eed , 0x2f66 , 0x3efa , 
	0xbcae , 0x3ea2 , 0xbc83 , 0x3eae , 0xbc3d , 0x3eba , 0xbbfd , 0x3ec7 , 0xbb98 , 0x3ed3 , 0xbb19 , 0x3ee0 , 0xba4c , 0x3eed , 0x2f66 , 0x3efa , 
	0x0000 , 0x3f03 , 0xba4c , 0x3f0a , 0xbb19 , 0x3f10 , 0xbb98 , 0x3f16 , 0xbbfd , 0x3f1d , 0xbc3d , 0x3f23 , 0xbc83 , 0x3f29 , 0xbcae , 0x3f2f , 
	0x0000 , 0x3f03 , 0xba4c , 0x3f0a , 0xbb19 , 0x3f10 , 0xbb98 , 0x3f16 , 0xbbfd , 0x3f1d , 0xbc3d , 0x3f23 , 0xbc83 , 0x3f29 , 0xbcae , 0x3f2f , 
	0xbcde , 0x3f35 , 0xbd09 , 0x3f3b , 0xbd26 , 0x3f41 , 0xbd45 , 0x3f46 , 0xbd67 , 0x3f4c , 0xbd85 , 0x3f51 , 0xbd97 , 0x3f56 , 0xbdaa , 0x3f5c , 
	0xbcde , 0x3f35 , 0xbd09 , 0x3f3b , 0xbd26 , 0x3f41 , 0xbd45 , 0x3f46 , 0xbd67 , 0x3f4c , 0xbd85 , 0x3f51 , 0xbd97 , 0x3f56 , 0xbdaa , 0x3f5c , 
	0xbdbe , 0x3f61 , 0xbdd2 , 0x3f65 , 0xbde7 , 0x3f6a , 0xbdfc , 0x3f6e , 0xbe08 , 0x3f72 , 0xbe13 , 0x3f77 , 0xbe1e , 0x3f7a , 0xbe28 , 0x3f7e , 
	0xbdbe , 0x3f61 , 0xbdd2 , 0x3f65 , 0xbde7 , 0x3f6a , 0xbdfc , 0x3f6e , 0xbe08 , 0x3f72 , 0xbe13 , 0x3f77 , 0xbe1e , 0x3f7a , 0xbe28 , 0x3f7e , 
	0xbe33 , 0x3f81 , 0xbe3d , 0x3f82 , 0xbe47 , 0x3f84 , 0xbe50 , 0x3f85 , 0xbe5a , 0x3f87 , 0xbe63 , 0x3f88 , 0xbe6c , 0x3f89 , 0xbe74 , 0x3f8a , 
	0xbe33 , 0x3f81 , 0xbe3d , 0x3f82 , 0xbe47 , 0x3f84 , 0xbe50 , 0x3f85 , 0xbe5a , 0x3f87 , 0xbe63 , 0x3f88 , 0xbe6c , 0x3f89 , 0xbe74 , 0x3f8a , 
	0xbe7c , 0x3f8b , 0xbe81 , 0x3f8c , 0xbe85 , 0x3f8d , 0xbe88 , 0x3f8e , 0xbe8b , 0x3f8e , 0xbe8d , 0x3f8f , 0xbe8f , 0x3f8f , 0xbe91 , 0x3f90 , 
	0xbe7c , 0x3f8b , 0xbe81 , 0x3f8c , 0xbe85 , 0x3f8d , 0xbe88 , 0x3f8e , 0xbe8b , 0x3f8e , 0xbe8d , 0x3f8f , 0xbe8f , 0x3f8f , 0xbe91 , 0x3f90 , 
	0xbe93 , 0x3f90 , 0xbe94 , 0x3f90 , 0xbe95 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 
	0xbe93 , 0x3f90 , 0xbe94 , 0x3f90 , 0xbe95 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 
	0xbe95 , 0x3f90 , 0xbe94 , 0x3f90 , 0xbe92 , 0x3f90 , 0xbe91 , 0x3f90 , 0xbe8f , 0x3f8f , 0xbe8d , 0x3f8f , 0xbe8b , 0x3f8f , 0xbe89 , 0x3f8e , 
	0xbe95 , 0x3f90 , 0xbe94 , 0x3f90 , 0xbe92 , 0x3f90 , 0xbe91 , 0x3f90 , 0xbe8f , 0x3f8f , 0xbe8d , 0x3f8f , 0xbe8b , 0x3f8f , 0xbe89 , 0x3f8e , 
	0xbe86 , 0x3f8e , 0xbe83 , 0x3f8e , 0xbe80 , 0x3f8d , 0xbe7b , 0x3f8d , 0xbe74 , 0x3f8c , 0xbe6e , 0x3f8c , 0xbe67 , 0x3f8c , 0xbe61 , 0x3f8b , 
	0xbe86 , 0x3f8e , 0xbe83 , 0x3f8e , 0xbe80 , 0x3f8d , 0xbe7b , 0x3f8d , 0xbe74 , 0x3f8c , 0xbe6e , 0x3f8c , 0xbe67 , 0x3f8c , 0xbe61 , 0x3f8b , 
	0xbe5a , 0x3f8b , 0xbe53 , 0x3f8a , 0xbe4c , 0x3f8a , 0xbe45 , 0x3f89 , 0xbe3d , 0x3f89 , 0xbe36 , 0x3f89 , 0xbe2f , 0x3f88 , 0xbe28 , 0x3f88 , 
	0xbe5a , 0x3f8b , 0xbe53 , 0x3f8a , 0xbe4c , 0x3f8a , 0xbe45 , 0x3f89 , 0xbe3d , 0x3f89 , 0xbe36 , 0x3f89 , 0xbe2f , 0x3f88 , 0xbe28 , 0x3f88 , 
	0xbe21 , 0x3f87 , 0xbe1a , 0x3f87 , 0xbe13 , 0x3f87 , 0xbe0d , 0x3f86 , 0xbe06 , 0x3f86 , 0xbdff , 0x3f86 , 0xbdf3 , 0x3f85 , 0xbde6 , 0x3f85 , 
	0xbe21 , 0x3f87 , 0xbe1a , 0x3f87 , 0xbe13 , 0x3f87 , 0xbe0d , 0x3f86 , 0xbe06 , 0x3f86 , 0xbdff , 0x3f86 , 0xbdf3 , 0x3f85 , 0xbde6 , 0x3f85 , 
	0xbdda , 0x3f85 , 0xbdcf , 0x3f84 , 0xbdc4 , 0x3f84 , 0xbdb9 , 0x3f84 , 0xbdae , 0x3f84 , 0xbda4 , 0x3f83 , 0xbd9b , 0x3f83 , 0xbd91 , 0x3f83 , 
	0xbdda , 0x3f85 , 0xbdcf , 0x3f84 , 0xbdc4 , 0x3f84 , 0xbdb9 , 0x3f84 , 0xbdae , 0x3f84 , 0xbda4 , 0x3f83 , 0xbd9b , 0x3f83 , 0xbd91 , 0x3f83 , 
	0xbd88 , 0x3f83 , 0xbd80 , 0x3f83 , 0xbd70 , 0x3f82 , 0xbd60 , 0x3f82 , 0xbd51 , 0x3f82 , 0xbd43 , 0x3f82 , 0xbd36 , 0x3f82 , 0xbd29 , 0x3f82 , 
	0xbd88 , 0x3f83 , 0xbd80 , 0x3f83 , 0xbd70 , 0x3f82 , 0xbd60 , 0x3f82 , 0xbd51 , 0x3f82 , 0xbd43 , 0x3f82 , 0xbd36 , 0x3f82 , 0xbd29 , 0x3f82 , 
	0xbd1e , 0x3f81 , 0xbd12 , 0x3f81 , 0xbd08 , 0x3f81 , 0xbcfb , 0x3f81 , 0xbce9 , 0x3f81 , 0xbcd7 , 0x3f81 , 0xbcc6 , 0x3f81 , 0xbcb7 , 0x3f81 , 
	0xbd1e , 0x3f81 , 0xbd12 , 0x3f81 , 0xbd08 , 0x3f81 , 0xbcfb , 0x3f81 , 0xbce9 , 0x3f81 , 0xbcd7 , 0x3f81 , 0xbcc6 , 0x3f81 , 0xbcb7 , 0x3f81 , 
	0xbca9 , 0x3f81 , 0xbc9b , 0x3f81 , 0xbc8e , 0x3f81 , 0xbc83 , 0x3f81 , 0xbc70 , 0x3f81 , 0xbc5b , 0x3f80 , 0xbc49 , 0x3f80 , 0xbc37 , 0x3f80 , 
	0xbca9 , 0x3f81 , 0xbc9b , 0x3f81 , 0xbc8e , 0x3f81 , 0xbc83 , 0x3f81 , 0xbc70 , 0x3f81 , 0xbc5b , 0x3f80 , 0xbc49 , 0x3f80 , 0xbc37 , 0x3f80 , 
	0xbc27 , 0x3f80 , 0xbc19 , 0x3f80 , 0xbc0b , 0x3f80 , 0xbbfd , 0x3f80 , 0xbbe6 , 0x3f80 , 0xbbd0 , 0x3f80 , 0xbbbd , 0x3f80 , 0xbbab , 0x3f80 , 
	0xbc27 , 0x3f80 , 0xbc19 , 0x3f80 , 0xbc0b , 0x3f80 , 0xbbfd , 0x3f80 , 0xbbe6 , 0x3f80 , 0xbbd0 , 0x3f80 , 0xbbbd , 0x3f80 , 0xbbab , 0x3f80 , 
	0xbb9b , 0x3f80 , 0xbb8c , 0x3f80 , 0xbb7c , 0x3f80 , 0xbb63 , 0x3f80 , 0xbb4d , 0x3f80 , 0xbb38 , 0x3f80 , 0xbb25 , 0x3f80 , 0xbb14 , 0x3f80 , 
	0xbb9b , 0x3f80 , 0xbb8c , 0x3f80 , 0xbb7c , 0x3f80 , 0xbb63 , 0x3f80 , 0xbb4d , 0x3f80 , 0xbb38 , 0x3f80 , 0xbb25 , 0x3f80 , 0xbb14 , 0x3f80 , 
	0xbb05 , 0x3f80 , 0xbaee , 0x3f80 , 0xbad5 , 0x3f80 , 0xbabe , 0x3f80 , 0xbaaa , 0x3f80 , 0xba97 , 0x3f80 , 0xba87 , 0x3f80 , 0xba70 , 0x3f80 , 
	0xbb05 , 0x3f80 , 0xbaee , 0x3f80 , 0xbad5 , 0x3f80 , 0xbabe , 0x3f80 , 0xbaaa , 0x3f80 , 0xba97 , 0x3f80 , 0xba87 , 0x3f80 , 0xba70 , 0x3f80 , 
	0xba55 , 0x3f80 , 0xba3d , 0x3f80 , 0xba28 , 0x3f80 , 0xba15 , 0x3f80 , 0xba03 , 0x3f80 , 0xb9e8 , 0x3f80 , 0xb9cd , 0x3f80 , 0xb9b5 , 0x3f80 , 
	0xba55 , 0x3f80 , 0xba3d , 0x3f80 , 0xba28 , 0x3f80 , 0xba15 , 0x3f80 , 0xba03 , 0x3f80 , 0xb9e8 , 0x3f80 , 0xb9cd , 0x3f80 , 0xb9b5 , 0x3f80 , 
	0xb99f , 0x3f80 , 0xb98c , 0x3f80 , 0xb976 , 0x3f80 , 0xb959 , 0x3f80 , 0xb93e , 0x3f80 , 0xb926 , 0x3f80 , 0xb912 , 0x3f80 , 0xb8ff , 0x3f80 , 
	0xb99f , 0x3f80 , 0xb98c , 0x3f80 , 0xb976 , 0x3f80 , 0xb959 , 0x3f80 , 0xb93e , 0x3f80 , 0xb926 , 0x3f80 , 0xb912 , 0x3f80 , 0xb8ff , 0x3f80 , 
	0xb8df , 0x3f80 , 0xb8c2 , 0x3f80 , 0xb8a9 , 0x3f80 , 0xb893 , 0x3f80 , 0xb881 , 0x3f80 , 0xb85f , 0x3f80 , 0xb841 , 0x3f80 , 0x0000 , 0x3f80 , 
	0xb8df , 0x3f80 , 0xb8c2 , 0x3f80 , 0xb8a9 , 0x3f80 , 0xb893 , 0x3f80 , 0xb881 , 0x3f80 , 0xb85f , 0x3f80 , 0xb841 , 0x3f80 , 0x0000 , 0x3f80 
	};

	static const uint16_t lnr_lutcd[lut_sz*2*2]={                                   
	0x0000 , 0x0000 , 0xb841 , 0xb716 , 0xb85f , 0xb72e , 0xb880 , 0xb749 , 0xb893 , 0xb769 , 0xb8a9 , 0xb786 , 0xb8c2 , 0xb79b , 0xb8df , 0xb7b3 , 
	0x0000 , 0x0000 , 0xb841 , 0xb716 , 0xb85f , 0xb72e , 0xb880 , 0xb749 , 0xb893 , 0xb769 , 0xb8a9 , 0xb786 , 0xb8c2 , 0xb79b , 0xb8df , 0xb7b3 , 
	0xb8ff , 0xb7ce , 0xb912 , 0xb7ed , 0xb926 , 0xb808 , 0xb93e , 0xb81c , 0xb959 , 0xb833 , 0xb977 , 0xb84e , 0xb98c , 0xb86b , 0xb99f , 0xb887 , 
	0xb8ff , 0xb7ce , 0xb912 , 0xb7ed , 0xb926 , 0xb808 , 0xb93e , 0xb81c , 0xb959 , 0xb833 , 0xb977 , 0xb84e , 0xb98c , 0xb86b , 0xb99f , 0xb887 , 
	0xb9b5 , 0xb89a , 0xb9cd , 0xb8af , 0xb9e8 , 0xb8c8 , 0xba03 , 0xb8e4 , 0xba15 , 0xb901 , 0xba28 , 0xb913 , 0xba3d , 0xb927 , 0xba55 , 0xb93d , 
	0xb9b5 , 0xb89a , 0xb9cd , 0xb8af , 0xb9e8 , 0xb8c8 , 0xba03 , 0xb8e4 , 0xba15 , 0xb901 , 0xba28 , 0xb913 , 0xba3d , 0xb927 , 0xba55 , 0xb93d , 
	0xba70 , 0xb957 , 0xba87 , 0xb973 , 0xba97 , 0xb989 , 0xbaaa , 0xb99b , 0xbabe , 0xb9af , 0xbad5 , 0xb9c5 , 0xbaee , 0xb9de , 0xbb05 , 0xb9f9 , 
	0xba70 , 0xb957 , 0xba87 , 0xb973 , 0xba97 , 0xb989 , 0xbaaa , 0xb99b , 0xbabe , 0xb9af , 0xbad5 , 0xb9c5 , 0xbaee , 0xb9de , 0xbb05 , 0xb9f9 , 
	0xbb14 , 0xba0c , 0xbb25 , 0xba1d , 0xbb38 , 0xba30 , 0xbb4d , 0xba45 , 0xbb63 , 0xba5c , 0xbb7c , 0xba76 , 0xbb8c , 0xba89 , 0xbb9b , 0xba99 , 
	0xbb14 , 0xba0c , 0xbb25 , 0xba1d , 0xbb38 , 0xba30 , 0xbb4d , 0xba45 , 0xbb63 , 0xba5c , 0xbb7c , 0xba76 , 0xbb8c , 0xba89 , 0xbb9b , 0xba99 , 
	0xbbab , 0xbaab , 0xbbbd , 0xbabe , 0xbbd0 , 0xbad3 , 0xbbe6 , 0xbaea , 0xbbfd , 0xbb02 , 0xbc0b , 0xbb10 , 0xbc19 , 0xbb1f , 0xbc27 , 0xbb30 , 
	0xbbab , 0xbaab , 0xbbbd , 0xbabe , 0xbbd0 , 0xbad3 , 0xbbe6 , 0xbaea , 0xbbfd , 0xbb02 , 0xbc0b , 0xbb10 , 0xbc19 , 0xbb1f , 0xbc27 , 0xbb30 , 
	0xbc37 , 0xbb42 , 0xbc49 , 0xbb56 , 0xbc5b , 0xbb6c , 0xbc70 , 0xbb82 , 0xbc83 , 0xbb8f , 0xbc8e , 0xbb9d , 0xbc9b , 0xbbac , 0xbca9 , 0xbbbd , 
	0xbc37 , 0xbb42 , 0xbc49 , 0xbb56 , 0xbc5b , 0xbb6c , 0xbc70 , 0xbb82 , 0xbc83 , 0xbb8f , 0xbc8e , 0xbb9d , 0xbc9b , 0xbbac , 0xbca9 , 0xbbbd , 
	0xbcb7 , 0xbbce , 0xbcc6 , 0xbbe2 , 0xbcd7 , 0xbbf6 , 0xbce9 , 0xbc06 , 0xbcfb , 0xbc12 , 0xbd08 , 0xbc1f , 0xbd12 , 0xbc2d , 0xbd1e , 0xbc3c , 
	0xbcb7 , 0xbbce , 0xbcc6 , 0xbbe2 , 0xbcd7 , 0xbbf6 , 0xbce9 , 0xbc06 , 0xbcfb , 0xbc12 , 0xbd08 , 0xbc1f , 0xbd12 , 0xbc2d , 0xbd1e , 0xbc3c , 
	0xbd29 , 0xbc4c , 0xbd36 , 0xbc5d , 0xbd43 , 0xbc6f , 0xbd51 , 0xbc81 , 0xbd60 , 0xbc8b , 0xbd70 , 0xbc96 , 0xbd80 , 0xbca2 , 0xbd88 , 0xbcae , 
	0xbd29 , 0xbc4c , 0xbd36 , 0xbc5d , 0xbd43 , 0xbc6f , 0xbd51 , 0xbc81 , 0xbd60 , 0xbc8b , 0xbd70 , 0xbc96 , 0xbd80 , 0xbca2 , 0xbd88 , 0xbcae , 
	0xbd91 , 0xbcbb , 0xbd9b , 0xbcc9 , 0xbda4 , 0xbcd7 , 0xbdae , 0xbce6 , 0xbdb9 , 0xbcf6 , 0xbdc4 , 0xbd03 , 0xbdcf , 0xbd0c , 0xbdda , 0xbd15 , 
	0xbd91 , 0xbcbb , 0xbd9b , 0xbcc9 , 0xbda4 , 0xbcd7 , 0xbdae , 0xbce6 , 0xbdb9 , 0xbcf6 , 0xbdc4 , 0xbd03 , 0xbdcf , 0xbd0c , 0xbdda , 0xbd15 , 
	0xbde6 , 0xbd1f , 0xbdf3 , 0xbd29 , 0xbdff , 0xbd33 , 0xbe06 , 0xbd3e , 0xbe0d , 0xbd49 , 0xbe13 , 0xbd54 , 0xbe1a , 0xbd60 , 0xbe21 , 0xbd6c , 
	0xbde6 , 0xbd1f , 0xbdf3 , 0xbd29 , 0xbdff , 0xbd33 , 0xbe06 , 0xbd3e , 0xbe0d , 0xbd49 , 0xbe13 , 0xbd54 , 0xbe1a , 0xbd60 , 0xbe21 , 0xbd6c , 
	0xbe28 , 0xbd79 , 0xbe2f , 0xbd83 , 0xbe36 , 0xbd89 , 0xbe3d , 0xbd90 , 0xbe45 , 0xbd97 , 0xbe4c , 0xbd9d , 0xbe53 , 0xbda4 , 0xbe5a , 0xbdab , 
	0xbe28 , 0xbd79 , 0xbe2f , 0xbd83 , 0xbe36 , 0xbd89 , 0xbe3d , 0xbd90 , 0xbe45 , 0xbd97 , 0xbe4c , 0xbd9d , 0xbe53 , 0xbda4 , 0xbe5a , 0xbdab , 
	0xbe61 , 0xbdb2 , 0xbe67 , 0xbdb9 , 0xbe6e , 0xbdc0 , 0xbe74 , 0xbdc7 , 0xbe7b , 0xbdcd , 0xbe80 , 0xbdd4 , 0xbe83 , 0xbdda , 0xbe86 , 0xbde0 , 
	0xbe61 , 0xbdb2 , 0xbe67 , 0xbdb9 , 0xbe6e , 0xbdc0 , 0xbe74 , 0xbdc7 , 0xbe7b , 0xbdcd , 0xbe80 , 0xbdd4 , 0xbe83 , 0xbdda , 0xbe86 , 0xbde0 , 
	0xbe89 , 0xbde6 , 0xbe8b , 0xbdec , 0xbe8d , 0xbdf1 , 0xbe8f , 0xbdf6 , 0xbe91 , 0xbdfa , 0xbe92 , 0xbdfe , 0xbe94 , 0xbe01 , 0xbe95 , 0xbe02 , 
	0xbe89 , 0xbde6 , 0xbe8b , 0xbdec , 0xbe8d , 0xbdf1 , 0xbe8f , 0xbdf6 , 0xbe91 , 0xbdfa , 0xbe92 , 0xbdfe , 0xbe94 , 0xbe01 , 0xbe95 , 0xbe02 , 
	0xbe96 , 0xbe03 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe03 , 0xbe95 , 0xbe02 , 0xbe94 , 0xbe01 , 0xbe93 , 0xbdfe , 
	0xbe96 , 0xbe03 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe04 , 0xbe96 , 0xbe03 , 0xbe95 , 0xbe02 , 0xbe94 , 0xbe01 , 0xbe93 , 0xbdfe , 
	0xbe91 , 0xbdf8 , 0xbe8f , 0xbdf2 , 0xbe8d , 0xbdeb , 0xbe8b , 0xbde2 , 0xbe88 , 0xbdd8 , 0xbe85 , 0xbdcd , 0xbe81 , 0xbdc0 , 0xbe7c , 0xbdb2 , 
	0xbe91 , 0xbdf8 , 0xbe8f , 0xbdf2 , 0xbe8d , 0xbdeb , 0xbe8b , 0xbde2 , 0xbe88 , 0xbdd8 , 0xbe85 , 0xbdcd , 0xbe81 , 0xbdc0 , 0xbe7c , 0xbdb2 , 
	0xbe74 , 0xbda3 , 0xbe6c , 0xbd92 , 0xbe63 , 0xbd7e , 0xbe5a , 0xbd57 , 0xbe50 , 0xbd2c , 0xbe47 , 0xbcfb , 0xbe3d , 0xbc99 , 0xbe33 , 0xbbc0 , 
	0xbe74 , 0xbda3 , 0xbe6c , 0xbd92 , 0xbe63 , 0xbd7e , 0xbe5a , 0xbd57 , 0xbe50 , 0xbd2c , 0xbe47 , 0xbcfb , 0xbe3d , 0xbc99 , 0xbe33 , 0xbbc0 , 
	0xbe28 , 0x3bfb , 0xbe1e , 0x3cb4 , 0xbe13 , 0x3d17 , 0xbe08 , 0x3d58 , 0xbdfc , 0x3d8e , 0xbde7 , 0x3db1 , 0xbdd2 , 0x3dd6 , 0xbdbe , 0x3dfc , 
	0xbe28 , 0x3bfb , 0xbe1e , 0x3cb4 , 0xbe13 , 0x3d17 , 0xbe08 , 0x3d58 , 0xbdfc , 0x3d8e , 0xbde7 , 0x3db1 , 0xbdd2 , 0x3dd6 , 0xbdbe , 0x3dfc , 
	0xbdaa , 0x3e12 , 0xbd97 , 0x3e26 , 0xbd85 , 0x3e3b , 0xbd67 , 0x3e51 , 0xbd45 , 0x3e67 , 0xbd26 , 0x3e7d , 0xbd09 , 0x3e8a , 0xbcde , 0x3e96 , 
	0xbdaa , 0x3e12 , 0xbd97 , 0x3e26 , 0xbd85 , 0x3e3b , 0xbd67 , 0x3e51 , 0xbd45 , 0x3e67 , 0xbd26 , 0x3e7d , 0xbd09 , 0x3e8a , 0xbcde , 0x3e96 , 
	0xbcae , 0x3ea2 , 0xbc83 , 0x3eae , 0xbc3d , 0x3eba , 0xbbfd , 0x3ec7 , 0xbb98 , 0x3ed3 , 0xbb19 , 0x3ee0 , 0xba4c , 0x3eed , 0x2f66 , 0x3efa , 
	0xbcae , 0x3ea2 , 0xbc83 , 0x3eae , 0xbc3d , 0x3eba , 0xbbfd , 0x3ec7 , 0xbb98 , 0x3ed3 , 0xbb19 , 0x3ee0 , 0xba4c , 0x3eed , 0x2f66 , 0x3efa , 
	0x0000 , 0x3f03 , 0xba4c , 0x3f0a , 0xbb19 , 0x3f10 , 0xbb98 , 0x3f16 , 0xbbfd , 0x3f1d , 0xbc3d , 0x3f23 , 0xbc83 , 0x3f29 , 0xbcae , 0x3f2f , 
	0x0000 , 0x3f03 , 0xba4c , 0x3f0a , 0xbb19 , 0x3f10 , 0xbb98 , 0x3f16 , 0xbbfd , 0x3f1d , 0xbc3d , 0x3f23 , 0xbc83 , 0x3f29 , 0xbcae , 0x3f2f , 
	0xbcde , 0x3f35 , 0xbd09 , 0x3f3b , 0xbd26 , 0x3f41 , 0xbd45 , 0x3f46 , 0xbd67 , 0x3f4c , 0xbd85 , 0x3f51 , 0xbd97 , 0x3f56 , 0xbdaa , 0x3f5c , 
	0xbcde , 0x3f35 , 0xbd09 , 0x3f3b , 0xbd26 , 0x3f41 , 0xbd45 , 0x3f46 , 0xbd67 , 0x3f4c , 0xbd85 , 0x3f51 , 0xbd97 , 0x3f56 , 0xbdaa , 0x3f5c , 
	0xbdbe , 0x3f61 , 0xbdd2 , 0x3f65 , 0xbde7 , 0x3f6a , 0xbdfc , 0x3f6e , 0xbe08 , 0x3f72 , 0xbe13 , 0x3f77 , 0xbe1e , 0x3f7a , 0xbe28 , 0x3f7e , 
	0xbdbe , 0x3f61 , 0xbdd2 , 0x3f65 , 0xbde7 , 0x3f6a , 0xbdfc , 0x3f6e , 0xbe08 , 0x3f72 , 0xbe13 , 0x3f77 , 0xbe1e , 0x3f7a , 0xbe28 , 0x3f7e , 
	0xbe33 , 0x3f81 , 0xbe3d , 0x3f82 , 0xbe47 , 0x3f84 , 0xbe50 , 0x3f85 , 0xbe5a , 0x3f87 , 0xbe63 , 0x3f88 , 0xbe6c , 0x3f89 , 0xbe74 , 0x3f8a , 
	0xbe33 , 0x3f81 , 0xbe3d , 0x3f82 , 0xbe47 , 0x3f84 , 0xbe50 , 0x3f85 , 0xbe5a , 0x3f87 , 0xbe63 , 0x3f88 , 0xbe6c , 0x3f89 , 0xbe74 , 0x3f8a , 
	0xbe7c , 0x3f8b , 0xbe81 , 0x3f8c , 0xbe85 , 0x3f8d , 0xbe88 , 0x3f8e , 0xbe8b , 0x3f8e , 0xbe8d , 0x3f8f , 0xbe8f , 0x3f8f , 0xbe91 , 0x3f90 , 
	0xbe7c , 0x3f8b , 0xbe81 , 0x3f8c , 0xbe85 , 0x3f8d , 0xbe88 , 0x3f8e , 0xbe8b , 0x3f8e , 0xbe8d , 0x3f8f , 0xbe8f , 0x3f8f , 0xbe91 , 0x3f90 , 
	0xbe93 , 0x3f90 , 0xbe94 , 0x3f90 , 0xbe95 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 
	0xbe93 , 0x3f90 , 0xbe94 , 0x3f90 , 0xbe95 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 0xbe96 , 0x3f90 , 
	0xbe95 , 0x3f90 , 0xbe94 , 0x3f90 , 0xbe92 , 0x3f90 , 0xbe91 , 0x3f90 , 0xbe8f , 0x3f8f , 0xbe8d , 0x3f8f , 0xbe8b , 0x3f8f , 0xbe89 , 0x3f8e , 
	0xbe95 , 0x3f90 , 0xbe94 , 0x3f90 , 0xbe92 , 0x3f90 , 0xbe91 , 0x3f90 , 0xbe8f , 0x3f8f , 0xbe8d , 0x3f8f , 0xbe8b , 0x3f8f , 0xbe89 , 0x3f8e , 
	0xbe86 , 0x3f8e , 0xbe83 , 0x3f8e , 0xbe80 , 0x3f8d , 0xbe7b , 0x3f8d , 0xbe74 , 0x3f8c , 0xbe6e , 0x3f8c , 0xbe67 , 0x3f8c , 0xbe61 , 0x3f8b , 
	0xbe86 , 0x3f8e , 0xbe83 , 0x3f8e , 0xbe80 , 0x3f8d , 0xbe7b , 0x3f8d , 0xbe74 , 0x3f8c , 0xbe6e , 0x3f8c , 0xbe67 , 0x3f8c , 0xbe61 , 0x3f8b , 
	0xbe5a , 0x3f8b , 0xbe53 , 0x3f8a , 0xbe4c , 0x3f8a , 0xbe45 , 0x3f89 , 0xbe3d , 0x3f89 , 0xbe36 , 0x3f89 , 0xbe2f , 0x3f88 , 0xbe28 , 0x3f88 , 
	0xbe5a , 0x3f8b , 0xbe53 , 0x3f8a , 0xbe4c , 0x3f8a , 0xbe45 , 0x3f89 , 0xbe3d , 0x3f89 , 0xbe36 , 0x3f89 , 0xbe2f , 0x3f88 , 0xbe28 , 0x3f88 , 
	0xbe21 , 0x3f87 , 0xbe1a , 0x3f87 , 0xbe13 , 0x3f87 , 0xbe0d , 0x3f86 , 0xbe06 , 0x3f86 , 0xbdff , 0x3f86 , 0xbdf3 , 0x3f85 , 0xbde6 , 0x3f85 , 
	0xbe21 , 0x3f87 , 0xbe1a , 0x3f87 , 0xbe13 , 0x3f87 , 0xbe0d , 0x3f86 , 0xbe06 , 0x3f86 , 0xbdff , 0x3f86 , 0xbdf3 , 0x3f85 , 0xbde6 , 0x3f85 , 
	0xbdda , 0x3f85 , 0xbdcf , 0x3f84 , 0xbdc4 , 0x3f84 , 0xbdb9 , 0x3f84 , 0xbdae , 0x3f84 , 0xbda4 , 0x3f83 , 0xbd9b , 0x3f83 , 0xbd91 , 0x3f83 , 
	0xbdda , 0x3f85 , 0xbdcf , 0x3f84 , 0xbdc4 , 0x3f84 , 0xbdb9 , 0x3f84 , 0xbdae , 0x3f84 , 0xbda4 , 0x3f83 , 0xbd9b , 0x3f83 , 0xbd91 , 0x3f83 , 
	0xbd88 , 0x3f83 , 0xbd80 , 0x3f83 , 0xbd70 , 0x3f82 , 0xbd60 , 0x3f82 , 0xbd51 , 0x3f82 , 0xbd43 , 0x3f82 , 0xbd36 , 0x3f82 , 0xbd29 , 0x3f82 , 
	0xbd88 , 0x3f83 , 0xbd80 , 0x3f83 , 0xbd70 , 0x3f82 , 0xbd60 , 0x3f82 , 0xbd51 , 0x3f82 , 0xbd43 , 0x3f82 , 0xbd36 , 0x3f82 , 0xbd29 , 0x3f82 , 
	0xbd1e , 0x3f81 , 0xbd12 , 0x3f81 , 0xbd08 , 0x3f81 , 0xbcfb , 0x3f81 , 0xbce9 , 0x3f81 , 0xbcd7 , 0x3f81 , 0xbcc6 , 0x3f81 , 0xbcb7 , 0x3f81 , 
	0xbd1e , 0x3f81 , 0xbd12 , 0x3f81 , 0xbd08 , 0x3f81 , 0xbcfb , 0x3f81 , 0xbce9 , 0x3f81 , 0xbcd7 , 0x3f81 , 0xbcc6 , 0x3f81 , 0xbcb7 , 0x3f81 , 
	0xbca9 , 0x3f81 , 0xbc9b , 0x3f81 , 0xbc8e , 0x3f81 , 0xbc83 , 0x3f81 , 0xbc70 , 0x3f81 , 0xbc5b , 0x3f80 , 0xbc49 , 0x3f80 , 0xbc37 , 0x3f80 , 
	0xbca9 , 0x3f81 , 0xbc9b , 0x3f81 , 0xbc8e , 0x3f81 , 0xbc83 , 0x3f81 , 0xbc70 , 0x3f81 , 0xbc5b , 0x3f80 , 0xbc49 , 0x3f80 , 0xbc37 , 0x3f80 , 
	0xbc27 , 0x3f80 , 0xbc19 , 0x3f80 , 0xbc0b , 0x3f80 , 0xbbfd , 0x3f80 , 0xbbe6 , 0x3f80 , 0xbbd0 , 0x3f80 , 0xbbbd , 0x3f80 , 0xbbab , 0x3f80 , 
	0xbc27 , 0x3f80 , 0xbc19 , 0x3f80 , 0xbc0b , 0x3f80 , 0xbbfd , 0x3f80 , 0xbbe6 , 0x3f80 , 0xbbd0 , 0x3f80 , 0xbbbd , 0x3f80 , 0xbbab , 0x3f80 , 
	0xbb9b , 0x3f80 , 0xbb8c , 0x3f80 , 0xbb7c , 0x3f80 , 0xbb63 , 0x3f80 , 0xbb4d , 0x3f80 , 0xbb38 , 0x3f80 , 0xbb25 , 0x3f80 , 0xbb14 , 0x3f80 , 
	0xbb9b , 0x3f80 , 0xbb8c , 0x3f80 , 0xbb7c , 0x3f80 , 0xbb63 , 0x3f80 , 0xbb4d , 0x3f80 , 0xbb38 , 0x3f80 , 0xbb25 , 0x3f80 , 0xbb14 , 0x3f80 , 
	0xbb05 , 0x3f80 , 0xbaee , 0x3f80 , 0xbad5 , 0x3f80 , 0xbabe , 0x3f80 , 0xbaaa , 0x3f80 , 0xba97 , 0x3f80 , 0xba87 , 0x3f80 , 0xba70 , 0x3f80 , 
	0xbb05 , 0x3f80 , 0xbaee , 0x3f80 , 0xbad5 , 0x3f80 , 0xbabe , 0x3f80 , 0xbaaa , 0x3f80 , 0xba97 , 0x3f80 , 0xba87 , 0x3f80 , 0xba70 , 0x3f80 , 
	0xba55 , 0x3f80 , 0xba3d , 0x3f80 , 0xba28 , 0x3f80 , 0xba15 , 0x3f80 , 0xba03 , 0x3f80 , 0xb9e8 , 0x3f80 , 0xb9cd , 0x3f80 , 0xb9b5 , 0x3f80 , 
	0xba55 , 0x3f80 , 0xba3d , 0x3f80 , 0xba28 , 0x3f80 , 0xba15 , 0x3f80 , 0xba03 , 0x3f80 , 0xb9e8 , 0x3f80 , 0xb9cd , 0x3f80 , 0xb9b5 , 0x3f80 , 
	0xb99f , 0x3f80 , 0xb98c , 0x3f80 , 0xb976 , 0x3f80 , 0xb959 , 0x3f80 , 0xb93e , 0x3f80 , 0xb926 , 0x3f80 , 0xb912 , 0x3f80 , 0xb8ff , 0x3f80 , 
	0xb99f , 0x3f80 , 0xb98c , 0x3f80 , 0xb976 , 0x3f80 , 0xb959 , 0x3f80 , 0xb93e , 0x3f80 , 0xb926 , 0x3f80 , 0xb912 , 0x3f80 , 0xb8ff , 0x3f80 , 
	0xb8df , 0x3f80 , 0xb8c2 , 0x3f80 , 0xb8a9 , 0x3f80 , 0xb893 , 0x3f80 , 0xb881 , 0x3f80 , 0xb85f , 0x3f80 , 0xb841 , 0x3f80 , 0x0000 , 0x3f80 , 
	0xb8df , 0x3f80 , 0xb8c2 , 0x3f80 , 0xb8a9 , 0x3f80 , 0xb893 , 0x3f80 , 0xb881 , 0x3f80 , 0xb85f , 0x3f80 , 0xb841 , 0x3f80 , 0x0000 , 0x3f80 
	};
}

#endif //GELU_LUT_BF16_512_H

