#ifndef GELU_LUT_INT16_512_H
#define GELU_LUT_INT16_512_H

namespace gelu_int16 {
	#define NLF_LUT_GELU_SHIFT 5
	const int lut_sz = 160*2;
	const int lut_frac_bits = 14;
	static const int16_t lnr_lutab[lut_sz*2*2]={
			0,     0,     0,     0,     0,     0,    -1,     0,    -1,     0,    -1,     0,    -1,     0,    -1,     0,
			0,     0,     0,     0,     0,     0,    -1,     0,    -1,     0,    -1,     0,    -1,     0,    -1,     0,
		 -1,     0,    -2,     0,    -2,     0,    -2,     0,    -3,     0,    -3,     0,    -4,     0,    -4,    -1,
		 -1,     0,    -2,     0,    -2,     0,    -2,     0,    -3,     0,    -3,     0,    -4,     0,    -4,    -1,
		 -5,    -1,    -6,    -1,    -7,    -1,    -8,    -1,    -9,    -2,   -10,    -2,   -11,    -2,   -13,    -2,
		 -5,    -1,    -6,    -1,    -7,    -1,    -8,    -1,    -9,    -2,   -10,    -2,   -11,    -2,   -13,    -2,
		-14,    -3,   -16,    -3,   -18,    -4,   -21,    -4,   -23,    -5,   -26,    -6,   -29,    -6,   -33,    -7,
		-14,    -3,   -16,    -3,   -18,    -4,   -21,    -4,   -23,    -5,   -26,    -6,   -29,    -6,   -33,    -7,
		-37,    -8,   -41,    -9,   -45,   -11,   -51,   -12,   -56,   -13,   -63,   -15,   -69,   -17,   -77,   -19,
		-37,    -8,   -41,    -9,   -45,   -11,   -51,   -12,   -56,   -13,   -63,   -15,   -69,   -17,   -77,   -19,
		-85,   -21,   -94,   -23,  -104,   -26,  -114,   -29,  -126,   -32,  -138,   -35,  -152,   -39,  -167,   -44,
		-85,   -21,   -94,   -23,  -104,   -26,  -114,   -29,  -126,   -32,  -138,   -35,  -152,   -39,  -167,   -44,
	 -183,   -48,  -200,   -53,  -219,   -59,  -239,   -64,  -261,   -71,  -284,   -78,  -310,   -86,  -337,   -94,
	 -183,   -48,  -200,   -53,  -219,   -59,  -239,   -64,  -261,   -71,  -284,   -78,  -310,   -86,  -337,   -94,
	 -365,  -103,  -396,  -112,  -429,  -123,  -465,  -134,  -502,  -146,  -542,  -159,  -585,  -173,  -630,  -187,
	 -365,  -103,  -396,  -112,  -429,  -123,  -465,  -134,  -502,  -146,  -542,  -159,  -585,  -173,  -630,  -187,
	 -677,  -203,  -728,  -220,  -781,  -238,  -837,  -258,  -896,  -278,  -958,  -300, -1023,  -323, -1091,  -348,
	 -677,  -203,  -728,  -220,  -781,  -238,  -837,  -258,  -896,  -278,  -958,  -300, -1023,  -323, -1091,  -348,
	-1162,  -374, -1237,  -401, -1314,  -430, -1395,  -460, -1479,  -492, -1565,  -525, -1655,  -560, -1747,  -597,
	-1162,  -374, -1237,  -401, -1314,  -430, -1395,  -460, -1479,  -492, -1565,  -525, -1655,  -560, -1747,  -597,
	-1843,  -635, -1941,  -675, -2041,  -716, -2144,  -759, -2250,  -803, -2357,  -849, -2466,  -896, -2577,  -945,
	-1843,  -635, -1941,  -675, -2041,  -716, -2144,  -759, -2250,  -803, -2357,  -849, -2466,  -896, -2577,  -945,
	-2689,  -994, -2802, -1045, -2915, -1097, -3029, -1150, -3144, -1204, -3257, -1258, -3371, -1313, -3483, -1368,
	-2689,  -994, -2802, -1045, -2915, -1097, -3029, -1150, -3144, -1204, -3257, -1258, -3371, -1313, -3483, -1368,
	-3593, -1424, -3702, -1479, -3808, -1534, -3911, -1588, -4011, -1641, -4108, -1693, -4200, -1744, -4287, -1793,
	-3593, -1424, -3702, -1479, -3808, -1534, -3911, -1588, -4011, -1641, -4108, -1693, -4200, -1744, -4287, -1793,
	-4369, -1840, -4445, -1884, -4516, -1926, -4579, -1965, -4636, -2000, -4685, -2030, -4727, -2057, -4760, -2079,
	-4369, -1840, -4445, -1884, -4516, -1926, -4579, -1965, -4636, -2000, -4685, -2030, -4727, -2057, -4760, -2079,
	-4785, -2095, -4801, -2106, -4808, -2111, -4806, -2109, -4794, -2101, -4772, -2084, -4740, -2060, -4699, -2028,
	-4785, -2095, -4801, -2106, -4808, -2111, -4806, -2109, -4794, -2101, -4772, -2084, -4740, -2060, -4699, -2028,
	-4648, -1987, -4587, -1937, -4516, -1878, -4436, -1808, -4346, -1728, -4247, -1638, -4140, -1537, -4024, -1425,
	-4648, -1987, -4587, -1937, -4516, -1878, -4436, -1808, -4346, -1728, -4247, -1638, -4140, -1537, -4024, -1425,
	-3900, -1301, -3769, -1165, -3630, -1017, -3486,  -858, -3335,  -686, -3180,  -501, -3020,  -305, -2856,   -96,
	-3900, -1301, -3769, -1165, -3630, -1017, -3486,  -858, -3335,  -686, -3180,  -501, -3020,  -305, -2856,   -96,
	-2690,   125, -2522,   359, -2353,   605, -2183,   864, -2014,  1134, -1847,  1416, -1681,  1710, -1520,  2015,
	-2690,   125, -2522,   359, -2353,   605, -2183,   864, -2014,  1134, -1847,  1416, -1681,  1710, -1520,  2015,
	-1362,  2330, -1209,  2656, -1062,  2991,  -922,  3336,  -789,  3690,  -665,  4053,  -549,  4423,  -443,  4800,
	-1362,  2330, -1209,  2656, -1062,  2991,  -922,  3336,  -789,  3690,  -665,  4053,  -549,  4423,  -443,  4800,
	 -347,  5183,  -262,  5573,  -188,  5967,  -126,  6365,   -76,  6767,   -38,  7172,   -12,  7579,     0,  7987,
	 -347,  5183,  -262,  5573,  -188,  5967,  -126,  6365,   -76,  6767,   -38,  7172,   -12,  7579,     0,  7987,
			0,  8396,   -12,  8804,   -38,  9211,   -76,  9616,  -126, 10018,  -188, 10416,  -262, 10810,  -347, 11200,
			0,  8396,   -12,  8804,   -38,  9211,   -76,  9616,  -126, 10018,  -188, 10416,  -262, 10810,  -347, 11200,
	 -443, 11583,  -549, 11960,  -665, 12330,  -789, 12693,  -922, 13047, -1062, 13392, -1209, 13727, -1362, 14053,
	 -443, 11583,  -549, 11960,  -665, 12330,  -789, 12693,  -922, 13047, -1062, 13392, -1209, 13727, -1362, 14053,
	-1520, 14368, -1681, 14673, -1847, 14967, -2014, 15249, -2183, 15519, -2353, 15778, -2522, 16024, -2690, 16258,
	-1520, 14368, -1681, 14673, -1847, 14967, -2014, 15249, -2183, 15519, -2353, 15778, -2522, 16024, -2690, 16258,
	-2856, 16480, -3020, 16689, -3180, 16885, -3335, 17070, -3486, 17242, -3630, 17401, -3769, 17549, -3900, 17685,
	-2856, 16480, -3020, 16689, -3180, 16885, -3335, 17070, -3486, 17242, -3630, 17401, -3769, 17549, -3900, 17685,
	-4024, 17809, -4140, 17921, -4247, 18022, -4346, 18112, -4436, 18192, -4516, 18262, -4587, 18321, -4648, 18371,
	-4024, 17809, -4140, 17921, -4247, 18022, -4346, 18112, -4436, 18192, -4516, 18262, -4587, 18321, -4648, 18371,
	-4699, 18412, -4740, 18444, -4772, 18468, -4794, 18485, -4806, 18493, -4808, 18495, -4801, 18490, -4785, 18479,
	-4699, 18412, -4740, 18444, -4772, 18468, -4794, 18485, -4806, 18493, -4808, 18495, -4801, 18490, -4785, 18479,
	-4760, 18463, -4727, 18441, -4685, 18414, -4636, 18384, -4579, 18349, -4516, 18310, -4445, 18268, -4369, 18224,
	-4760, 18463, -4727, 18441, -4685, 18414, -4636, 18384, -4579, 18349, -4516, 18310, -4445, 18268, -4369, 18224,
	-4287, 18177, -4200, 18128, -4108, 18077, -4011, 18025, -3911, 17972, -3808, 17918, -3702, 17863, -3593, 17808,
	-4287, 18177, -4200, 18128, -4108, 18077, -4011, 18025, -3911, 17972, -3808, 17918, -3702, 17863, -3593, 17808,
	-3483, 17752, -3371, 17697, -3257, 17642, -3144, 17588, -3029, 17534, -2915, 17481, -2802, 17429, -2689, 17378,
	-3483, 17752, -3371, 17697, -3257, 17642, -3144, 17588, -3029, 17534, -2915, 17481, -2802, 17429, -2689, 17378,
	-2577, 17329, -2466, 17280, -2357, 17233, -2250, 17187, -2144, 17143, -2041, 17100, -1941, 17059, -1843, 17019,
	-2577, 17329, -2466, 17280, -2357, 17233, -2250, 17187, -2144, 17143, -2041, 17100, -1941, 17059, -1843, 17019,
	-1747, 16981, -1655, 16944, -1565, 16909, -1479, 16876, -1395, 16844, -1314, 16814, -1237, 16785, -1162, 16758,
	-1747, 16981, -1655, 16944, -1565, 16909, -1479, 16876, -1395, 16844, -1314, 16814, -1237, 16785, -1162, 16758,
	-1091, 16732, -1023, 16707,  -958, 16684,  -896, 16662,  -837, 16642,  -781, 16622,  -728, 16604,  -677, 16587,
	-1091, 16732, -1023, 16707,  -958, 16684,  -896, 16662,  -837, 16642,  -781, 16622,  -728, 16604,  -677, 16587,
	 -630, 16571,  -585, 16557,  -542, 16543,  -502, 16530,  -465, 16518,  -429, 16507,  -396, 16496,  -365, 16487,
	 -630, 16571,  -585, 16557,  -542, 16543,  -502, 16530,  -465, 16518,  -429, 16507,  -396, 16496,  -365, 16487,
	 -337, 16478,  -310, 16470,  -284, 16462,  -261, 16455,  -239, 16448,  -219, 16443,  -200, 16437,  -183, 16432,
	 -337, 16478,  -310, 16470,  -284, 16462,  -261, 16455,  -239, 16448,  -219, 16443,  -200, 16437,  -183, 16432,
	 -167, 16428,  -152, 16423,  -138, 16419,  -126, 16416,  -114, 16413,  -104, 16410,   -94, 16407,   -85, 16405,
	 -167, 16428,  -152, 16423,  -138, 16419,  -126, 16416,  -114, 16413,  -104, 16410,   -94, 16407,   -85, 16405,
		-77, 16403,   -69, 16401,   -63, 16399,   -56, 16397,   -51, 16396,   -45, 16395,   -41, 16393,   -37, 16392,
		-77, 16403,   -69, 16401,   -63, 16399,   -56, 16397,   -51, 16396,   -45, 16395,   -41, 16393,   -37, 16392,
		-33, 16391,   -29, 16390,   -26, 16390,   -23, 16389,   -21, 16388,   -18, 16388,   -16, 16387,   -14, 16387,
		-33, 16391,   -29, 16390,   -26, 16390,   -23, 16389,   -21, 16388,   -18, 16388,   -16, 16387,   -14, 16387,
		-13, 16386,   -11, 16386,   -10, 16386,    -9, 16386,    -8, 16385,    -7, 16385,    -6, 16385,    -5, 16385,
		-13, 16386,   -11, 16386,   -10, 16386,    -9, 16386,    -8, 16385,    -7, 16385,    -6, 16385,    -5, 16385,
		 -4, 16385,    -4, 16384,    -3, 16384,    -3, 16384,    -2, 16384,    -2, 16384,    -2, 16384,    -1, 16384,
		 -4, 16385,    -4, 16384,    -3, 16384,    -3, 16384,    -2, 16384,    -2, 16384,    -2, 16384,    -1, 16384,
		 -1, 16384,    -1, 16384,    -1, 16384,    -1, 16384,    -1, 16384,     0, 16384,     0, 16384,     0, 16384,
		 -1, 16384,    -1, 16384,    -1, 16384,    -1, 16384,    -1, 16384,     0, 16384,     0, 16384,     0, 16384
	};

	static const int16_t lnr_lutcd[lut_sz*2*2]={                                   
			0,     0,     0,     0,     0,     0,    -1,     0,    -1,     0,    -1,     0,    -1,     0,    -1,     0,
			0,     0,     0,     0,     0,     0,    -1,     0,    -1,     0,    -1,     0,    -1,     0,    -1,     0,
		 -1,     0,    -2,     0,    -2,     0,    -2,     0,    -3,     0,    -3,     0,    -4,     0,    -4,    -1,
		 -1,     0,    -2,     0,    -2,     0,    -2,     0,    -3,     0,    -3,     0,    -4,     0,    -4,    -1,
		 -5,    -1,    -6,    -1,    -7,    -1,    -8,    -1,    -9,    -2,   -10,    -2,   -11,    -2,   -13,    -2,
		 -5,    -1,    -6,    -1,    -7,    -1,    -8,    -1,    -9,    -2,   -10,    -2,   -11,    -2,   -13,    -2,
		-14,    -3,   -16,    -3,   -18,    -4,   -21,    -4,   -23,    -5,   -26,    -6,   -29,    -6,   -33,    -7,
		-14,    -3,   -16,    -3,   -18,    -4,   -21,    -4,   -23,    -5,   -26,    -6,   -29,    -6,   -33,    -7,
		-37,    -8,   -41,    -9,   -45,   -11,   -51,   -12,   -56,   -13,   -63,   -15,   -69,   -17,   -77,   -19,
		-37,    -8,   -41,    -9,   -45,   -11,   -51,   -12,   -56,   -13,   -63,   -15,   -69,   -17,   -77,   -19,
		-85,   -21,   -94,   -23,  -104,   -26,  -114,   -29,  -126,   -32,  -138,   -35,  -152,   -39,  -167,   -44,
		-85,   -21,   -94,   -23,  -104,   -26,  -114,   -29,  -126,   -32,  -138,   -35,  -152,   -39,  -167,   -44,
	 -183,   -48,  -200,   -53,  -219,   -59,  -239,   -64,  -261,   -71,  -284,   -78,  -310,   -86,  -337,   -94,
	 -183,   -48,  -200,   -53,  -219,   -59,  -239,   -64,  -261,   -71,  -284,   -78,  -310,   -86,  -337,   -94,
	 -365,  -103,  -396,  -112,  -429,  -123,  -465,  -134,  -502,  -146,  -542,  -159,  -585,  -173,  -630,  -187,
	 -365,  -103,  -396,  -112,  -429,  -123,  -465,  -134,  -502,  -146,  -542,  -159,  -585,  -173,  -630,  -187,
	 -677,  -203,  -728,  -220,  -781,  -238,  -837,  -258,  -896,  -278,  -958,  -300, -1023,  -323, -1091,  -348,
	 -677,  -203,  -728,  -220,  -781,  -238,  -837,  -258,  -896,  -278,  -958,  -300, -1023,  -323, -1091,  -348,
	-1162,  -374, -1237,  -401, -1314,  -430, -1395,  -460, -1479,  -492, -1565,  -525, -1655,  -560, -1747,  -597,
	-1162,  -374, -1237,  -401, -1314,  -430, -1395,  -460, -1479,  -492, -1565,  -525, -1655,  -560, -1747,  -597,
	-1843,  -635, -1941,  -675, -2041,  -716, -2144,  -759, -2250,  -803, -2357,  -849, -2466,  -896, -2577,  -945,
	-1843,  -635, -1941,  -675, -2041,  -716, -2144,  -759, -2250,  -803, -2357,  -849, -2466,  -896, -2577,  -945,
	-2689,  -994, -2802, -1045, -2915, -1097, -3029, -1150, -3144, -1204, -3257, -1258, -3371, -1313, -3483, -1368,
	-2689,  -994, -2802, -1045, -2915, -1097, -3029, -1150, -3144, -1204, -3257, -1258, -3371, -1313, -3483, -1368,
	-3593, -1424, -3702, -1479, -3808, -1534, -3911, -1588, -4011, -1641, -4108, -1693, -4200, -1744, -4287, -1793,
	-3593, -1424, -3702, -1479, -3808, -1534, -3911, -1588, -4011, -1641, -4108, -1693, -4200, -1744, -4287, -1793,
	-4369, -1840, -4445, -1884, -4516, -1926, -4579, -1965, -4636, -2000, -4685, -2030, -4727, -2057, -4760, -2079,
	-4369, -1840, -4445, -1884, -4516, -1926, -4579, -1965, -4636, -2000, -4685, -2030, -4727, -2057, -4760, -2079,
	-4785, -2095, -4801, -2106, -4808, -2111, -4806, -2109, -4794, -2101, -4772, -2084, -4740, -2060, -4699, -2028,
	-4785, -2095, -4801, -2106, -4808, -2111, -4806, -2109, -4794, -2101, -4772, -2084, -4740, -2060, -4699, -2028,
	-4648, -1987, -4587, -1937, -4516, -1878, -4436, -1808, -4346, -1728, -4247, -1638, -4140, -1537, -4024, -1425,
	-4648, -1987, -4587, -1937, -4516, -1878, -4436, -1808, -4346, -1728, -4247, -1638, -4140, -1537, -4024, -1425,
	-3900, -1301, -3769, -1165, -3630, -1017, -3486,  -858, -3335,  -686, -3180,  -501, -3020,  -305, -2856,   -96,
	-3900, -1301, -3769, -1165, -3630, -1017, -3486,  -858, -3335,  -686, -3180,  -501, -3020,  -305, -2856,   -96,
	-2690,   125, -2522,   359, -2353,   605, -2183,   864, -2014,  1134, -1847,  1416, -1681,  1710, -1520,  2015,
	-2690,   125, -2522,   359, -2353,   605, -2183,   864, -2014,  1134, -1847,  1416, -1681,  1710, -1520,  2015,
	-1362,  2330, -1209,  2656, -1062,  2991,  -922,  3336,  -789,  3690,  -665,  4053,  -549,  4423,  -443,  4800,
	-1362,  2330, -1209,  2656, -1062,  2991,  -922,  3336,  -789,  3690,  -665,  4053,  -549,  4423,  -443,  4800,
	 -347,  5183,  -262,  5573,  -188,  5967,  -126,  6365,   -76,  6767,   -38,  7172,   -12,  7579,     0,  7987,
	 -347,  5183,  -262,  5573,  -188,  5967,  -126,  6365,   -76,  6767,   -38,  7172,   -12,  7579,     0,  7987,
			0,  8396,   -12,  8804,   -38,  9211,   -76,  9616,  -126, 10018,  -188, 10416,  -262, 10810,  -347, 11200,
			0,  8396,   -12,  8804,   -38,  9211,   -76,  9616,  -126, 10018,  -188, 10416,  -262, 10810,  -347, 11200,
	 -443, 11583,  -549, 11960,  -665, 12330,  -789, 12693,  -922, 13047, -1062, 13392, -1209, 13727, -1362, 14053,
	 -443, 11583,  -549, 11960,  -665, 12330,  -789, 12693,  -922, 13047, -1062, 13392, -1209, 13727, -1362, 14053,
	-1520, 14368, -1681, 14673, -1847, 14967, -2014, 15249, -2183, 15519, -2353, 15778, -2522, 16024, -2690, 16258,
	-1520, 14368, -1681, 14673, -1847, 14967, -2014, 15249, -2183, 15519, -2353, 15778, -2522, 16024, -2690, 16258,
	-2856, 16480, -3020, 16689, -3180, 16885, -3335, 17070, -3486, 17242, -3630, 17401, -3769, 17549, -3900, 17685,
	-2856, 16480, -3020, 16689, -3180, 16885, -3335, 17070, -3486, 17242, -3630, 17401, -3769, 17549, -3900, 17685,
	-4024, 17809, -4140, 17921, -4247, 18022, -4346, 18112, -4436, 18192, -4516, 18262, -4587, 18321, -4648, 18371,
	-4024, 17809, -4140, 17921, -4247, 18022, -4346, 18112, -4436, 18192, -4516, 18262, -4587, 18321, -4648, 18371,
	-4699, 18412, -4740, 18444, -4772, 18468, -4794, 18485, -4806, 18493, -4808, 18495, -4801, 18490, -4785, 18479,
	-4699, 18412, -4740, 18444, -4772, 18468, -4794, 18485, -4806, 18493, -4808, 18495, -4801, 18490, -4785, 18479,
	-4760, 18463, -4727, 18441, -4685, 18414, -4636, 18384, -4579, 18349, -4516, 18310, -4445, 18268, -4369, 18224,
	-4760, 18463, -4727, 18441, -4685, 18414, -4636, 18384, -4579, 18349, -4516, 18310, -4445, 18268, -4369, 18224,
	-4287, 18177, -4200, 18128, -4108, 18077, -4011, 18025, -3911, 17972, -3808, 17918, -3702, 17863, -3593, 17808,
	-4287, 18177, -4200, 18128, -4108, 18077, -4011, 18025, -3911, 17972, -3808, 17918, -3702, 17863, -3593, 17808,
	-3483, 17752, -3371, 17697, -3257, 17642, -3144, 17588, -3029, 17534, -2915, 17481, -2802, 17429, -2689, 17378,
	-3483, 17752, -3371, 17697, -3257, 17642, -3144, 17588, -3029, 17534, -2915, 17481, -2802, 17429, -2689, 17378,
	-2577, 17329, -2466, 17280, -2357, 17233, -2250, 17187, -2144, 17143, -2041, 17100, -1941, 17059, -1843, 17019,
	-2577, 17329, -2466, 17280, -2357, 17233, -2250, 17187, -2144, 17143, -2041, 17100, -1941, 17059, -1843, 17019,
	-1747, 16981, -1655, 16944, -1565, 16909, -1479, 16876, -1395, 16844, -1314, 16814, -1237, 16785, -1162, 16758,
	-1747, 16981, -1655, 16944, -1565, 16909, -1479, 16876, -1395, 16844, -1314, 16814, -1237, 16785, -1162, 16758,
	-1091, 16732, -1023, 16707,  -958, 16684,  -896, 16662,  -837, 16642,  -781, 16622,  -728, 16604,  -677, 16587,
	-1091, 16732, -1023, 16707,  -958, 16684,  -896, 16662,  -837, 16642,  -781, 16622,  -728, 16604,  -677, 16587,
	 -630, 16571,  -585, 16557,  -542, 16543,  -502, 16530,  -465, 16518,  -429, 16507,  -396, 16496,  -365, 16487,
	 -630, 16571,  -585, 16557,  -542, 16543,  -502, 16530,  -465, 16518,  -429, 16507,  -396, 16496,  -365, 16487,
	 -337, 16478,  -310, 16470,  -284, 16462,  -261, 16455,  -239, 16448,  -219, 16443,  -200, 16437,  -183, 16432,
	 -337, 16478,  -310, 16470,  -284, 16462,  -261, 16455,  -239, 16448,  -219, 16443,  -200, 16437,  -183, 16432,
	 -167, 16428,  -152, 16423,  -138, 16419,  -126, 16416,  -114, 16413,  -104, 16410,   -94, 16407,   -85, 16405,
	 -167, 16428,  -152, 16423,  -138, 16419,  -126, 16416,  -114, 16413,  -104, 16410,   -94, 16407,   -85, 16405,
	-77, 16403,   -69, 16401,   -63, 16399,   -56, 16397,   -51, 16396,   -45, 16395,   -41, 16393,   -37, 16392,
	-77, 16403,   -69, 16401,   -63, 16399,   -56, 16397,   -51, 16396,   -45, 16395,   -41, 16393,   -37, 16392,
	-33, 16391,   -29, 16390,   -26, 16390,   -23, 16389,   -21, 16388,   -18, 16388,   -16, 16387,   -14, 16387,
	-33, 16391,   -29, 16390,   -26, 16390,   -23, 16389,   -21, 16388,   -18, 16388,   -16, 16387,   -14, 16387,
	-13, 16386,   -11, 16386,   -10, 16386,    -9, 16386,    -8, 16385,    -7, 16385,    -6, 16385,    -5, 16385,
	-13, 16386,   -11, 16386,   -10, 16386,    -9, 16386,    -8, 16385,    -7, 16385,    -6, 16385,    -5, 16385,
	 -4, 16385,    -4, 16384,    -3, 16384,    -3, 16384,    -2, 16384,    -2, 16384,    -2, 16384,    -1, 16384,
	 -4, 16385,    -4, 16384,    -3, 16384,    -3, 16384,    -2, 16384,    -2, 16384,    -2, 16384,    -1, 16384,
	 -1, 16384,    -1, 16384,    -1, 16384,    -1, 16384,    -1, 16384,     0, 16384,     0, 16384,     0, 16384,
	 -1, 16384,    -1, 16384,    -1, 16384,    -1, 16384,    -1, 16384,     0, 16384,     0, 16384,     0, 16384
	};
}

#endif //GELU_LUT_INT16_512_H
