#ifndef TENSOR_LUT_HPP
#define TENSOR_LUT_HPP

#include <stdint.h>
#include <assert.h>

#include <iostream>
#include <type_traits>
#include <cmath>
#include <cassert>

#include "../pwl_nlf/sigmoid_lut_bf16_512.h"  //TODO: Do we need this?
#include "../pwl_nlf/sigmoid_lut_int16_512.h"  //TODO: Do we need this?
#include "../pwl_nlf/gelu_lut_bf16_512.h"     //TODO: Do we need this?
#include "../pwl_nlf/gelu_lut_int16_512.h"     //TODO: Do we need this?

/*
inline bfloat16_t float_to_bfloat16(float fp)
{
    uint32_t bits = float_to_uint(fp);
    uint32_t lsb = (bits >> 16) & 0x1;
    uint32_t bias = 0x7FFF + lsb;
    uint32_t rnd = bits + bias;
    return bfloat16_t{uint16_t(rnd >> 16)};
}
*/

struct LUTPkg {
		const void* lutab_data;
		const void* lutcd_data;
		uint16_t out_q_zero_point;
		uint16_t out_q_scale;
		uint16_t out_quant_enable;
		uint16_t in_q_zero_point;
		uint16_t in_q_scale;
		uint16_t in_quant_enable;

		// Constructor call
		LUTPkg(const std::string& opcode, const std::string& dtype, uint16_t out_qzp, uint16_t out_qs, uint16_t out_qe, uint16_t in_qzp, uint16_t in_qs, uint16_t in_qe)
				: lutab_data(nullptr), lutcd_data(nullptr), out_q_zero_point(out_qzp), out_q_scale(out_qs), out_quant_enable(out_qe),
					in_q_zero_point(in_qzp), in_q_scale(in_qs), in_quant_enable(in_qe) 
				{
					if (opcode == "Silu") {
						if (dtype == "bf16_512") {
								lutab_data = silu_bf16::lnr_lutab;
								lutcd_data = silu_bf16::lnr_lutcd;
						} else if (dtype == "int16_512") {
									lutab_data = silu_int16::lnr_lutab;
									lutcd_data = silu_int16::lnr_lutcd;
						} else {
								std::cout<<"Invalid dtype. Please check!!"<<std::endl;
								assert(false);
						}
					} else if (opcode == "Gelu") {
							if (dtype == "bf16_512") {
								lutab_data = gelu_bf16::lnr_lutab;
								lutcd_data = gelu_bf16::lnr_lutcd;
							} else if (dtype == "int16_512") {
								lutab_data = gelu_int16::lnr_lutab;
								lutcd_data = gelu_int16::lnr_lutcd;
							} else {
									std::cout<<"Invalid dtype. Please check!!"<<std::endl;
									assert(false);
							}
					} else {
							assert(false && "Invalid opcode. Please check!!");
					}
				}
};

#endif // TENSOR_LUT_HPP
