#ifndef SILU_LUT_BF16_512_H
#define SILU_LUT_BF16_512_H

namespace silu_bf16 {
	const int lut_sz = 160*2;
	static const uint16_t lnr_lutab[lut_sz*2*2]={
	0x0000 , 0x0000 , 0xbe2f , 0xbce1 , 0xbe32 , 0xbce6 , 0xbe35 , 0xbcec , 0xbe39 , 0xbcf1 , 0xbe3c , 0xbcf6 , 0xbe3f , 0xbcfc , 0xbe43 , 0xbd01 , 
	0x0000 , 0x0000 , 0xbe2f , 0xbce1 , 0xbe32 , 0xbce6 , 0xbe35 , 0xbcec , 0xbe39 , 0xbcf1 , 0xbe3c , 0xbcf6 , 0xbe3f , 0xbcfc , 0xbe43 , 0xbd01 , 
	0xbe46 , 0xbd04 , 0xbe4a , 0xbd07 , 0xbe4d , 0xbd0a , 0xbe51 , 0xbd0d , 0xbe54 , 0xbd10 , 0xbe58 , 0xbd13 , 0xbe5c , 0xbd16 , 0xbe5f , 0xbd1a , 
	0xbe46 , 0xbd04 , 0xbe4a , 0xbd07 , 0xbe4d , 0xbd0a , 0xbe51 , 0xbd0d , 0xbe54 , 0xbd10 , 0xbe58 , 0xbd13 , 0xbe5c , 0xbd16 , 0xbe5f , 0xbd1a , 
	0xbe63 , 0xbd1d , 0xbe67 , 0xbd20 , 0xbe6b , 0xbd24 , 0xbe6f , 0xbd27 , 0xbe73 , 0xbd2b , 0xbe77 , 0xbd2e , 0xbe7a , 0xbd32 , 0xbe7e , 0xbd36 , 
	0xbe63 , 0xbd1d , 0xbe67 , 0xbd20 , 0xbe6b , 0xbd24 , 0xbe6f , 0xbd27 , 0xbe73 , 0xbd2b , 0xbe77 , 0xbd2e , 0xbe7a , 0xbd32 , 0xbe7e , 0xbd36 , 
	0xbe81 , 0xbd3a , 0xbe83 , 0xbd3e , 0xbe85 , 0xbd41 , 0xbe87 , 0xbd45 , 0xbe89 , 0xbd49 , 0xbe8b , 0xbd4d , 0xbe8e , 0xbd51 , 0xbe90 , 0xbd56 , 
	0xbe81 , 0xbd3a , 0xbe83 , 0xbd3e , 0xbe85 , 0xbd41 , 0xbe87 , 0xbd45 , 0xbe89 , 0xbd49 , 0xbe8b , 0xbd4d , 0xbe8e , 0xbd51 , 0xbe90 , 0xbd56 , 
	0xbe92 , 0xbd5a , 0xbe94 , 0xbd5e , 0xbe96 , 0xbd62 , 0xbe98 , 0xbd67 , 0xbe9a , 0xbd6b , 0xbe9c , 0xbd6f , 0xbe9e , 0xbd74 , 0xbea1 , 0xbd78 , 
	0xbe92 , 0xbd5a , 0xbe94 , 0xbd5e , 0xbe96 , 0xbd62 , 0xbe98 , 0xbd67 , 0xbe9a , 0xbd6b , 0xbe9c , 0xbd6f , 0xbe9e , 0xbd74 , 0xbea1 , 0xbd78 , 
	0xbea3 , 0xbd7d , 0xbea5 , 0xbd81 , 0xbea7 , 0xbd83 , 0xbea9 , 0xbd85 , 0xbeab , 0xbd88 , 0xbead , 0xbd8a , 0xbeaf , 0xbd8c , 0xbeb1 , 0xbd8f , 
	0xbea3 , 0xbd7d , 0xbea5 , 0xbd81 , 0xbea7 , 0xbd83 , 0xbea9 , 0xbd85 , 0xbeab , 0xbd88 , 0xbead , 0xbd8a , 0xbeaf , 0xbd8c , 0xbeb1 , 0xbd8f , 
	0xbeb3 , 0xbd91 , 0xbeb6 , 0xbd93 , 0xbeb8 , 0xbd96 , 0xbeba , 0xbd98 , 0xbebc , 0xbd9b , 0xbebe , 0xbd9d , 0xbebf , 0xbd9f , 0xbec1 , 0xbda2 , 
	0xbeb3 , 0xbd91 , 0xbeb6 , 0xbd93 , 0xbeb8 , 0xbd96 , 0xbeba , 0xbd98 , 0xbebc , 0xbd9b , 0xbebe , 0xbd9d , 0xbebf , 0xbd9f , 0xbec1 , 0xbda2 , 
	0xbec3 , 0xbda4 , 0xbec5 , 0xbda6 , 0xbec7 , 0xbda8 , 0xbec9 , 0xbdab , 0xbeca , 0xbdad , 0xbecc , 0xbdaf , 0xbece , 0xbdb1 , 0xbecf , 0xbdb3 , 
	0xbec3 , 0xbda4 , 0xbec5 , 0xbda6 , 0xbec7 , 0xbda8 , 0xbec9 , 0xbdab , 0xbeca , 0xbdad , 0xbecc , 0xbdaf , 0xbece , 0xbdb1 , 0xbecf , 0xbdb3 , 
	0xbed1 , 0xbdb5 , 0xbed2 , 0xbdb7 , 0xbed4 , 0xbdb9 , 0xbed5 , 0xbdbb , 0xbed7 , 0xbdbd , 0xbed8 , 0xbdbf , 0xbed9 , 0xbdc1 , 0xbeda , 0xbdc2 , 
	0xbed1 , 0xbdb5 , 0xbed2 , 0xbdb7 , 0xbed4 , 0xbdb9 , 0xbed5 , 0xbdbb , 0xbed7 , 0xbdbd , 0xbed8 , 0xbdbf , 0xbed9 , 0xbdc1 , 0xbeda , 0xbdc2 , 
	0xbedb , 0xbdc4 , 0xbedc , 0xbdc5 , 0xbedd , 0xbdc6 , 0xbede , 0xbdc8 , 0xbedf , 0xbdc9 , 0xbedf , 0xbdca , 0xbee0 , 0xbdcb , 0xbee0 , 0xbdcb , 
	0xbedb , 0xbdc4 , 0xbedc , 0xbdc5 , 0xbedd , 0xbdc6 , 0xbede , 0xbdc8 , 0xbedf , 0xbdc9 , 0xbedf , 0xbdca , 0xbee0 , 0xbdcb , 0xbee0 , 0xbdcb , 
	0xbee0 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee0 , 0xbdcb , 0xbee0 , 0xbdcb , 
	0xbee0 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee0 , 0xbdcb , 0xbee0 , 0xbdcb , 
	0xbedf , 0xbdca , 0xbedf , 0xbdc8 , 0xbede , 0xbdc7 , 0xbedd , 0xbdc5 , 0xbedc , 0xbdc3 , 0xbedb , 0xbdc1 , 0xbed9 , 0xbdbe , 0xbed8 , 0xbdbb , 
	0xbedf , 0xbdca , 0xbedf , 0xbdc8 , 0xbede , 0xbdc7 , 0xbedd , 0xbdc5 , 0xbedc , 0xbdc3 , 0xbedb , 0xbdc1 , 0xbed9 , 0xbdbe , 0xbed8 , 0xbdbb , 
	0xbed6 , 0xbdb8 , 0xbed4 , 0xbdb5 , 0xbed3 , 0xbdb1 , 0xbed1 , 0xbdad , 0xbece , 0xbda8 , 0xbecc , 0xbda3 , 0xbeca , 0xbd9e , 0xbec7 , 0xbd98 , 
	0xbed6 , 0xbdb8 , 0xbed4 , 0xbdb5 , 0xbed3 , 0xbdb1 , 0xbed1 , 0xbdad , 0xbece , 0xbda8 , 0xbecc , 0xbda3 , 0xbeca , 0xbd9e , 0xbec7 , 0xbd98 , 
	0xbec4 , 0xbd92 , 0xbec2 , 0xbd8b , 0xbebf , 0xbd84 , 0xbebb , 0xbd79 , 0xbeb8 , 0xbd69 , 0xbeb5 , 0xbd58 , 0xbeb1 , 0xbd46 , 0xbeae , 0xbd33 , 
	0xbec4 , 0xbd92 , 0xbec2 , 0xbd8b , 0xbebf , 0xbd84 , 0xbebb , 0xbd79 , 0xbeb8 , 0xbd69 , 0xbeb5 , 0xbd58 , 0xbeb1 , 0xbd46 , 0xbeae , 0xbd33 , 
	0xbeaa , 0xbd1f , 0xbea6 , 0xbd0a , 0xbea2 , 0xbce8 , 0xbe9e , 0xbcb9 , 0xbe9a , 0xbc88 , 0xbe96 , 0xbc2b , 0xbe91 , 0xbb81 , 0xbe8d , 0x3b3a , 
	0xbeaa , 0xbd1f , 0xbea6 , 0xbd0a , 0xbea2 , 0xbce8 , 0xbe9e , 0xbcb9 , 0xbe9a , 0xbc88 , 0xbe96 , 0xbc2b , 0xbe91 , 0xbb81 , 0xbe8d , 0x3b3a , 
	0xbe88 , 0x3c22 , 0xbe84 , 0x3c8d , 0xbe7e , 0x3ccc , 0xbe74 , 0x3d07 , 0xbe6b , 0x3d28 , 0xbe61 , 0x3d4b , 0xbe58 , 0x3d70 , 0xbe4e , 0x3d8b , 
	0xbe88 , 0x3c22 , 0xbe84 , 0x3c8d , 0xbe7e , 0x3ccc , 0xbe74 , 0x3d07 , 0xbe6b , 0x3d28 , 0xbe61 , 0x3d4b , 0xbe58 , 0x3d70 , 0xbe4e , 0x3d8b , 
	0xbe44 , 0x3d9e , 0xbe3b , 0x3db2 , 0xbe31 , 0x3dc6 , 0xbe28 , 0x3ddc , 0xbe1e , 0x3df1 , 0xbe15 , 0x3e04 , 0xbe0b , 0x3e0f , 0xbe02 , 0x3e1b , 
	0xbe44 , 0x3d9e , 0xbe3b , 0x3db2 , 0xbe31 , 0x3dc6 , 0xbe28 , 0x3ddc , 0xbe1e , 0x3df1 , 0xbe15 , 0x3e04 , 0xbe0b , 0x3e0f , 0xbe02 , 0x3e1b , 
	0xbdf2 , 0x3e27 , 0xbde0 , 0x3e34 , 0xbdcf , 0x3e40 , 0xbdbe , 0x3e4d , 0xbdad , 0x3e5a , 0xbd9d , 0x3e68 , 0xbd8e , 0x3e75 , 0xbd7f , 0x3e82 , 
	0xbdf2 , 0x3e27 , 0xbde0 , 0x3e34 , 0xbdcf , 0x3e40 , 0xbdbe , 0x3e4d , 0xbdad , 0x3e5a , 0xbd9d , 0x3e68 , 0xbd8e , 0x3e75 , 0xbd7f , 0x3e82 , 
	0xbd62 , 0x3e89 , 0xbd48 , 0x3e90 , 0xbd2e , 0x3e97 , 0xbd16 , 0x3e9e , 0xbd00 , 0x3ea6 , 0xbcd6 , 0x3ead , 0xbcb0 , 0x3eb5 , 0xbc8d , 0x3ebd , 
	0xbd62 , 0x3e89 , 0xbd48 , 0x3e90 , 0xbd2e , 0x3e97 , 0xbd16 , 0x3e9e , 0xbd00 , 0x3ea6 , 0xbcd6 , 0x3ead , 0xbcb0 , 0x3eb5 , 0xbc8d , 0x3ebd , 
	0xbc5d , 0x3ec5 , 0xbc26 , 0x3ecc , 0xbbee , 0x3ed4 , 0xbb9f , 0x3edc , 0xbb3f , 0x3ee4 , 0xbac0 , 0x3eec , 0xba00 , 0x3ef4 , 0xafaa , 0x3efc , 
	0xbc5d , 0x3ec5 , 0xbc26 , 0x3ecc , 0xbbee , 0x3ed4 , 0xbb9f , 0x3edc , 0xbb3f , 0x3ee4 , 0xbac0 , 0x3eec , 0xba00 , 0x3ef4 , 0xafaa , 0x3efc , 
	0x0000 , 0x3f02 , 0xba00 , 0x3f06 , 0xbac0 , 0x3f0a , 0xbb3f , 0x3f0e , 0xbb9f , 0x3f12 , 0xbbee , 0x3f16 , 0xbc26 , 0x3f1a , 0xbc5d , 0x3f1e , 
	0x0000 , 0x3f02 , 0xba00 , 0x3f06 , 0xbac0 , 0x3f0a , 0xbb3f , 0x3f0e , 0xbb9f , 0x3f12 , 0xbbee , 0x3f16 , 0xbc26 , 0x3f1a , 0xbc5d , 0x3f1e , 
	0xbc8d , 0x3f22 , 0xbcb0 , 0x3f25 , 0xbcd6 , 0x3f29 , 0xbd00 , 0x3f2d , 0xbd16 , 0x3f31 , 0xbd2e , 0x3f34 , 0xbd48 , 0x3f38 , 0xbd62 , 0x3f3c , 
	0xbc8d , 0x3f22 , 0xbcb0 , 0x3f25 , 0xbcd6 , 0x3f29 , 0xbd00 , 0x3f2d , 0xbd16 , 0x3f31 , 0xbd2e , 0x3f34 , 0xbd48 , 0x3f38 , 0xbd62 , 0x3f3c , 
	0xbd7f , 0x3f3f , 0xbd8e , 0x3f43 , 0xbd9d , 0x3f46 , 0xbdad , 0x3f49 , 0xbdbe , 0x3f4d , 0xbdcf , 0x3f50 , 0xbde0 , 0x3f53 , 0xbdf2 , 0x3f56 , 
	0xbd7f , 0x3f3f , 0xbd8e , 0x3f43 , 0xbd9d , 0x3f46 , 0xbdad , 0x3f49 , 0xbdbe , 0x3f4d , 0xbdcf , 0x3f50 , 0xbde0 , 0x3f53 , 0xbdf2 , 0x3f56 , 
	0xbe02 , 0x3f59 , 0xbe0b , 0x3f5c , 0xbe15 , 0x3f5f , 0xbe1e , 0x3f62 , 0xbe28 , 0x3f65 , 0xbe31 , 0x3f67 , 0xbe3b , 0x3f6a , 0xbe44 , 0x3f6c , 
	0xbe02 , 0x3f59 , 0xbe0b , 0x3f5c , 0xbe15 , 0x3f5f , 0xbe1e , 0x3f62 , 0xbe28 , 0x3f65 , 0xbe31 , 0x3f67 , 0xbe3b , 0x3f6a , 0xbe44 , 0x3f6c , 
	0xbe4e , 0x3f6f , 0xbe58 , 0x3f71 , 0xbe61 , 0x3f73 , 0xbe6b , 0x3f75 , 0xbe74 , 0x3f78 , 0xbe7e , 0x3f7a , 0xbe84 , 0x3f7c , 0xbe88 , 0x3f7d , 
	0xbe4e , 0x3f6f , 0xbe58 , 0x3f71 , 0xbe61 , 0x3f73 , 0xbe6b , 0x3f75 , 0xbe74 , 0x3f78 , 0xbe7e , 0x3f7a , 0xbe84 , 0x3f7c , 0xbe88 , 0x3f7d , 
	0xbe8d , 0x3f7f , 0xbe91 , 0x3f81 , 0xbe96 , 0x3f81 , 0xbe9a , 0x3f82 , 0xbe9e , 0x3f83 , 0xbea2 , 0x3f84 , 0xbea6 , 0x3f84 , 0xbeaa , 0x3f85 , 
	0xbe8d , 0x3f7f , 0xbe91 , 0x3f81 , 0xbe96 , 0x3f81 , 0xbe9a , 0x3f82 , 0xbe9e , 0x3f83 , 0xbea2 , 0x3f84 , 0xbea6 , 0x3f84 , 0xbeaa , 0x3f85 , 
	0xbeae , 0x3f86 , 0xbeb1 , 0x3f86 , 0xbeb5 , 0x3f87 , 0xbeb8 , 0x3f87 , 0xbebb , 0x3f88 , 0xbebf , 0x3f88 , 0xbec2 , 0x3f89 , 0xbec4 , 0x3f89 , 
	0xbeae , 0x3f86 , 0xbeb1 , 0x3f86 , 0xbeb5 , 0x3f87 , 0xbeb8 , 0x3f87 , 0xbebb , 0x3f88 , 0xbebf , 0x3f88 , 0xbec2 , 0x3f89 , 0xbec4 , 0x3f89 , 
	0xbec7 , 0x3f89 , 0xbeca , 0x3f8a , 0xbecc , 0x3f8a , 0xbece , 0x3f8b , 0xbed1 , 0x3f8b , 0xbed3 , 0x3f8b , 0xbed4 , 0x3f8b , 0xbed6 , 0x3f8c , 
	0xbec7 , 0x3f89 , 0xbeca , 0x3f8a , 0xbecc , 0x3f8a , 0xbece , 0x3f8b , 0xbed1 , 0x3f8b , 0xbed3 , 0x3f8b , 0xbed4 , 0x3f8b , 0xbed6 , 0x3f8c , 
	0xbed8 , 0x3f8c , 0xbed9 , 0x3f8c , 0xbedb , 0x3f8c , 0xbedc , 0x3f8c , 0xbedd , 0x3f8c , 0xbede , 0x3f8c , 0xbedf , 0x3f8d , 0xbedf , 0x3f8d , 
	0xbed8 , 0x3f8c , 0xbed9 , 0x3f8c , 0xbedb , 0x3f8c , 0xbedc , 0x3f8c , 0xbedd , 0x3f8c , 0xbede , 0x3f8c , 0xbedf , 0x3f8d , 0xbedf , 0x3f8d , 
	0xbee0 , 0x3f8d , 0xbee0 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee0 , 0x3f8d , 
	0xbee0 , 0x3f8d , 0xbee0 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee0 , 0x3f8d , 
	0xbee0 , 0x3f8d , 0xbee0 , 0x3f8d , 0xbedf , 0x3f8d , 0xbedf , 0x3f8d , 0xbede , 0x3f8c , 0xbedd , 0x3f8c , 0xbedc , 0x3f8c , 0xbedb , 0x3f8c , 
	0xbee0 , 0x3f8d , 0xbee0 , 0x3f8d , 0xbedf , 0x3f8d , 0xbedf , 0x3f8d , 0xbede , 0x3f8c , 0xbedd , 0x3f8c , 0xbedc , 0x3f8c , 0xbedb , 0x3f8c , 
	0xbeda , 0x3f8c , 0xbed9 , 0x3f8c , 0xbed8 , 0x3f8c , 0xbed7 , 0x3f8c , 0xbed5 , 0x3f8c , 0xbed4 , 0x3f8c , 0xbed2 , 0x3f8b , 0xbed1 , 0x3f8b , 
	0xbeda , 0x3f8c , 0xbed9 , 0x3f8c , 0xbed8 , 0x3f8c , 0xbed7 , 0x3f8c , 0xbed5 , 0x3f8c , 0xbed4 , 0x3f8c , 0xbed2 , 0x3f8b , 0xbed1 , 0x3f8b , 
	0xbecf , 0x3f8b , 0xbece , 0x3f8b , 0xbecc , 0x3f8b , 0xbeca , 0x3f8b , 0xbec9 , 0x3f8b , 0xbec7 , 0x3f8b , 0xbec5 , 0x3f8a , 0xbec3 , 0x3f8a , 
	0xbecf , 0x3f8b , 0xbece , 0x3f8b , 0xbecc , 0x3f8b , 0xbeca , 0x3f8b , 0xbec9 , 0x3f8b , 0xbec7 , 0x3f8b , 0xbec5 , 0x3f8a , 0xbec3 , 0x3f8a , 
	0xbec1 , 0x3f8a , 0xbebf , 0x3f8a , 0xbebe , 0x3f8a , 0xbebc , 0x3f8a , 0xbeba , 0x3f8a , 0xbeb8 , 0x3f89 , 0xbeb6 , 0x3f89 , 0xbeb3 , 0x3f89 , 
	0xbec1 , 0x3f8a , 0xbebf , 0x3f8a , 0xbebe , 0x3f8a , 0xbebc , 0x3f8a , 0xbeba , 0x3f8a , 0xbeb8 , 0x3f89 , 0xbeb6 , 0x3f89 , 0xbeb3 , 0x3f89 , 
	0xbeb1 , 0x3f89 , 0xbeaf , 0x3f89 , 0xbead , 0x3f89 , 0xbeab , 0x3f88 , 0xbea9 , 0x3f88 , 0xbea7 , 0x3f88 , 0xbea5 , 0x3f88 , 0xbea3 , 0x3f88 , 
	0xbeb1 , 0x3f89 , 0xbeaf , 0x3f89 , 0xbead , 0x3f89 , 0xbeab , 0x3f88 , 0xbea9 , 0x3f88 , 0xbea7 , 0x3f88 , 0xbea5 , 0x3f88 , 0xbea3 , 0x3f88 , 
	0xbea1 , 0x3f88 , 0xbe9e , 0x3f88 , 0xbe9c , 0x3f87 , 0xbe9a , 0x3f87 , 0xbe98 , 0x3f87 , 0xbe96 , 0x3f87 , 0xbe94 , 0x3f87 , 0xbe92 , 0x3f87 , 
	0xbea1 , 0x3f88 , 0xbe9e , 0x3f88 , 0xbe9c , 0x3f87 , 0xbe9a , 0x3f87 , 0xbe98 , 0x3f87 , 0xbe96 , 0x3f87 , 0xbe94 , 0x3f87 , 0xbe92 , 0x3f87 , 
	0xbe90 , 0x3f87 , 0xbe8e , 0x3f87 , 0xbe8b , 0x3f86 , 0xbe89 , 0x3f86 , 0xbe87 , 0x3f86 , 0xbe85 , 0x3f86 , 0xbe83 , 0x3f86 , 0xbe81 , 0x3f86 , 
	0xbe90 , 0x3f87 , 0xbe8e , 0x3f87 , 0xbe8b , 0x3f86 , 0xbe89 , 0x3f86 , 0xbe87 , 0x3f86 , 0xbe85 , 0x3f86 , 0xbe83 , 0x3f86 , 0xbe81 , 0x3f86 , 
	0xbe7e , 0x3f86 , 0xbe7a , 0x3f86 , 0xbe77 , 0x3f85 , 0xbe73 , 0x3f85 , 0xbe6f , 0x3f85 , 0xbe6b , 0x3f85 , 0xbe67 , 0x3f85 , 0xbe63 , 0x3f85 , 
	0xbe7e , 0x3f86 , 0xbe7a , 0x3f86 , 0xbe77 , 0x3f85 , 0xbe73 , 0x3f85 , 0xbe6f , 0x3f85 , 0xbe6b , 0x3f85 , 0xbe67 , 0x3f85 , 0xbe63 , 0x3f85 , 
	0xbe5f , 0x3f85 , 0xbe5c , 0x3f85 , 0xbe58 , 0x3f85 , 0xbe54 , 0x3f84 , 0xbe51 , 0x3f84 , 0xbe4d , 0x3f84 , 0xbe4a , 0x3f84 , 0xbe46 , 0x3f84 , 
	0xbe5f , 0x3f85 , 0xbe5c , 0x3f85 , 0xbe58 , 0x3f85 , 0xbe54 , 0x3f84 , 0xbe51 , 0x3f84 , 0xbe4d , 0x3f84 , 0xbe4a , 0x3f84 , 0xbe46 , 0x3f84 , 
	0xbe43 , 0x3f84 , 0xbe3f , 0x3f84 , 0xbe3c , 0x3f84 , 0xbe39 , 0x3f84 , 0xbe35 , 0x3f84 , 0xbe32 , 0x3f84 , 0xbe2f , 0x3f84 , 0x0000 , 0x3f80 , 
	0xbe43 , 0x3f84 , 0xbe3f , 0x3f84 , 0xbe3c , 0x3f84 , 0xbe39 , 0x3f84 , 0xbe35 , 0x3f84 , 0xbe32 , 0x3f84 , 0xbe2f , 0x3f84 , 0x0000 , 0x3f80 
	};

	static const uint16_t lnr_lutcd[lut_sz*2*2]={
	0x0000 , 0x0000 , 0xbe2f , 0xbce1 , 0xbe32 , 0xbce6 , 0xbe35 , 0xbcec , 0xbe39 , 0xbcf1 , 0xbe3c , 0xbcf6 , 0xbe3f , 0xbcfc , 0xbe43 , 0xbd01 , 
	0x0000 , 0x0000 , 0xbe2f , 0xbce1 , 0xbe32 , 0xbce6 , 0xbe35 , 0xbcec , 0xbe39 , 0xbcf1 , 0xbe3c , 0xbcf6 , 0xbe3f , 0xbcfc , 0xbe43 , 0xbd01 , 
	0xbe46 , 0xbd04 , 0xbe4a , 0xbd07 , 0xbe4d , 0xbd0a , 0xbe51 , 0xbd0d , 0xbe54 , 0xbd10 , 0xbe58 , 0xbd13 , 0xbe5c , 0xbd16 , 0xbe5f , 0xbd1a , 
	0xbe46 , 0xbd04 , 0xbe4a , 0xbd07 , 0xbe4d , 0xbd0a , 0xbe51 , 0xbd0d , 0xbe54 , 0xbd10 , 0xbe58 , 0xbd13 , 0xbe5c , 0xbd16 , 0xbe5f , 0xbd1a , 
	0xbe63 , 0xbd1d , 0xbe67 , 0xbd20 , 0xbe6b , 0xbd24 , 0xbe6f , 0xbd27 , 0xbe73 , 0xbd2b , 0xbe77 , 0xbd2e , 0xbe7a , 0xbd32 , 0xbe7e , 0xbd36 , 
	0xbe63 , 0xbd1d , 0xbe67 , 0xbd20 , 0xbe6b , 0xbd24 , 0xbe6f , 0xbd27 , 0xbe73 , 0xbd2b , 0xbe77 , 0xbd2e , 0xbe7a , 0xbd32 , 0xbe7e , 0xbd36 , 
	0xbe81 , 0xbd3a , 0xbe83 , 0xbd3e , 0xbe85 , 0xbd41 , 0xbe87 , 0xbd45 , 0xbe89 , 0xbd49 , 0xbe8b , 0xbd4d , 0xbe8e , 0xbd51 , 0xbe90 , 0xbd56 , 
	0xbe81 , 0xbd3a , 0xbe83 , 0xbd3e , 0xbe85 , 0xbd41 , 0xbe87 , 0xbd45 , 0xbe89 , 0xbd49 , 0xbe8b , 0xbd4d , 0xbe8e , 0xbd51 , 0xbe90 , 0xbd56 , 
	0xbe92 , 0xbd5a , 0xbe94 , 0xbd5e , 0xbe96 , 0xbd62 , 0xbe98 , 0xbd67 , 0xbe9a , 0xbd6b , 0xbe9c , 0xbd6f , 0xbe9e , 0xbd74 , 0xbea1 , 0xbd78 , 
	0xbe92 , 0xbd5a , 0xbe94 , 0xbd5e , 0xbe96 , 0xbd62 , 0xbe98 , 0xbd67 , 0xbe9a , 0xbd6b , 0xbe9c , 0xbd6f , 0xbe9e , 0xbd74 , 0xbea1 , 0xbd78 , 
	0xbea3 , 0xbd7d , 0xbea5 , 0xbd81 , 0xbea7 , 0xbd83 , 0xbea9 , 0xbd85 , 0xbeab , 0xbd88 , 0xbead , 0xbd8a , 0xbeaf , 0xbd8c , 0xbeb1 , 0xbd8f , 
	0xbea3 , 0xbd7d , 0xbea5 , 0xbd81 , 0xbea7 , 0xbd83 , 0xbea9 , 0xbd85 , 0xbeab , 0xbd88 , 0xbead , 0xbd8a , 0xbeaf , 0xbd8c , 0xbeb1 , 0xbd8f , 
	0xbeb3 , 0xbd91 , 0xbeb6 , 0xbd93 , 0xbeb8 , 0xbd96 , 0xbeba , 0xbd98 , 0xbebc , 0xbd9b , 0xbebe , 0xbd9d , 0xbebf , 0xbd9f , 0xbec1 , 0xbda2 , 
	0xbeb3 , 0xbd91 , 0xbeb6 , 0xbd93 , 0xbeb8 , 0xbd96 , 0xbeba , 0xbd98 , 0xbebc , 0xbd9b , 0xbebe , 0xbd9d , 0xbebf , 0xbd9f , 0xbec1 , 0xbda2 , 
	0xbec3 , 0xbda4 , 0xbec5 , 0xbda6 , 0xbec7 , 0xbda8 , 0xbec9 , 0xbdab , 0xbeca , 0xbdad , 0xbecc , 0xbdaf , 0xbece , 0xbdb1 , 0xbecf , 0xbdb3 , 
	0xbec3 , 0xbda4 , 0xbec5 , 0xbda6 , 0xbec7 , 0xbda8 , 0xbec9 , 0xbdab , 0xbeca , 0xbdad , 0xbecc , 0xbdaf , 0xbece , 0xbdb1 , 0xbecf , 0xbdb3 , 
	0xbed1 , 0xbdb5 , 0xbed2 , 0xbdb7 , 0xbed4 , 0xbdb9 , 0xbed5 , 0xbdbb , 0xbed7 , 0xbdbd , 0xbed8 , 0xbdbf , 0xbed9 , 0xbdc1 , 0xbeda , 0xbdc2 , 
	0xbed1 , 0xbdb5 , 0xbed2 , 0xbdb7 , 0xbed4 , 0xbdb9 , 0xbed5 , 0xbdbb , 0xbed7 , 0xbdbd , 0xbed8 , 0xbdbf , 0xbed9 , 0xbdc1 , 0xbeda , 0xbdc2 , 
	0xbedb , 0xbdc4 , 0xbedc , 0xbdc5 , 0xbedd , 0xbdc6 , 0xbede , 0xbdc8 , 0xbedf , 0xbdc9 , 0xbedf , 0xbdca , 0xbee0 , 0xbdcb , 0xbee0 , 0xbdcb , 
	0xbedb , 0xbdc4 , 0xbedc , 0xbdc5 , 0xbedd , 0xbdc6 , 0xbede , 0xbdc8 , 0xbedf , 0xbdc9 , 0xbedf , 0xbdca , 0xbee0 , 0xbdcb , 0xbee0 , 0xbdcb , 
	0xbee0 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee0 , 0xbdcb , 0xbee0 , 0xbdcb , 
	0xbee0 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee1 , 0xbdcc , 0xbee0 , 0xbdcb , 0xbee0 , 0xbdcb , 
	0xbedf , 0xbdca , 0xbedf , 0xbdc8 , 0xbede , 0xbdc7 , 0xbedd , 0xbdc5 , 0xbedc , 0xbdc3 , 0xbedb , 0xbdc1 , 0xbed9 , 0xbdbe , 0xbed8 , 0xbdbb , 
	0xbedf , 0xbdca , 0xbedf , 0xbdc8 , 0xbede , 0xbdc7 , 0xbedd , 0xbdc5 , 0xbedc , 0xbdc3 , 0xbedb , 0xbdc1 , 0xbed9 , 0xbdbe , 0xbed8 , 0xbdbb , 
	0xbed6 , 0xbdb8 , 0xbed4 , 0xbdb5 , 0xbed3 , 0xbdb1 , 0xbed1 , 0xbdad , 0xbece , 0xbda8 , 0xbecc , 0xbda3 , 0xbeca , 0xbd9e , 0xbec7 , 0xbd98 , 
	0xbed6 , 0xbdb8 , 0xbed4 , 0xbdb5 , 0xbed3 , 0xbdb1 , 0xbed1 , 0xbdad , 0xbece , 0xbda8 , 0xbecc , 0xbda3 , 0xbeca , 0xbd9e , 0xbec7 , 0xbd98 , 
	0xbec4 , 0xbd92 , 0xbec2 , 0xbd8b , 0xbebf , 0xbd84 , 0xbebb , 0xbd79 , 0xbeb8 , 0xbd69 , 0xbeb5 , 0xbd58 , 0xbeb1 , 0xbd46 , 0xbeae , 0xbd33 , 
	0xbec4 , 0xbd92 , 0xbec2 , 0xbd8b , 0xbebf , 0xbd84 , 0xbebb , 0xbd79 , 0xbeb8 , 0xbd69 , 0xbeb5 , 0xbd58 , 0xbeb1 , 0xbd46 , 0xbeae , 0xbd33 , 
	0xbeaa , 0xbd1f , 0xbea6 , 0xbd0a , 0xbea2 , 0xbce8 , 0xbe9e , 0xbcb9 , 0xbe9a , 0xbc88 , 0xbe96 , 0xbc2b , 0xbe91 , 0xbb81 , 0xbe8d , 0x3b3a , 
	0xbeaa , 0xbd1f , 0xbea6 , 0xbd0a , 0xbea2 , 0xbce8 , 0xbe9e , 0xbcb9 , 0xbe9a , 0xbc88 , 0xbe96 , 0xbc2b , 0xbe91 , 0xbb81 , 0xbe8d , 0x3b3a , 
	0xbe88 , 0x3c22 , 0xbe84 , 0x3c8d , 0xbe7e , 0x3ccc , 0xbe74 , 0x3d07 , 0xbe6b , 0x3d28 , 0xbe61 , 0x3d4b , 0xbe58 , 0x3d70 , 0xbe4e , 0x3d8b , 
	0xbe88 , 0x3c22 , 0xbe84 , 0x3c8d , 0xbe7e , 0x3ccc , 0xbe74 , 0x3d07 , 0xbe6b , 0x3d28 , 0xbe61 , 0x3d4b , 0xbe58 , 0x3d70 , 0xbe4e , 0x3d8b , 
	0xbe44 , 0x3d9e , 0xbe3b , 0x3db2 , 0xbe31 , 0x3dc6 , 0xbe28 , 0x3ddc , 0xbe1e , 0x3df1 , 0xbe15 , 0x3e04 , 0xbe0b , 0x3e0f , 0xbe02 , 0x3e1b , 
	0xbe44 , 0x3d9e , 0xbe3b , 0x3db2 , 0xbe31 , 0x3dc6 , 0xbe28 , 0x3ddc , 0xbe1e , 0x3df1 , 0xbe15 , 0x3e04 , 0xbe0b , 0x3e0f , 0xbe02 , 0x3e1b , 
	0xbdf2 , 0x3e27 , 0xbde0 , 0x3e34 , 0xbdcf , 0x3e40 , 0xbdbe , 0x3e4d , 0xbdad , 0x3e5a , 0xbd9d , 0x3e68 , 0xbd8e , 0x3e75 , 0xbd7f , 0x3e82 , 
	0xbdf2 , 0x3e27 , 0xbde0 , 0x3e34 , 0xbdcf , 0x3e40 , 0xbdbe , 0x3e4d , 0xbdad , 0x3e5a , 0xbd9d , 0x3e68 , 0xbd8e , 0x3e75 , 0xbd7f , 0x3e82 , 
	0xbd62 , 0x3e89 , 0xbd48 , 0x3e90 , 0xbd2e , 0x3e97 , 0xbd16 , 0x3e9e , 0xbd00 , 0x3ea6 , 0xbcd6 , 0x3ead , 0xbcb0 , 0x3eb5 , 0xbc8d , 0x3ebd , 
	0xbd62 , 0x3e89 , 0xbd48 , 0x3e90 , 0xbd2e , 0x3e97 , 0xbd16 , 0x3e9e , 0xbd00 , 0x3ea6 , 0xbcd6 , 0x3ead , 0xbcb0 , 0x3eb5 , 0xbc8d , 0x3ebd , 
	0xbc5d , 0x3ec5 , 0xbc26 , 0x3ecc , 0xbbee , 0x3ed4 , 0xbb9f , 0x3edc , 0xbb3f , 0x3ee4 , 0xbac0 , 0x3eec , 0xba00 , 0x3ef4 , 0xafaa , 0x3efc , 
	0xbc5d , 0x3ec5 , 0xbc26 , 0x3ecc , 0xbbee , 0x3ed4 , 0xbb9f , 0x3edc , 0xbb3f , 0x3ee4 , 0xbac0 , 0x3eec , 0xba00 , 0x3ef4 , 0xafaa , 0x3efc , 
	0x0000 , 0x3f02 , 0xba00 , 0x3f06 , 0xbac0 , 0x3f0a , 0xbb3f , 0x3f0e , 0xbb9f , 0x3f12 , 0xbbee , 0x3f16 , 0xbc26 , 0x3f1a , 0xbc5d , 0x3f1e , 
	0x0000 , 0x3f02 , 0xba00 , 0x3f06 , 0xbac0 , 0x3f0a , 0xbb3f , 0x3f0e , 0xbb9f , 0x3f12 , 0xbbee , 0x3f16 , 0xbc26 , 0x3f1a , 0xbc5d , 0x3f1e , 
	0xbc8d , 0x3f22 , 0xbcb0 , 0x3f25 , 0xbcd6 , 0x3f29 , 0xbd00 , 0x3f2d , 0xbd16 , 0x3f31 , 0xbd2e , 0x3f34 , 0xbd48 , 0x3f38 , 0xbd62 , 0x3f3c , 
	0xbc8d , 0x3f22 , 0xbcb0 , 0x3f25 , 0xbcd6 , 0x3f29 , 0xbd00 , 0x3f2d , 0xbd16 , 0x3f31 , 0xbd2e , 0x3f34 , 0xbd48 , 0x3f38 , 0xbd62 , 0x3f3c , 
	0xbd7f , 0x3f3f , 0xbd8e , 0x3f43 , 0xbd9d , 0x3f46 , 0xbdad , 0x3f49 , 0xbdbe , 0x3f4d , 0xbdcf , 0x3f50 , 0xbde0 , 0x3f53 , 0xbdf2 , 0x3f56 , 
	0xbd7f , 0x3f3f , 0xbd8e , 0x3f43 , 0xbd9d , 0x3f46 , 0xbdad , 0x3f49 , 0xbdbe , 0x3f4d , 0xbdcf , 0x3f50 , 0xbde0 , 0x3f53 , 0xbdf2 , 0x3f56 , 
	0xbe02 , 0x3f59 , 0xbe0b , 0x3f5c , 0xbe15 , 0x3f5f , 0xbe1e , 0x3f62 , 0xbe28 , 0x3f65 , 0xbe31 , 0x3f67 , 0xbe3b , 0x3f6a , 0xbe44 , 0x3f6c , 
	0xbe02 , 0x3f59 , 0xbe0b , 0x3f5c , 0xbe15 , 0x3f5f , 0xbe1e , 0x3f62 , 0xbe28 , 0x3f65 , 0xbe31 , 0x3f67 , 0xbe3b , 0x3f6a , 0xbe44 , 0x3f6c , 
	0xbe4e , 0x3f6f , 0xbe58 , 0x3f71 , 0xbe61 , 0x3f73 , 0xbe6b , 0x3f75 , 0xbe74 , 0x3f78 , 0xbe7e , 0x3f7a , 0xbe84 , 0x3f7c , 0xbe88 , 0x3f7d , 
	0xbe4e , 0x3f6f , 0xbe58 , 0x3f71 , 0xbe61 , 0x3f73 , 0xbe6b , 0x3f75 , 0xbe74 , 0x3f78 , 0xbe7e , 0x3f7a , 0xbe84 , 0x3f7c , 0xbe88 , 0x3f7d , 
	0xbe8d , 0x3f7f , 0xbe91 , 0x3f81 , 0xbe96 , 0x3f81 , 0xbe9a , 0x3f82 , 0xbe9e , 0x3f83 , 0xbea2 , 0x3f84 , 0xbea6 , 0x3f84 , 0xbeaa , 0x3f85 , 
	0xbe8d , 0x3f7f , 0xbe91 , 0x3f81 , 0xbe96 , 0x3f81 , 0xbe9a , 0x3f82 , 0xbe9e , 0x3f83 , 0xbea2 , 0x3f84 , 0xbea6 , 0x3f84 , 0xbeaa , 0x3f85 , 
	0xbeae , 0x3f86 , 0xbeb1 , 0x3f86 , 0xbeb5 , 0x3f87 , 0xbeb8 , 0x3f87 , 0xbebb , 0x3f88 , 0xbebf , 0x3f88 , 0xbec2 , 0x3f89 , 0xbec4 , 0x3f89 , 
	0xbeae , 0x3f86 , 0xbeb1 , 0x3f86 , 0xbeb5 , 0x3f87 , 0xbeb8 , 0x3f87 , 0xbebb , 0x3f88 , 0xbebf , 0x3f88 , 0xbec2 , 0x3f89 , 0xbec4 , 0x3f89 , 
	0xbec7 , 0x3f89 , 0xbeca , 0x3f8a , 0xbecc , 0x3f8a , 0xbece , 0x3f8b , 0xbed1 , 0x3f8b , 0xbed3 , 0x3f8b , 0xbed4 , 0x3f8b , 0xbed6 , 0x3f8c , 
	0xbec7 , 0x3f89 , 0xbeca , 0x3f8a , 0xbecc , 0x3f8a , 0xbece , 0x3f8b , 0xbed1 , 0x3f8b , 0xbed3 , 0x3f8b , 0xbed4 , 0x3f8b , 0xbed6 , 0x3f8c , 
	0xbed8 , 0x3f8c , 0xbed9 , 0x3f8c , 0xbedb , 0x3f8c , 0xbedc , 0x3f8c , 0xbedd , 0x3f8c , 0xbede , 0x3f8c , 0xbedf , 0x3f8d , 0xbedf , 0x3f8d , 
	0xbed8 , 0x3f8c , 0xbed9 , 0x3f8c , 0xbedb , 0x3f8c , 0xbedc , 0x3f8c , 0xbedd , 0x3f8c , 0xbede , 0x3f8c , 0xbedf , 0x3f8d , 0xbedf , 0x3f8d , 
	0xbee0 , 0x3f8d , 0xbee0 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee0 , 0x3f8d , 
	0xbee0 , 0x3f8d , 0xbee0 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee1 , 0x3f8d , 0xbee0 , 0x3f8d , 
	0xbee0 , 0x3f8d , 0xbee0 , 0x3f8d , 0xbedf , 0x3f8d , 0xbedf , 0x3f8d , 0xbede , 0x3f8c , 0xbedd , 0x3f8c , 0xbedc , 0x3f8c , 0xbedb , 0x3f8c , 
	0xbee0 , 0x3f8d , 0xbee0 , 0x3f8d , 0xbedf , 0x3f8d , 0xbedf , 0x3f8d , 0xbede , 0x3f8c , 0xbedd , 0x3f8c , 0xbedc , 0x3f8c , 0xbedb , 0x3f8c , 
	0xbeda , 0x3f8c , 0xbed9 , 0x3f8c , 0xbed8 , 0x3f8c , 0xbed7 , 0x3f8c , 0xbed5 , 0x3f8c , 0xbed4 , 0x3f8c , 0xbed2 , 0x3f8b , 0xbed1 , 0x3f8b , 
	0xbeda , 0x3f8c , 0xbed9 , 0x3f8c , 0xbed8 , 0x3f8c , 0xbed7 , 0x3f8c , 0xbed5 , 0x3f8c , 0xbed4 , 0x3f8c , 0xbed2 , 0x3f8b , 0xbed1 , 0x3f8b , 
	0xbecf , 0x3f8b , 0xbece , 0x3f8b , 0xbecc , 0x3f8b , 0xbeca , 0x3f8b , 0xbec9 , 0x3f8b , 0xbec7 , 0x3f8b , 0xbec5 , 0x3f8a , 0xbec3 , 0x3f8a , 
	0xbecf , 0x3f8b , 0xbece , 0x3f8b , 0xbecc , 0x3f8b , 0xbeca , 0x3f8b , 0xbec9 , 0x3f8b , 0xbec7 , 0x3f8b , 0xbec5 , 0x3f8a , 0xbec3 , 0x3f8a , 
	0xbec1 , 0x3f8a , 0xbebf , 0x3f8a , 0xbebe , 0x3f8a , 0xbebc , 0x3f8a , 0xbeba , 0x3f8a , 0xbeb8 , 0x3f89 , 0xbeb6 , 0x3f89 , 0xbeb3 , 0x3f89 , 
	0xbec1 , 0x3f8a , 0xbebf , 0x3f8a , 0xbebe , 0x3f8a , 0xbebc , 0x3f8a , 0xbeba , 0x3f8a , 0xbeb8 , 0x3f89 , 0xbeb6 , 0x3f89 , 0xbeb3 , 0x3f89 , 
	0xbeb1 , 0x3f89 , 0xbeaf , 0x3f89 , 0xbead , 0x3f89 , 0xbeab , 0x3f88 , 0xbea9 , 0x3f88 , 0xbea7 , 0x3f88 , 0xbea5 , 0x3f88 , 0xbea3 , 0x3f88 , 
	0xbeb1 , 0x3f89 , 0xbeaf , 0x3f89 , 0xbead , 0x3f89 , 0xbeab , 0x3f88 , 0xbea9 , 0x3f88 , 0xbea7 , 0x3f88 , 0xbea5 , 0x3f88 , 0xbea3 , 0x3f88 , 
	0xbea1 , 0x3f88 , 0xbe9e , 0x3f88 , 0xbe9c , 0x3f87 , 0xbe9a , 0x3f87 , 0xbe98 , 0x3f87 , 0xbe96 , 0x3f87 , 0xbe94 , 0x3f87 , 0xbe92 , 0x3f87 , 
	0xbea1 , 0x3f88 , 0xbe9e , 0x3f88 , 0xbe9c , 0x3f87 , 0xbe9a , 0x3f87 , 0xbe98 , 0x3f87 , 0xbe96 , 0x3f87 , 0xbe94 , 0x3f87 , 0xbe92 , 0x3f87 , 
	0xbe90 , 0x3f87 , 0xbe8e , 0x3f87 , 0xbe8b , 0x3f86 , 0xbe89 , 0x3f86 , 0xbe87 , 0x3f86 , 0xbe85 , 0x3f86 , 0xbe83 , 0x3f86 , 0xbe81 , 0x3f86 , 
	0xbe90 , 0x3f87 , 0xbe8e , 0x3f87 , 0xbe8b , 0x3f86 , 0xbe89 , 0x3f86 , 0xbe87 , 0x3f86 , 0xbe85 , 0x3f86 , 0xbe83 , 0x3f86 , 0xbe81 , 0x3f86 , 
	0xbe7e , 0x3f86 , 0xbe7a , 0x3f86 , 0xbe77 , 0x3f85 , 0xbe73 , 0x3f85 , 0xbe6f , 0x3f85 , 0xbe6b , 0x3f85 , 0xbe67 , 0x3f85 , 0xbe63 , 0x3f85 , 
	0xbe7e , 0x3f86 , 0xbe7a , 0x3f86 , 0xbe77 , 0x3f85 , 0xbe73 , 0x3f85 , 0xbe6f , 0x3f85 , 0xbe6b , 0x3f85 , 0xbe67 , 0x3f85 , 0xbe63 , 0x3f85 , 
	0xbe5f , 0x3f85 , 0xbe5c , 0x3f85 , 0xbe58 , 0x3f85 , 0xbe54 , 0x3f84 , 0xbe51 , 0x3f84 , 0xbe4d , 0x3f84 , 0xbe4a , 0x3f84 , 0xbe46 , 0x3f84 , 
	0xbe5f , 0x3f85 , 0xbe5c , 0x3f85 , 0xbe58 , 0x3f85 , 0xbe54 , 0x3f84 , 0xbe51 , 0x3f84 , 0xbe4d , 0x3f84 , 0xbe4a , 0x3f84 , 0xbe46 , 0x3f84 , 
	0xbe43 , 0x3f84 , 0xbe3f , 0x3f84 , 0xbe3c , 0x3f84 , 0xbe39 , 0x3f84 , 0xbe35 , 0x3f84 , 0xbe32 , 0x3f84 , 0xbe2f , 0x3f84 , 0x0000 , 0x3f80 , 
	0xbe43 , 0x3f84 , 0xbe3f , 0x3f84 , 0xbe3c , 0x3f84 , 0xbe39 , 0x3f84 , 0xbe35 , 0x3f84 , 0xbe32 , 0x3f84 , 0xbe2f , 0x3f84 , 0x0000 , 0x3f80
	};
}

#endif //SILU_LUT_BF16_512_H

