#ifndef SIGMOID_LUT_INT16_512_H
#define SIGMOID_LUT_INT16_512_H

namespace silu_int16 {
#define NLF_LUT_SHIFT 5

const int lut_sz = 160*2;
const int lut_frac_bits = 15;
static const int16_t lnr_lutab[lut_sz*2*2]={
    0,     0,   226,   228,   233,   235,   240,   242,   248,   250,   256,   258,   264,   266,   272,   274,
    0,     0,   226,   228,   233,   235,   240,   242,   248,   250,   256,   258,   264,   266,   272,   274,
  281,   282,   289,   291,   299,   300,   308,   310,   318,   319,   328,   329,   338,   340,   349,   350,
  281,   282,   289,   291,   299,   300,   308,   310,   318,   319,   328,   329,   338,   340,   349,   350,
  360,   361,   371,   372,   382,   384,   394,   396,   407,   408,   420,   421,   433,   434,   446,   447,
  360,   361,   371,   372,   382,   384,   394,   396,   407,   408,   420,   421,   433,   434,   446,   447,
  460,   461,   475,   475,   490,   490,   505,   505,   521,   520,   537,   536,   554,   553,   571,   570,
  460,   461,   475,   475,   490,   490,   505,   505,   521,   520,   537,   536,   554,   553,   571,   570,
  589,   587,   607,   605,   626,   623,   646,   643,   666,   662,   686,   682,   708,   703,   730,   724,
  589,   587,   607,   605,   626,   623,   646,   643,   666,   662,   686,   682,   708,   703,   730,   724,
  752,   746,   776,   769,   800,   792,   825,   816,   850,   840,   876,   866,   903,   892,   931,   918,
  752,   746,   776,   769,   800,   792,   825,   816,   850,   840,   876,   866,   903,   892,   931,   918,
  960,   946,   990,   974,  1020,  1003,  1051,  1033,  1084,  1063,  1117,  1095,  1151,  1127,  1186,  1160,
  960,   946,   990,   974,  1020,  1003,  1051,  1033,  1084,  1063,  1117,  1095,  1151,  1127,  1186,  1160,
 1223,  1194,  1260,  1229,  1298,  1265,  1338,  1302,  1379,  1340,  1421,  1378,  1464,  1418,  1508,  1459,
 1223,  1194,  1260,  1229,  1298,  1265,  1338,  1302,  1379,  1340,  1421,  1378,  1464,  1418,  1508,  1459,
 1554,  1501,  1600,  1544,  1649,  1588,  1698,  1633,  1749,  1679,  1802,  1727,  1856,  1775,  1911,  1825,
 1554,  1501,  1600,  1544,  1649,  1588,  1698,  1633,  1749,  1679,  1802,  1727,  1856,  1775,  1911,  1825,
 1968,  1876,  2027,  1928,  2087,  1981,  2149,  2036,  2213,  2091,  2278,  2149,  2345,  2207,  2414,  2266,
 1968,  1876,  2027,  1928,  2087,  1981,  2149,  2036,  2213,  2091,  2278,  2149,  2345,  2207,  2414,  2266,
 2485,  2327,  2558,  2390,  2633,  2453,  2709,  2518,  2788,  2584,  2869,  2652,  2952,  2720,  3037,  2790,
 2485,  2327,  2558,  2390,  2633,  2453,  2709,  2518,  2788,  2584,  2869,  2652,  2952,  2720,  3037,  2790,
 3124,  2862,  3213,  2935,  3305,  3009,  3399,  3084,  3496,  3161,  3594,  3239,  3696,  3319,  3799,  3399,
 3124,  2862,  3213,  2935,  3305,  3009,  3399,  3084,  3496,  3161,  3594,  3239,  3696,  3319,  3799,  3399,
 3906,  3481,  4014,  3564,  4126,  3649,  4240,  3734,  4356,  3821,  4476,  3908,  4598,  3997,  4723,  4087,
 3906,  3481,  4014,  3564,  4126,  3649,  4240,  3734,  4356,  3821,  4476,  3908,  4598,  3997,  4723,  4087,
 4851,  4178,  4981,  4270,  5115,  4363,  5251,  4456,  5390,  4551,  5533,  4646,  5678,  4742,  5826,  4838,
 4851,  4178,  4981,  4270,  5115,  4363,  5251,  4456,  5390,  4551,  5533,  4646,  5678,  4742,  5826,  4838,
 5977,  4935,  6131,  5033,  6289,  5131,  6449,  5229,  6613,  5327,  6779,  5426,  6949,  5524,  7121,  5623,
 5977,  4935,  6131,  5033,  6289,  5131,  6449,  5229,  6613,  5327,  6779,  5426,  6949,  5524,  7121,  5623,
 7297,  5721,  7476,  5819,  7658,  5917,  7842,  6014,  8030,  6110,  8221,  6206,  8415,  6301,  8612,  6395,
 7297,  5721,  7476,  5819,  7658,  5917,  7842,  6014,  8030,  6110,  8221,  6206,  8415,  6301,  8612,  6395,
 8812,  6488,  9015,  6580,  9221,  6671,  9429,  6760,  9640,  6847,  9854,  6933, 10071,  7017, 10290,  7099,
 8812,  6488,  9015,  6580,  9221,  6671,  9429,  6760,  9640,  6847,  9854,  6933, 10071,  7017, 10290,  7099,
10512,  7179, 10737,  7257, 10963,  7332, 11192,  7405, 11424,  7476, 11658,  7543, 11893,  7608, 12131,  7670,
10512,  7179, 10737,  7257, 10963,  7332, 11192,  7405, 11424,  7476, 11658,  7543, 11893,  7608, 12131,  7670,
12371,  7729, 12612,  7785, 12856,  7837, 13101,  7887, 13347,  7932, 13595,  7975, 13844,  8013, 14095,  8049,
12371,  7729, 12612,  7785, 12856,  7837, 13101,  7887, 13347,  7932, 13595,  7975, 13844,  8013, 14095,  8049,
14346,  8080, 14599,  8107, 14852,  8131, 15106,  8151, 15361,  8167, 15616,  8179, 15872,  8187, 16128,  8191,
14346,  8080, 14599,  8107, 14852,  8131, 15106,  8151, 15361,  8167, 15616,  8179, 15872,  8187, 16128,  8191,
16384,  8191, 16639,  8187, 16895,  8179, 17151,  8167, 17406,  8151, 17661,  8131, 17915,  8107, 18168,  8080,
16384,  8191, 16639,  8187, 16895,  8179, 17151,  8167, 17406,  8151, 17661,  8131, 17915,  8107, 18168,  8080,
18421,  8049, 18672,  8013, 18923,  7975, 19172,  7932, 19420,  7887, 19666,  7837, 19911,  7785, 20155,  7729,
18421,  8049, 18672,  8013, 18923,  7975, 19172,  7932, 19420,  7887, 19666,  7837, 19911,  7785, 20155,  7729,
20396,  7670, 20636,  7608, 20874,  7543, 21109,  7476, 21343,  7405, 21575,  7332, 21804,  7257, 22030,  7179,
20396,  7670, 20636,  7608, 20874,  7543, 21109,  7476, 21343,  7405, 21575,  7332, 21804,  7257, 22030,  7179,
22255,  7099, 22477,  7017, 22696,  6933, 22913,  6847, 23127,  6760, 23338,  6671, 23546,  6580, 23752,  6488,
22255,  7099, 22477,  7017, 22696,  6933, 22913,  6847, 23127,  6760, 23338,  6671, 23546,  6580, 23752,  6488,
23955,  6395, 24155,  6301, 24352,  6206, 24546,  6110, 24737,  6014, 24925,  5917, 25109,  5819, 25291,  5721,
23955,  6395, 24155,  6301, 24352,  6206, 24546,  6110, 24737,  6014, 24925,  5917, 25109,  5819, 25291,  5721,
25470,  5623, 25646,  5524, 25818,  5426, 25988,  5327, 26154,  5229, 26318,  5131, 26478,  5033, 26636,  4935,
25470,  5623, 25646,  5524, 25818,  5426, 25988,  5327, 26154,  5229, 26318,  5131, 26478,  5033, 26636,  4935,
26790,  4838, 26941,  4742, 27089,  4646, 27234,  4551, 27377,  4456, 27516,  4363, 27652,  4270, 27786,  4178,
26790,  4838, 26941,  4742, 27089,  4646, 27234,  4551, 27377,  4456, 27516,  4363, 27652,  4270, 27786,  4178,
27916,  4087, 28044,  3997, 28169,  3908, 28291,  3821, 28411,  3734, 28527,  3649, 28641,  3564, 28753,  3481,
27916,  4087, 28044,  3997, 28169,  3908, 28291,  3821, 28411,  3734, 28527,  3649, 28641,  3564, 28753,  3481,
28861,  3399, 28968,  3319, 29071,  3239, 29173,  3161, 29271,  3084, 29368,  3009, 29462,  2935, 29554,  2862,
28861,  3399, 28968,  3319, 29071,  3239, 29173,  3161, 29271,  3084, 29368,  3009, 29462,  2935, 29554,  2862,
29643,  2790, 29730,  2720, 29815,  2652, 29898,  2584, 29979,  2518, 30058,  2453, 30134,  2390, 30209,  2327,
29643,  2790, 29730,  2720, 29815,  2652, 29898,  2584, 29979,  2518, 30058,  2453, 30134,  2390, 30209,  2327,
30282,  2266, 30353,  2207, 30422,  2149, 30489,  2091, 30554,  2036, 30618,  1981, 30680,  1928, 30740,  1876,
30282,  2266, 30353,  2207, 30422,  2149, 30489,  2091, 30554,  2036, 30618,  1981, 30680,  1928, 30740,  1876,
30799,  1825, 30856,  1775, 30911,  1727, 30965,  1679, 31018,  1633, 31069,  1588, 31118,  1544, 31167,  1501,
30799,  1825, 30856,  1775, 30911,  1727, 30965,  1679, 31018,  1633, 31069,  1588, 31118,  1544, 31167,  1501,
31213,  1459, 31259,  1418, 31303,  1378, 31346,  1340, 31388,  1302, 31429,  1265, 31469,  1229, 31507,  1194,
31213,  1459, 31259,  1418, 31303,  1378, 31346,  1340, 31388,  1302, 31429,  1265, 31469,  1229, 31507,  1194,
31544,  1160, 31581,  1127, 31616,  1095, 31650,  1063, 31683,  1033, 31716,  1003, 31747,   974, 31777,   946,
31544,  1160, 31581,  1127, 31616,  1095, 31650,  1063, 31683,  1033, 31716,  1003, 31747,   974, 31777,   946,
31807,   918, 31836,   892, 31864,   866, 31891,   840, 31917,   816, 31942,   792, 31967,   769, 31991,   746,
31807,   918, 31836,   892, 31864,   866, 31891,   840, 31917,   816, 31942,   792, 31967,   769, 31991,   746,
32015,   724, 32037,   703, 32059,   682, 32081,   662, 32101,   643, 32121,   623, 32141,   605, 32160,   587,
32015,   724, 32037,   703, 32059,   682, 32081,   662, 32101,   643, 32121,   623, 32141,   605, 32160,   587,
32178,   570, 32196,   553, 32213,   536, 32230,   520, 32246,   505, 32262,   490, 32277,   475, 32292,   461,
32178,   570, 32196,   553, 32213,   536, 32230,   520, 32246,   505, 32262,   490, 32277,   475, 32292,   461,
32307,   447, 32321,   434, 32334,   421, 32347,   408, 32360,   396, 32373,   384, 32385,   372, 32396,   361,
32307,   447, 32321,   434, 32334,   421, 32347,   408, 32360,   396, 32373,   384, 32385,   372, 32396,   361,
32407,   350, 32418,   340, 32429,   329, 32439,   319, 32449,   310, 32459,   300, 32468,   291, 32478,   282,
32407,   350, 32418,   340, 32429,   329, 32439,   319, 32449,   310, 32459,   300, 32468,   291, 32478,   282,
32486,   274, 32495,   266, 32503,   258, 32511,   250, 32519,   242, 32527,   235, 32534,   228, 32767,   0,
32486,   274, 32495,   266, 32503,   258, 32511,   250, 32519,   242, 32527,   235, 32534,   228, 32767,   0
};

static const int16_t lnr_lutcd[lut_sz*2*2]={                                   
    0,     0,   226,   228,   233,   235,   240,   242,   248,   250,   256,   258,   264,   266,   272,   274,
    0,     0,   226,   228,   233,   235,   240,   242,   248,   250,   256,   258,   264,   266,   272,   274,
  281,   282,   289,   291,   299,   300,   308,   310,   318,   319,   328,   329,   338,   340,   349,   350,
  281,   282,   289,   291,   299,   300,   308,   310,   318,   319,   328,   329,   338,   340,   349,   350,
  360,   361,   371,   372,   382,   384,   394,   396,   407,   408,   420,   421,   433,   434,   446,   447,
  360,   361,   371,   372,   382,   384,   394,   396,   407,   408,   420,   421,   433,   434,   446,   447,
  460,   461,   475,   475,   490,   490,   505,   505,   521,   520,   537,   536,   554,   553,   571,   570,
  460,   461,   475,   475,   490,   490,   505,   505,   521,   520,   537,   536,   554,   553,   571,   570,
  589,   587,   607,   605,   626,   623,   646,   643,   666,   662,   686,   682,   708,   703,   730,   724,
  589,   587,   607,   605,   626,   623,   646,   643,   666,   662,   686,   682,   708,   703,   730,   724,
  752,   746,   776,   769,   800,   792,   825,   816,   850,   840,   876,   866,   903,   892,   931,   918,
  752,   746,   776,   769,   800,   792,   825,   816,   850,   840,   876,   866,   903,   892,   931,   918,
  960,   946,   990,   974,  1020,  1003,  1051,  1033,  1084,  1063,  1117,  1095,  1151,  1127,  1186,  1160,
  960,   946,   990,   974,  1020,  1003,  1051,  1033,  1084,  1063,  1117,  1095,  1151,  1127,  1186,  1160,
 1223,  1194,  1260,  1229,  1298,  1265,  1338,  1302,  1379,  1340,  1421,  1378,  1464,  1418,  1508,  1459,
 1223,  1194,  1260,  1229,  1298,  1265,  1338,  1302,  1379,  1340,  1421,  1378,  1464,  1418,  1508,  1459,
 1554,  1501,  1600,  1544,  1649,  1588,  1698,  1633,  1749,  1679,  1802,  1727,  1856,  1775,  1911,  1825,
 1554,  1501,  1600,  1544,  1649,  1588,  1698,  1633,  1749,  1679,  1802,  1727,  1856,  1775,  1911,  1825,
 1968,  1876,  2027,  1928,  2087,  1981,  2149,  2036,  2213,  2091,  2278,  2149,  2345,  2207,  2414,  2266,
 1968,  1876,  2027,  1928,  2087,  1981,  2149,  2036,  2213,  2091,  2278,  2149,  2345,  2207,  2414,  2266,
 2485,  2327,  2558,  2390,  2633,  2453,  2709,  2518,  2788,  2584,  2869,  2652,  2952,  2720,  3037,  2790,
 2485,  2327,  2558,  2390,  2633,  2453,  2709,  2518,  2788,  2584,  2869,  2652,  2952,  2720,  3037,  2790,
 3124,  2862,  3213,  2935,  3305,  3009,  3399,  3084,  3496,  3161,  3594,  3239,  3696,  3319,  3799,  3399,
 3124,  2862,  3213,  2935,  3305,  3009,  3399,  3084,  3496,  3161,  3594,  3239,  3696,  3319,  3799,  3399,
 3906,  3481,  4014,  3564,  4126,  3649,  4240,  3734,  4356,  3821,  4476,  3908,  4598,  3997,  4723,  4087,
 3906,  3481,  4014,  3564,  4126,  3649,  4240,  3734,  4356,  3821,  4476,  3908,  4598,  3997,  4723,  4087,
 4851,  4178,  4981,  4270,  5115,  4363,  5251,  4456,  5390,  4551,  5533,  4646,  5678,  4742,  5826,  4838,
 4851,  4178,  4981,  4270,  5115,  4363,  5251,  4456,  5390,  4551,  5533,  4646,  5678,  4742,  5826,  4838,
 5977,  4935,  6131,  5033,  6289,  5131,  6449,  5229,  6613,  5327,  6779,  5426,  6949,  5524,  7121,  5623,
 5977,  4935,  6131,  5033,  6289,  5131,  6449,  5229,  6613,  5327,  6779,  5426,  6949,  5524,  7121,  5623,
 7297,  5721,  7476,  5819,  7658,  5917,  7842,  6014,  8030,  6110,  8221,  6206,  8415,  6301,  8612,  6395,
 7297,  5721,  7476,  5819,  7658,  5917,  7842,  6014,  8030,  6110,  8221,  6206,  8415,  6301,  8612,  6395,
 8812,  6488,  9015,  6580,  9221,  6671,  9429,  6760,  9640,  6847,  9854,  6933, 10071,  7017, 10290,  7099,
 8812,  6488,  9015,  6580,  9221,  6671,  9429,  6760,  9640,  6847,  9854,  6933, 10071,  7017, 10290,  7099,
10512,  7179, 10737,  7257, 10963,  7332, 11192,  7405, 11424,  7476, 11658,  7543, 11893,  7608, 12131,  7670,
10512,  7179, 10737,  7257, 10963,  7332, 11192,  7405, 11424,  7476, 11658,  7543, 11893,  7608, 12131,  7670,
12371,  7729, 12612,  7785, 12856,  7837, 13101,  7887, 13347,  7932, 13595,  7975, 13844,  8013, 14095,  8049,
12371,  7729, 12612,  7785, 12856,  7837, 13101,  7887, 13347,  7932, 13595,  7975, 13844,  8013, 14095,  8049,
14346,  8080, 14599,  8107, 14852,  8131, 15106,  8151, 15361,  8167, 15616,  8179, 15872,  8187, 16128,  8191,
14346,  8080, 14599,  8107, 14852,  8131, 15106,  8151, 15361,  8167, 15616,  8179, 15872,  8187, 16128,  8191,
16384,  8191, 16639,  8187, 16895,  8179, 17151,  8167, 17406,  8151, 17661,  8131, 17915,  8107, 18168,  8080,
16384,  8191, 16639,  8187, 16895,  8179, 17151,  8167, 17406,  8151, 17661,  8131, 17915,  8107, 18168,  8080,
18421,  8049, 18672,  8013, 18923,  7975, 19172,  7932, 19420,  7887, 19666,  7837, 19911,  7785, 20155,  7729,
18421,  8049, 18672,  8013, 18923,  7975, 19172,  7932, 19420,  7887, 19666,  7837, 19911,  7785, 20155,  7729,
20396,  7670, 20636,  7608, 20874,  7543, 21109,  7476, 21343,  7405, 21575,  7332, 21804,  7257, 22030,  7179,
20396,  7670, 20636,  7608, 20874,  7543, 21109,  7476, 21343,  7405, 21575,  7332, 21804,  7257, 22030,  7179,
22255,  7099, 22477,  7017, 22696,  6933, 22913,  6847, 23127,  6760, 23338,  6671, 23546,  6580, 23752,  6488,
22255,  7099, 22477,  7017, 22696,  6933, 22913,  6847, 23127,  6760, 23338,  6671, 23546,  6580, 23752,  6488,
23955,  6395, 24155,  6301, 24352,  6206, 24546,  6110, 24737,  6014, 24925,  5917, 25109,  5819, 25291,  5721,
23955,  6395, 24155,  6301, 24352,  6206, 24546,  6110, 24737,  6014, 24925,  5917, 25109,  5819, 25291,  5721,
25470,  5623, 25646,  5524, 25818,  5426, 25988,  5327, 26154,  5229, 26318,  5131, 26478,  5033, 26636,  4935,
25470,  5623, 25646,  5524, 25818,  5426, 25988,  5327, 26154,  5229, 26318,  5131, 26478,  5033, 26636,  4935,
26790,  4838, 26941,  4742, 27089,  4646, 27234,  4551, 27377,  4456, 27516,  4363, 27652,  4270, 27786,  4178,
26790,  4838, 26941,  4742, 27089,  4646, 27234,  4551, 27377,  4456, 27516,  4363, 27652,  4270, 27786,  4178,
27916,  4087, 28044,  3997, 28169,  3908, 28291,  3821, 28411,  3734, 28527,  3649, 28641,  3564, 28753,  3481,
27916,  4087, 28044,  3997, 28169,  3908, 28291,  3821, 28411,  3734, 28527,  3649, 28641,  3564, 28753,  3481,
28861,  3399, 28968,  3319, 29071,  3239, 29173,  3161, 29271,  3084, 29368,  3009, 29462,  2935, 29554,  2862,
28861,  3399, 28968,  3319, 29071,  3239, 29173,  3161, 29271,  3084, 29368,  3009, 29462,  2935, 29554,  2862,
29643,  2790, 29730,  2720, 29815,  2652, 29898,  2584, 29979,  2518, 30058,  2453, 30134,  2390, 30209,  2327,
29643,  2790, 29730,  2720, 29815,  2652, 29898,  2584, 29979,  2518, 30058,  2453, 30134,  2390, 30209,  2327,
30282,  2266, 30353,  2207, 30422,  2149, 30489,  2091, 30554,  2036, 30618,  1981, 30680,  1928, 30740,  1876,
30282,  2266, 30353,  2207, 30422,  2149, 30489,  2091, 30554,  2036, 30618,  1981, 30680,  1928, 30740,  1876,
30799,  1825, 30856,  1775, 30911,  1727, 30965,  1679, 31018,  1633, 31069,  1588, 31118,  1544, 31167,  1501,
30799,  1825, 30856,  1775, 30911,  1727, 30965,  1679, 31018,  1633, 31069,  1588, 31118,  1544, 31167,  1501,
31213,  1459, 31259,  1418, 31303,  1378, 31346,  1340, 31388,  1302, 31429,  1265, 31469,  1229, 31507,  1194,
31213,  1459, 31259,  1418, 31303,  1378, 31346,  1340, 31388,  1302, 31429,  1265, 31469,  1229, 31507,  1194,
31544,  1160, 31581,  1127, 31616,  1095, 31650,  1063, 31683,  1033, 31716,  1003, 31747,   974, 31777,   946,
31544,  1160, 31581,  1127, 31616,  1095, 31650,  1063, 31683,  1033, 31716,  1003, 31747,   974, 31777,   946,
31807,   918, 31836,   892, 31864,   866, 31891,   840, 31917,   816, 31942,   792, 31967,   769, 31991,   746,
31807,   918, 31836,   892, 31864,   866, 31891,   840, 31917,   816, 31942,   792, 31967,   769, 31991,   746,
32015,   724, 32037,   703, 32059,   682, 32081,   662, 32101,   643, 32121,   623, 32141,   605, 32160,   587,
32015,   724, 32037,   703, 32059,   682, 32081,   662, 32101,   643, 32121,   623, 32141,   605, 32160,   587,
32178,   570, 32196,   553, 32213,   536, 32230,   520, 32246,   505, 32262,   490, 32277,   475, 32292,   461,
32178,   570, 32196,   553, 32213,   536, 32230,   520, 32246,   505, 32262,   490, 32277,   475, 32292,   461,
32307,   447, 32321,   434, 32334,   421, 32347,   408, 32360,   396, 32373,   384, 32385,   372, 32396,   361,
32307,   447, 32321,   434, 32334,   421, 32347,   408, 32360,   396, 32373,   384, 32385,   372, 32396,   361,
32407,   350, 32418,   340, 32429,   329, 32439,   319, 32449,   310, 32459,   300, 32468,   291, 32478,   282,
32407,   350, 32418,   340, 32429,   329, 32439,   319, 32449,   310, 32459,   300, 32468,   291, 32478,   282,
32486,   274, 32495,   266, 32503,   258, 32511,   250, 32519,   242, 32527,   235, 32534,   228, 32767,   0,
32486,   274, 32495,   266, 32503,   258, 32511,   250, 32519,   242, 32527,   235, 32534,   228, 32767,   0
};
}

#endif //SIGMOID_LUT_INT16_512_H
