#ifndef TANH_LUT_BF16_512_H
#define TANH_LUT_BF16_512_H

namespace tanh_bf16 {
	const int lut_sz = 160*2;
	static const uint16_t lnr_lutab[lut_sz*2*2]={
    0xbf7f, 0x3944, 0xbf7f, 0x3951, 0xbf7f, 0x395e, 0xbf7f, 0x396c, 0xbf7f, 0x397c, 0xbf7f, 0x3986, 0xbf7f, 0x398e, 0xbf7f, 0x3998,
    0xbf7f, 0x3944, 0xbf7f, 0x3951, 0xbf7f, 0x395e, 0xbf7f, 0x396c, 0xbf7f, 0x397c, 0xbf7f, 0x3986, 0xbf7f, 0x398e, 0xbf7f, 0x3998,
    0xbf7f, 0x39a1, 0xbf7f, 0x39ac, 0xbf7f, 0x39b7, 0xbf7f, 0x39c3, 0xbf7f, 0x39cf, 0xbf7f, 0x39dd, 0xbf7f, 0x39eb, 0xbf7f, 0x39fa,
    0xbf7f, 0x39a1, 0xbf7f, 0x39ac, 0xbf7f, 0x39b7, 0xbf7f, 0x39c3, 0xbf7f, 0x39cf, 0xbf7f, 0x39dd, 0xbf7f, 0x39eb, 0xbf7f, 0x39fa,
    0xbf7f, 0x3a05, 0xbf7f, 0x3a0e, 0xbf7f, 0x3a17, 0xbf7f, 0x3a21, 0xbf7f, 0x3a2b, 0xbf7f, 0x3a36, 0xbf7f, 0x3a42, 0xbf7f, 0x3a4e,
    0xbf7f, 0x3a05, 0xbf7f, 0x3a0e, 0xbf7f, 0x3a17, 0xbf7f, 0x3a21, 0xbf7f, 0x3a2b, 0xbf7f, 0x3a36, 0xbf7f, 0x3a42, 0xbf7f, 0x3a4e,
    0xbf7e, 0x3a5c, 0xbf7e, 0x3a6a, 0xbf7e, 0x3a79, 0xbf7e, 0x3a84, 0xbf7e, 0x3a8d, 0xbf7e, 0x3a96, 0xbf7e, 0x3aa0, 0xbf7e, 0x3aaa,
    0xbf7e, 0x3a5c, 0xbf7e, 0x3a6a, 0xbf7e, 0x3a79, 0xbf7e, 0x3a84, 0xbf7e, 0x3a8d, 0xbf7e, 0x3a96, 0xbf7e, 0x3aa0, 0xbf7e, 0x3aaa,
    0xbf7e, 0x3ab5, 0xbf7e, 0x3ac1, 0xbf7e, 0x3acd, 0xbf7e, 0x3ada, 0xbf7e, 0x3ae8, 0xbf7d, 0x3af7, 0xbf7d, 0x3b03, 0xbf7d, 0x3b0c,
    0xbf7e, 0x3ab5, 0xbf7e, 0x3ac1, 0xbf7e, 0x3acd, 0xbf7e, 0x3ada, 0xbf7e, 0x3ae8, 0xbf7d, 0x3af7, 0xbf7d, 0x3b03, 0xbf7d, 0x3b0c,
    0xbf7d, 0x3b15, 0xbf7d, 0x3b1f, 0xbf7d, 0x3b29, 0xbf7d, 0x3b34, 0xbf7c, 0x3b3f, 0xbf7c, 0x3b4c, 0xbf7c, 0x3b59, 0xbf7c, 0x3b67,
    0xbf7d, 0x3b15, 0xbf7d, 0x3b1f, 0xbf7d, 0x3b29, 0xbf7d, 0x3b34, 0xbf7c, 0x3b3f, 0xbf7c, 0x3b4c, 0xbf7c, 0x3b59, 0xbf7c, 0x3b67,
    0xbf7c, 0x3b76, 0xbf7b, 0x3b83, 0xbf7b, 0x3b8b, 0xbf7b, 0x3b94, 0xbf7b, 0x3b9d, 0xbf7a, 0x3ba8, 0xbf7a, 0x3bb2, 0xbf7a, 0x3bbe,
    0xbf7c, 0x3b76, 0xbf7b, 0x3b83, 0xbf7b, 0x3b8b, 0xbf7b, 0x3b94, 0xbf7b, 0x3b9d, 0xbf7a, 0x3ba8, 0xbf7a, 0x3bb2, 0xbf7a, 0x3bbe,
    0xbf7a, 0x3bca, 0xbf79, 0x3bd7, 0xbf79, 0x3be5, 0xbf79, 0x3bf4, 0xbf78, 0x3c02, 0xbf78, 0x3c0a, 0xbf77, 0x3c13, 0xbf77, 0x3c1c,
    0xbf7a, 0x3bca, 0xbf79, 0x3bd7, 0xbf79, 0x3be5, 0xbf79, 0x3bf4, 0xbf78, 0x3c02, 0xbf78, 0x3c0a, 0xbf77, 0x3c13, 0xbf77, 0x3c1c,
    0xbf76, 0x3c26, 0xbf76, 0x3c31, 0xbf75, 0x3c3c, 0xbf75, 0x3c48, 0xbf74, 0x3c55, 0xbf74, 0x3c63, 0xbf73, 0x3c72, 0xbf72, 0x3c80,
    0xbf76, 0x3c26, 0xbf76, 0x3c31, 0xbf75, 0x3c3c, 0xbf75, 0x3c48, 0xbf74, 0x3c55, 0xbf74, 0x3c63, 0xbf73, 0x3c72, 0xbf72, 0x3c80,
    0xbf72, 0x3c89, 0xbf71, 0x3c91, 0xbf70, 0x3c9b, 0xbf6f, 0x3ca5, 0xbf6e, 0x3caf, 0xbf6e, 0x3cba, 0xbf6d, 0x3cc6, 0xbf6c, 0x3cd3,
    0xbf72, 0x3c89, 0xbf71, 0x3c91, 0xbf70, 0x3c9b, 0xbf6f, 0x3ca5, 0xbf6e, 0x3caf, 0xbf6e, 0x3cba, 0xbf6d, 0x3cc6, 0xbf6c, 0x3cd3,
    0xbf6b, 0x3ce0, 0xbf69, 0x3cee, 0xbf68, 0x3cfe, 0xbf67, 0x3d07, 0xbf66, 0x3d0f, 0xbf64, 0x3d18, 0xbf63, 0x3d22, 0xbf62, 0x3d2c,
    0xbf6b, 0x3ce0, 0xbf69, 0x3cee, 0xbf68, 0x3cfe, 0xbf67, 0x3d07, 0xbf66, 0x3d0f, 0xbf64, 0x3d18, 0xbf63, 0x3d22, 0xbf62, 0x3d2c,
    0xbf60, 0x3d37, 0xbf5e, 0x3d43, 0xbf5d, 0x3d4f, 0xbf5b, 0x3d5c, 0xbf59, 0x3d6a, 0xbf57, 0x3d78, 0xbf55, 0x3d84, 0xbf53, 0x3d8c,
    0xbf60, 0x3d37, 0xbf5e, 0x3d43, 0xbf5d, 0x3d4f, 0xbf5b, 0x3d5c, 0xbf59, 0x3d6a, 0xbf57, 0x3d78, 0xbf55, 0x3d84, 0xbf53, 0x3d8c,
    0xbf51, 0x3d95, 0xbf4f, 0x3d9e, 0xbf4c, 0x3da8, 0xbf4a, 0x3db2, 0xbf47, 0x3dbd, 0xbf45, 0x3dc9, 0xbf42, 0x3dd5, 0xbf3f, 0x3de2,
    0xbf51, 0x3d95, 0xbf4f, 0x3d9e, 0xbf4c, 0x3da8, 0xbf4a, 0x3db2, 0xbf47, 0x3dbd, 0xbf45, 0x3dc9, 0xbf42, 0x3dd5, 0xbf3f, 0x3de2,
    0xbf3c, 0x3df0, 0xbf39, 0x3dfe, 0xbf36, 0x3e06, 0xbf32, 0x3e0f, 0xbf2f, 0x3e17, 0xbf2b, 0x3e20, 0xbf28, 0x3e29, 0xbf24, 0x3e33,
    0xbf3c, 0x3df0, 0xbf39, 0x3dfe, 0xbf36, 0x3e06, 0xbf32, 0x3e0f, 0xbf2f, 0x3e17, 0xbf2b, 0x3e20, 0xbf28, 0x3e29, 0xbf24, 0x3e33,
    0xbf20, 0x3e3e, 0xbf1c, 0x3e49, 0xbf18, 0x3e54, 0xbf13, 0x3e61, 0xbf0f, 0x3e6d, 0xbf0b, 0x3e7b, 0xbf06, 0x3e84, 0xbf01, 0x3e8b,
    0xbf20, 0x3e3e, 0xbf1c, 0x3e49, 0xbf18, 0x3e54, 0xbf13, 0x3e61, 0xbf0f, 0x3e6d, 0xbf0b, 0x3e7b, 0xbf06, 0x3e84, 0xbf01, 0x3e8b,
    0xbefa, 0x3e93, 0xbef0, 0x3e9b, 0xbee6, 0x3ea3, 0xbedc, 0x3eac, 0xbed2, 0x3eb5, 0xbec8, 0x3ebe, 0xbebe, 0x3ec8, 0xbeb3, 0x3ed1,
    0xbefa, 0x3e93, 0xbef0, 0x3e9b, 0xbee6, 0x3ea3, 0xbedc, 0x3eac, 0xbed2, 0x3eb5, 0xbec8, 0x3ebe, 0xbebe, 0x3ec8, 0xbeb3, 0x3ed1,
    0xbea9, 0x3edc, 0xbe9f, 0x3ee6, 0xbe95, 0x3ef1, 0xbe8b, 0x3efc, 0xbe81, 0x3f04, 0xbe6f, 0x3f09, 0xbe5b, 0x3f0f, 0xbe49, 0x3f15,
    0xbea9, 0x3edc, 0xbe9f, 0x3ee6, 0xbe95, 0x3ef1, 0xbe8b, 0x3efc, 0xbe81, 0x3f04, 0xbe6f, 0x3f09, 0xbe5b, 0x3f0f, 0xbe49, 0x3f15,
    0xbe37, 0x3f1b, 0xbe25, 0x3f21, 0xbe14, 0x3f28, 0xbe04, 0x3f2e, 0xbdea, 0x3f34, 0xbdcd, 0x3f3a, 0xbdb2, 0x3f40, 0xbd98, 0x3f46,
    0xbe37, 0x3f1b, 0xbe25, 0x3f21, 0xbe14, 0x3f28, 0xbe04, 0x3f2e, 0xbdea, 0x3f34, 0xbdcd, 0x3f3a, 0xbdb2, 0x3f40, 0xbd98, 0x3f46,
    0xbd81, 0x3f4c, 0xbd58, 0x3f51, 0xbd32, 0x3f57, 0xbd10, 0x3f5c, 0xbce4, 0x3f61, 0xbcb0, 0x3f66, 0xbc84, 0x3f6a, 0xbc40, 0x3f6e,
    0xbd81, 0x3f4c, 0xbd58, 0x3f51, 0xbd32, 0x3f57, 0xbd10, 0x3f5c, 0xbce4, 0x3f61, 0xbcb0, 0x3f66, 0xbc84, 0x3f6a, 0xbc40, 0x3f6e,
    0xbc06, 0x3f72, 0xbbb0, 0x3f75, 0xbb56, 0x3f78, 0xbaec, 0x3f7a, 0xba5d, 0x3f7c, 0xb99f, 0x3f7e, 0xb87f, 0x3f7f, 0x2fcd, 0x3f7f,
    0xbc06, 0x3f72, 0xbbb0, 0x3f75, 0xbb56, 0x3f78, 0xbaec, 0x3f7a, 0xba5d, 0x3f7c, 0xb99f, 0x3f7e, 0xb87f, 0x3f7f, 0x2fcd, 0x3f7f,
    0x0000, 0x3f7f, 0x387f, 0x3f7f, 0x399f, 0x3f7e, 0x3a5d, 0x3f7c, 0x3aec, 0x3f7a, 0x3b56, 0x3f78, 0x3bb0, 0x3f75, 0x3c06, 0x3f72,
    0x0000, 0x3f7f, 0x387f, 0x3f7f, 0x399f, 0x3f7e, 0x3a5d, 0x3f7c, 0x3aec, 0x3f7a, 0x3b56, 0x3f78, 0x3bb0, 0x3f75, 0x3c06, 0x3f72,
    0x3c40, 0x3f6e, 0x3c84, 0x3f6a, 0x3cb0, 0x3f66, 0x3ce4, 0x3f61, 0x3d10, 0x3f5c, 0x3d32, 0x3f57, 0x3d58, 0x3f51, 0x3d81, 0x3f4c,
    0x3c40, 0x3f6e, 0x3c84, 0x3f6a, 0x3cb0, 0x3f66, 0x3ce4, 0x3f61, 0x3d10, 0x3f5c, 0x3d32, 0x3f57, 0x3d58, 0x3f51, 0x3d81, 0x3f4c,
    0x3d98, 0x3f46, 0x3db2, 0x3f40, 0x3dcd, 0x3f3a, 0x3dea, 0x3f34, 0x3e04, 0x3f2e, 0x3e14, 0x3f28, 0x3e25, 0x3f21, 0x3e37, 0x3f1b,
    0x3d98, 0x3f46, 0x3db2, 0x3f40, 0x3dcd, 0x3f3a, 0x3dea, 0x3f34, 0x3e04, 0x3f2e, 0x3e14, 0x3f28, 0x3e25, 0x3f21, 0x3e37, 0x3f1b,
    0x3e49, 0x3f15, 0x3e5b, 0x3f0f, 0x3e6f, 0x3f09, 0x3e81, 0x3f04, 0x3e8b, 0x3efc, 0x3e95, 0x3ef1, 0x3e9f, 0x3ee6, 0x3ea9, 0x3edc,
    0x3e49, 0x3f15, 0x3e5b, 0x3f0f, 0x3e6f, 0x3f09, 0x3e81, 0x3f04, 0x3e8b, 0x3efc, 0x3e95, 0x3ef1, 0x3e9f, 0x3ee6, 0x3ea9, 0x3edc,
    0x3eb3, 0x3ed1, 0x3ebe, 0x3ec8, 0x3ec8, 0x3ebe, 0x3ed2, 0x3eb5, 0x3edc, 0x3eac, 0x3ee6, 0x3ea3, 0x3ef0, 0x3e9b, 0x3efa, 0x3e93,
    0x3eb3, 0x3ed1, 0x3ebe, 0x3ec8, 0x3ec8, 0x3ebe, 0x3ed2, 0x3eb5, 0x3edc, 0x3eac, 0x3ee6, 0x3ea3, 0x3ef0, 0x3e9b, 0x3efa, 0x3e93,
    0x3f01, 0x3e8b, 0x3f06, 0x3e84, 0x3f0b, 0x3e7b, 0x3f0f, 0x3e6d, 0x3f13, 0x3e61, 0x3f18, 0x3e54, 0x3f1c, 0x3e49, 0x3f20, 0x3e3e,
    0x3f01, 0x3e8b, 0x3f06, 0x3e84, 0x3f0b, 0x3e7b, 0x3f0f, 0x3e6d, 0x3f13, 0x3e61, 0x3f18, 0x3e54, 0x3f1c, 0x3e49, 0x3f20, 0x3e3e,
    0x3f24, 0x3e33, 0x3f28, 0x3e29, 0x3f2b, 0x3e20, 0x3f2f, 0x3e17, 0x3f32, 0x3e0f, 0x3f36, 0x3e06, 0x3f39, 0x3dfe, 0x3f3c, 0x3df0,
    0x3f24, 0x3e33, 0x3f28, 0x3e29, 0x3f2b, 0x3e20, 0x3f2f, 0x3e17, 0x3f32, 0x3e0f, 0x3f36, 0x3e06, 0x3f39, 0x3dfe, 0x3f3c, 0x3df0,
    0x3f3f, 0x3de2, 0x3f42, 0x3dd5, 0x3f45, 0x3dc9, 0x3f47, 0x3dbd, 0x3f4a, 0x3db2, 0x3f4c, 0x3da8, 0x3f4f, 0x3d9e, 0x3f51, 0x3d95,
    0x3f3f, 0x3de2, 0x3f42, 0x3dd5, 0x3f45, 0x3dc9, 0x3f47, 0x3dbd, 0x3f4a, 0x3db2, 0x3f4c, 0x3da8, 0x3f4f, 0x3d9e, 0x3f51, 0x3d95,
    0x3f53, 0x3d8c, 0x3f55, 0x3d84, 0x3f57, 0x3d78, 0x3f59, 0x3d6a, 0x3f5b, 0x3d5c, 0x3f5d, 0x3d4f, 0x3f5e, 0x3d43, 0x3f60, 0x3d37,
    0x3f53, 0x3d8c, 0x3f55, 0x3d84, 0x3f57, 0x3d78, 0x3f59, 0x3d6a, 0x3f5b, 0x3d5c, 0x3f5d, 0x3d4f, 0x3f5e, 0x3d43, 0x3f60, 0x3d37,
    0x3f62, 0x3d2c, 0x3f63, 0x3d22, 0x3f64, 0x3d18, 0x3f66, 0x3d0f, 0x3f67, 0x3d07, 0x3f68, 0x3cfe, 0x3f69, 0x3cee, 0x3f6b, 0x3ce0,
    0x3f62, 0x3d2c, 0x3f63, 0x3d22, 0x3f64, 0x3d18, 0x3f66, 0x3d0f, 0x3f67, 0x3d07, 0x3f68, 0x3cfe, 0x3f69, 0x3cee, 0x3f6b, 0x3ce0,
    0x3f6c, 0x3cd3, 0x3f6d, 0x3cc6, 0x3f6e, 0x3cba, 0x3f6e, 0x3caf, 0x3f6f, 0x3ca5, 0x3f70, 0x3c9b, 0x3f71, 0x3c91, 0x3f72, 0x3c89,
    0x3f6c, 0x3cd3, 0x3f6d, 0x3cc6, 0x3f6e, 0x3cba, 0x3f6e, 0x3caf, 0x3f6f, 0x3ca5, 0x3f70, 0x3c9b, 0x3f71, 0x3c91, 0x3f72, 0x3c89,
    0x3f72, 0x3c80, 0x3f73, 0x3c72, 0x3f74, 0x3c63, 0x3f74, 0x3c55, 0x3f75, 0x3c48, 0x3f75, 0x3c3c, 0x3f76, 0x3c31, 0x3f76, 0x3c26,
    0x3f72, 0x3c80, 0x3f73, 0x3c72, 0x3f74, 0x3c63, 0x3f74, 0x3c55, 0x3f75, 0x3c48, 0x3f75, 0x3c3c, 0x3f76, 0x3c31, 0x3f76, 0x3c26,
    0x3f77, 0x3c1c, 0x3f77, 0x3c13, 0x3f78, 0x3c0a, 0x3f78, 0x3c02, 0x3f79, 0x3bf4, 0x3f79, 0x3be5, 0x3f79, 0x3bd7, 0x3f7a, 0x3bca,
    0x3f77, 0x3c1c, 0x3f77, 0x3c13, 0x3f78, 0x3c0a, 0x3f78, 0x3c02, 0x3f79, 0x3bf4, 0x3f79, 0x3be5, 0x3f79, 0x3bd7, 0x3f7a, 0x3bca,
    0x3f7a, 0x3bbe, 0x3f7a, 0x3bb2, 0x3f7a, 0x3ba8, 0x3f7b, 0x3b9d, 0x3f7b, 0x3b94, 0x3f7b, 0x3b8b, 0x3f7b, 0x3b83, 0x3f7c, 0x3b76,
    0x3f7a, 0x3bbe, 0x3f7a, 0x3bb2, 0x3f7a, 0x3ba8, 0x3f7b, 0x3b9d, 0x3f7b, 0x3b94, 0x3f7b, 0x3b8b, 0x3f7b, 0x3b83, 0x3f7c, 0x3b76,
    0x3f7c, 0x3b67, 0x3f7c, 0x3b59, 0x3f7c, 0x3b4c, 0x3f7c, 0x3b3f, 0x3f7d, 0x3b34, 0x3f7d, 0x3b29, 0x3f7d, 0x3b1f, 0x3f7d, 0x3b15,
    0x3f7c, 0x3b67, 0x3f7c, 0x3b59, 0x3f7c, 0x3b4c, 0x3f7c, 0x3b3f, 0x3f7d, 0x3b34, 0x3f7d, 0x3b29, 0x3f7d, 0x3b1f, 0x3f7d, 0x3b15,
    0x3f7d, 0x3b0c, 0x3f7d, 0x3b03, 0x3f7d, 0x3af7, 0x3f7e, 0x3ae8, 0x3f7e, 0x3ada, 0x3f7e, 0x3acd, 0x3f7e, 0x3ac1, 0x3f7e, 0x3ab5,
    0x3f7d, 0x3b0c, 0x3f7d, 0x3b03, 0x3f7d, 0x3af7, 0x3f7e, 0x3ae8, 0x3f7e, 0x3ada, 0x3f7e, 0x3acd, 0x3f7e, 0x3ac1, 0x3f7e, 0x3ab5,
    0x3f7e, 0x3aaa, 0x3f7e, 0x3aa0, 0x3f7e, 0x3a96, 0x3f7e, 0x3a8d, 0x3f7e, 0x3a84, 0x3f7e, 0x3a79, 0x3f7e, 0x3a6a, 0x3f7e, 0x3a5c,
    0x3f7e, 0x3aaa, 0x3f7e, 0x3aa0, 0x3f7e, 0x3a96, 0x3f7e, 0x3a8d, 0x3f7e, 0x3a84, 0x3f7e, 0x3a79, 0x3f7e, 0x3a6a, 0x3f7e, 0x3a5c,
    0x3f7f, 0x3a4e, 0x3f7f, 0x3a42, 0x3f7f, 0x3a36, 0x3f7f, 0x3a2b, 0x3f7f, 0x3a21, 0x3f7f, 0x3a17, 0x3f7f, 0x3a0e, 0x3f7f, 0x3a05,
    0x3f7f, 0x3a4e, 0x3f7f, 0x3a42, 0x3f7f, 0x3a36, 0x3f7f, 0x3a2b, 0x3f7f, 0x3a21, 0x3f7f, 0x3a17, 0x3f7f, 0x3a0e, 0x3f7f, 0x3a05,
    0x3f7f, 0x39fa, 0x3f7f, 0x39eb, 0x3f7f, 0x39dd, 0x3f7f, 0x39cf, 0x3f7f, 0x39c3, 0x3f7f, 0x39b7, 0x3f7f, 0x39ac, 0x3f7f, 0x39a1,
    0x3f7f, 0x39fa, 0x3f7f, 0x39eb, 0x3f7f, 0x39dd, 0x3f7f, 0x39cf, 0x3f7f, 0x39c3, 0x3f7f, 0x39b7, 0x3f7f, 0x39ac, 0x3f7f, 0x39a1,
    0x3f7f, 0x3998, 0x3f7f, 0x398e, 0x3f7f, 0x3986, 0x3f7f, 0x397c, 0x3f7f, 0x396c, 0x3f7f, 0x395e, 0x3f7f, 0x3951, 0x3f7f, 0x3944,
    0x3f7f, 0x3998, 0x3f7f, 0x398e, 0x3f7f, 0x3986, 0x3f7f, 0x397c, 0x3f7f, 0x396c, 0x3f7f, 0x395e, 0x3f7f, 0x3951, 0x3f7f, 0x3944
	};

	static const uint16_t lnr_lutcd[lut_sz*2*2]={                                   
    0xbf7f, 0x3944, 0xbf7f, 0x3951, 0xbf7f, 0x395e, 0xbf7f, 0x396c, 0xbf7f, 0x397c, 0xbf7f, 0x3986, 0xbf7f, 0x398e, 0xbf7f, 0x3998,
    0xbf7f, 0x3944, 0xbf7f, 0x3951, 0xbf7f, 0x395e, 0xbf7f, 0x396c, 0xbf7f, 0x397c, 0xbf7f, 0x3986, 0xbf7f, 0x398e, 0xbf7f, 0x3998,
    0xbf7f, 0x39a1, 0xbf7f, 0x39ac, 0xbf7f, 0x39b7, 0xbf7f, 0x39c3, 0xbf7f, 0x39cf, 0xbf7f, 0x39dd, 0xbf7f, 0x39eb, 0xbf7f, 0x39fa,
    0xbf7f, 0x39a1, 0xbf7f, 0x39ac, 0xbf7f, 0x39b7, 0xbf7f, 0x39c3, 0xbf7f, 0x39cf, 0xbf7f, 0x39dd, 0xbf7f, 0x39eb, 0xbf7f, 0x39fa,
    0xbf7f, 0x3a05, 0xbf7f, 0x3a0e, 0xbf7f, 0x3a17, 0xbf7f, 0x3a21, 0xbf7f, 0x3a2b, 0xbf7f, 0x3a36, 0xbf7f, 0x3a42, 0xbf7f, 0x3a4e,
    0xbf7f, 0x3a05, 0xbf7f, 0x3a0e, 0xbf7f, 0x3a17, 0xbf7f, 0x3a21, 0xbf7f, 0x3a2b, 0xbf7f, 0x3a36, 0xbf7f, 0x3a42, 0xbf7f, 0x3a4e,
    0xbf7e, 0x3a5c, 0xbf7e, 0x3a6a, 0xbf7e, 0x3a79, 0xbf7e, 0x3a84, 0xbf7e, 0x3a8d, 0xbf7e, 0x3a96, 0xbf7e, 0x3aa0, 0xbf7e, 0x3aaa,
    0xbf7e, 0x3a5c, 0xbf7e, 0x3a6a, 0xbf7e, 0x3a79, 0xbf7e, 0x3a84, 0xbf7e, 0x3a8d, 0xbf7e, 0x3a96, 0xbf7e, 0x3aa0, 0xbf7e, 0x3aaa,
    0xbf7e, 0x3ab5, 0xbf7e, 0x3ac1, 0xbf7e, 0x3acd, 0xbf7e, 0x3ada, 0xbf7e, 0x3ae8, 0xbf7d, 0x3af7, 0xbf7d, 0x3b03, 0xbf7d, 0x3b0c,
    0xbf7e, 0x3ab5, 0xbf7e, 0x3ac1, 0xbf7e, 0x3acd, 0xbf7e, 0x3ada, 0xbf7e, 0x3ae8, 0xbf7d, 0x3af7, 0xbf7d, 0x3b03, 0xbf7d, 0x3b0c,
    0xbf7d, 0x3b15, 0xbf7d, 0x3b1f, 0xbf7d, 0x3b29, 0xbf7d, 0x3b34, 0xbf7c, 0x3b3f, 0xbf7c, 0x3b4c, 0xbf7c, 0x3b59, 0xbf7c, 0x3b67,
    0xbf7d, 0x3b15, 0xbf7d, 0x3b1f, 0xbf7d, 0x3b29, 0xbf7d, 0x3b34, 0xbf7c, 0x3b3f, 0xbf7c, 0x3b4c, 0xbf7c, 0x3b59, 0xbf7c, 0x3b67,
    0xbf7c, 0x3b76, 0xbf7b, 0x3b83, 0xbf7b, 0x3b8b, 0xbf7b, 0x3b94, 0xbf7b, 0x3b9d, 0xbf7a, 0x3ba8, 0xbf7a, 0x3bb2, 0xbf7a, 0x3bbe,
    0xbf7c, 0x3b76, 0xbf7b, 0x3b83, 0xbf7b, 0x3b8b, 0xbf7b, 0x3b94, 0xbf7b, 0x3b9d, 0xbf7a, 0x3ba8, 0xbf7a, 0x3bb2, 0xbf7a, 0x3bbe,
    0xbf7a, 0x3bca, 0xbf79, 0x3bd7, 0xbf79, 0x3be5, 0xbf79, 0x3bf4, 0xbf78, 0x3c02, 0xbf78, 0x3c0a, 0xbf77, 0x3c13, 0xbf77, 0x3c1c,
    0xbf7a, 0x3bca, 0xbf79, 0x3bd7, 0xbf79, 0x3be5, 0xbf79, 0x3bf4, 0xbf78, 0x3c02, 0xbf78, 0x3c0a, 0xbf77, 0x3c13, 0xbf77, 0x3c1c,
    0xbf76, 0x3c26, 0xbf76, 0x3c31, 0xbf75, 0x3c3c, 0xbf75, 0x3c48, 0xbf74, 0x3c55, 0xbf74, 0x3c63, 0xbf73, 0x3c72, 0xbf72, 0x3c80,
    0xbf76, 0x3c26, 0xbf76, 0x3c31, 0xbf75, 0x3c3c, 0xbf75, 0x3c48, 0xbf74, 0x3c55, 0xbf74, 0x3c63, 0xbf73, 0x3c72, 0xbf72, 0x3c80,
    0xbf72, 0x3c89, 0xbf71, 0x3c91, 0xbf70, 0x3c9b, 0xbf6f, 0x3ca5, 0xbf6e, 0x3caf, 0xbf6e, 0x3cba, 0xbf6d, 0x3cc6, 0xbf6c, 0x3cd3,
    0xbf72, 0x3c89, 0xbf71, 0x3c91, 0xbf70, 0x3c9b, 0xbf6f, 0x3ca5, 0xbf6e, 0x3caf, 0xbf6e, 0x3cba, 0xbf6d, 0x3cc6, 0xbf6c, 0x3cd3,
    0xbf6b, 0x3ce0, 0xbf69, 0x3cee, 0xbf68, 0x3cfe, 0xbf67, 0x3d07, 0xbf66, 0x3d0f, 0xbf64, 0x3d18, 0xbf63, 0x3d22, 0xbf62, 0x3d2c,
    0xbf6b, 0x3ce0, 0xbf69, 0x3cee, 0xbf68, 0x3cfe, 0xbf67, 0x3d07, 0xbf66, 0x3d0f, 0xbf64, 0x3d18, 0xbf63, 0x3d22, 0xbf62, 0x3d2c,
    0xbf60, 0x3d37, 0xbf5e, 0x3d43, 0xbf5d, 0x3d4f, 0xbf5b, 0x3d5c, 0xbf59, 0x3d6a, 0xbf57, 0x3d78, 0xbf55, 0x3d84, 0xbf53, 0x3d8c,
    0xbf60, 0x3d37, 0xbf5e, 0x3d43, 0xbf5d, 0x3d4f, 0xbf5b, 0x3d5c, 0xbf59, 0x3d6a, 0xbf57, 0x3d78, 0xbf55, 0x3d84, 0xbf53, 0x3d8c,
    0xbf51, 0x3d95, 0xbf4f, 0x3d9e, 0xbf4c, 0x3da8, 0xbf4a, 0x3db2, 0xbf47, 0x3dbd, 0xbf45, 0x3dc9, 0xbf42, 0x3dd5, 0xbf3f, 0x3de2,
    0xbf51, 0x3d95, 0xbf4f, 0x3d9e, 0xbf4c, 0x3da8, 0xbf4a, 0x3db2, 0xbf47, 0x3dbd, 0xbf45, 0x3dc9, 0xbf42, 0x3dd5, 0xbf3f, 0x3de2,
    0xbf3c, 0x3df0, 0xbf39, 0x3dfe, 0xbf36, 0x3e06, 0xbf32, 0x3e0f, 0xbf2f, 0x3e17, 0xbf2b, 0x3e20, 0xbf28, 0x3e29, 0xbf24, 0x3e33,
    0xbf3c, 0x3df0, 0xbf39, 0x3dfe, 0xbf36, 0x3e06, 0xbf32, 0x3e0f, 0xbf2f, 0x3e17, 0xbf2b, 0x3e20, 0xbf28, 0x3e29, 0xbf24, 0x3e33,
    0xbf20, 0x3e3e, 0xbf1c, 0x3e49, 0xbf18, 0x3e54, 0xbf13, 0x3e61, 0xbf0f, 0x3e6d, 0xbf0b, 0x3e7b, 0xbf06, 0x3e84, 0xbf01, 0x3e8b,
    0xbf20, 0x3e3e, 0xbf1c, 0x3e49, 0xbf18, 0x3e54, 0xbf13, 0x3e61, 0xbf0f, 0x3e6d, 0xbf0b, 0x3e7b, 0xbf06, 0x3e84, 0xbf01, 0x3e8b,
    0xbefa, 0x3e93, 0xbef0, 0x3e9b, 0xbee6, 0x3ea3, 0xbedc, 0x3eac, 0xbed2, 0x3eb5, 0xbec8, 0x3ebe, 0xbebe, 0x3ec8, 0xbeb3, 0x3ed1,
    0xbefa, 0x3e93, 0xbef0, 0x3e9b, 0xbee6, 0x3ea3, 0xbedc, 0x3eac, 0xbed2, 0x3eb5, 0xbec8, 0x3ebe, 0xbebe, 0x3ec8, 0xbeb3, 0x3ed1,
    0xbea9, 0x3edc, 0xbe9f, 0x3ee6, 0xbe95, 0x3ef1, 0xbe8b, 0x3efc, 0xbe81, 0x3f04, 0xbe6f, 0x3f09, 0xbe5b, 0x3f0f, 0xbe49, 0x3f15,
    0xbea9, 0x3edc, 0xbe9f, 0x3ee6, 0xbe95, 0x3ef1, 0xbe8b, 0x3efc, 0xbe81, 0x3f04, 0xbe6f, 0x3f09, 0xbe5b, 0x3f0f, 0xbe49, 0x3f15,
    0xbe37, 0x3f1b, 0xbe25, 0x3f21, 0xbe14, 0x3f28, 0xbe04, 0x3f2e, 0xbdea, 0x3f34, 0xbdcd, 0x3f3a, 0xbdb2, 0x3f40, 0xbd98, 0x3f46,
    0xbe37, 0x3f1b, 0xbe25, 0x3f21, 0xbe14, 0x3f28, 0xbe04, 0x3f2e, 0xbdea, 0x3f34, 0xbdcd, 0x3f3a, 0xbdb2, 0x3f40, 0xbd98, 0x3f46,
    0xbd81, 0x3f4c, 0xbd58, 0x3f51, 0xbd32, 0x3f57, 0xbd10, 0x3f5c, 0xbce4, 0x3f61, 0xbcb0, 0x3f66, 0xbc84, 0x3f6a, 0xbc40, 0x3f6e,
    0xbd81, 0x3f4c, 0xbd58, 0x3f51, 0xbd32, 0x3f57, 0xbd10, 0x3f5c, 0xbce4, 0x3f61, 0xbcb0, 0x3f66, 0xbc84, 0x3f6a, 0xbc40, 0x3f6e,
    0xbc06, 0x3f72, 0xbbb0, 0x3f75, 0xbb56, 0x3f78, 0xbaec, 0x3f7a, 0xba5d, 0x3f7c, 0xb99f, 0x3f7e, 0xb87f, 0x3f7f, 0x2fcd, 0x3f7f,
    0xbc06, 0x3f72, 0xbbb0, 0x3f75, 0xbb56, 0x3f78, 0xbaec, 0x3f7a, 0xba5d, 0x3f7c, 0xb99f, 0x3f7e, 0xb87f, 0x3f7f, 0x2fcd, 0x3f7f,
    0x0000, 0x3f7f, 0x387f, 0x3f7f, 0x399f, 0x3f7e, 0x3a5d, 0x3f7c, 0x3aec, 0x3f7a, 0x3b56, 0x3f78, 0x3bb0, 0x3f75, 0x3c06, 0x3f72,
    0x0000, 0x3f7f, 0x387f, 0x3f7f, 0x399f, 0x3f7e, 0x3a5d, 0x3f7c, 0x3aec, 0x3f7a, 0x3b56, 0x3f78, 0x3bb0, 0x3f75, 0x3c06, 0x3f72,
    0x3c40, 0x3f6e, 0x3c84, 0x3f6a, 0x3cb0, 0x3f66, 0x3ce4, 0x3f61, 0x3d10, 0x3f5c, 0x3d32, 0x3f57, 0x3d58, 0x3f51, 0x3d81, 0x3f4c,
    0x3c40, 0x3f6e, 0x3c84, 0x3f6a, 0x3cb0, 0x3f66, 0x3ce4, 0x3f61, 0x3d10, 0x3f5c, 0x3d32, 0x3f57, 0x3d58, 0x3f51, 0x3d81, 0x3f4c,
    0x3d98, 0x3f46, 0x3db2, 0x3f40, 0x3dcd, 0x3f3a, 0x3dea, 0x3f34, 0x3e04, 0x3f2e, 0x3e14, 0x3f28, 0x3e25, 0x3f21, 0x3e37, 0x3f1b,
    0x3d98, 0x3f46, 0x3db2, 0x3f40, 0x3dcd, 0x3f3a, 0x3dea, 0x3f34, 0x3e04, 0x3f2e, 0x3e14, 0x3f28, 0x3e25, 0x3f21, 0x3e37, 0x3f1b,
    0x3e49, 0x3f15, 0x3e5b, 0x3f0f, 0x3e6f, 0x3f09, 0x3e81, 0x3f04, 0x3e8b, 0x3efc, 0x3e95, 0x3ef1, 0x3e9f, 0x3ee6, 0x3ea9, 0x3edc,
    0x3e49, 0x3f15, 0x3e5b, 0x3f0f, 0x3e6f, 0x3f09, 0x3e81, 0x3f04, 0x3e8b, 0x3efc, 0x3e95, 0x3ef1, 0x3e9f, 0x3ee6, 0x3ea9, 0x3edc,
    0x3eb3, 0x3ed1, 0x3ebe, 0x3ec8, 0x3ec8, 0x3ebe, 0x3ed2, 0x3eb5, 0x3edc, 0x3eac, 0x3ee6, 0x3ea3, 0x3ef0, 0x3e9b, 0x3efa, 0x3e93,
    0x3eb3, 0x3ed1, 0x3ebe, 0x3ec8, 0x3ec8, 0x3ebe, 0x3ed2, 0x3eb5, 0x3edc, 0x3eac, 0x3ee6, 0x3ea3, 0x3ef0, 0x3e9b, 0x3efa, 0x3e93,
    0x3f01, 0x3e8b, 0x3f06, 0x3e84, 0x3f0b, 0x3e7b, 0x3f0f, 0x3e6d, 0x3f13, 0x3e61, 0x3f18, 0x3e54, 0x3f1c, 0x3e49, 0x3f20, 0x3e3e,
    0x3f01, 0x3e8b, 0x3f06, 0x3e84, 0x3f0b, 0x3e7b, 0x3f0f, 0x3e6d, 0x3f13, 0x3e61, 0x3f18, 0x3e54, 0x3f1c, 0x3e49, 0x3f20, 0x3e3e,
    0x3f24, 0x3e33, 0x3f28, 0x3e29, 0x3f2b, 0x3e20, 0x3f2f, 0x3e17, 0x3f32, 0x3e0f, 0x3f36, 0x3e06, 0x3f39, 0x3dfe, 0x3f3c, 0x3df0,
    0x3f24, 0x3e33, 0x3f28, 0x3e29, 0x3f2b, 0x3e20, 0x3f2f, 0x3e17, 0x3f32, 0x3e0f, 0x3f36, 0x3e06, 0x3f39, 0x3dfe, 0x3f3c, 0x3df0,
    0x3f3f, 0x3de2, 0x3f42, 0x3dd5, 0x3f45, 0x3dc9, 0x3f47, 0x3dbd, 0x3f4a, 0x3db2, 0x3f4c, 0x3da8, 0x3f4f, 0x3d9e, 0x3f51, 0x3d95,
    0x3f3f, 0x3de2, 0x3f42, 0x3dd5, 0x3f45, 0x3dc9, 0x3f47, 0x3dbd, 0x3f4a, 0x3db2, 0x3f4c, 0x3da8, 0x3f4f, 0x3d9e, 0x3f51, 0x3d95,
    0x3f53, 0x3d8c, 0x3f55, 0x3d84, 0x3f57, 0x3d78, 0x3f59, 0x3d6a, 0x3f5b, 0x3d5c, 0x3f5d, 0x3d4f, 0x3f5e, 0x3d43, 0x3f60, 0x3d37,
    0x3f53, 0x3d8c, 0x3f55, 0x3d84, 0x3f57, 0x3d78, 0x3f59, 0x3d6a, 0x3f5b, 0x3d5c, 0x3f5d, 0x3d4f, 0x3f5e, 0x3d43, 0x3f60, 0x3d37,
    0x3f62, 0x3d2c, 0x3f63, 0x3d22, 0x3f64, 0x3d18, 0x3f66, 0x3d0f, 0x3f67, 0x3d07, 0x3f68, 0x3cfe, 0x3f69, 0x3cee, 0x3f6b, 0x3ce0,
    0x3f62, 0x3d2c, 0x3f63, 0x3d22, 0x3f64, 0x3d18, 0x3f66, 0x3d0f, 0x3f67, 0x3d07, 0x3f68, 0x3cfe, 0x3f69, 0x3cee, 0x3f6b, 0x3ce0,
    0x3f6c, 0x3cd3, 0x3f6d, 0x3cc6, 0x3f6e, 0x3cba, 0x3f6e, 0x3caf, 0x3f6f, 0x3ca5, 0x3f70, 0x3c9b, 0x3f71, 0x3c91, 0x3f72, 0x3c89,
    0x3f6c, 0x3cd3, 0x3f6d, 0x3cc6, 0x3f6e, 0x3cba, 0x3f6e, 0x3caf, 0x3f6f, 0x3ca5, 0x3f70, 0x3c9b, 0x3f71, 0x3c91, 0x3f72, 0x3c89,
    0x3f72, 0x3c80, 0x3f73, 0x3c72, 0x3f74, 0x3c63, 0x3f74, 0x3c55, 0x3f75, 0x3c48, 0x3f75, 0x3c3c, 0x3f76, 0x3c31, 0x3f76, 0x3c26,
    0x3f72, 0x3c80, 0x3f73, 0x3c72, 0x3f74, 0x3c63, 0x3f74, 0x3c55, 0x3f75, 0x3c48, 0x3f75, 0x3c3c, 0x3f76, 0x3c31, 0x3f76, 0x3c26,
    0x3f77, 0x3c1c, 0x3f77, 0x3c13, 0x3f78, 0x3c0a, 0x3f78, 0x3c02, 0x3f79, 0x3bf4, 0x3f79, 0x3be5, 0x3f79, 0x3bd7, 0x3f7a, 0x3bca,
    0x3f77, 0x3c1c, 0x3f77, 0x3c13, 0x3f78, 0x3c0a, 0x3f78, 0x3c02, 0x3f79, 0x3bf4, 0x3f79, 0x3be5, 0x3f79, 0x3bd7, 0x3f7a, 0x3bca,
    0x3f7a, 0x3bbe, 0x3f7a, 0x3bb2, 0x3f7a, 0x3ba8, 0x3f7b, 0x3b9d, 0x3f7b, 0x3b94, 0x3f7b, 0x3b8b, 0x3f7b, 0x3b83, 0x3f7c, 0x3b76,
    0x3f7a, 0x3bbe, 0x3f7a, 0x3bb2, 0x3f7a, 0x3ba8, 0x3f7b, 0x3b9d, 0x3f7b, 0x3b94, 0x3f7b, 0x3b8b, 0x3f7b, 0x3b83, 0x3f7c, 0x3b76,
    0x3f7c, 0x3b67, 0x3f7c, 0x3b59, 0x3f7c, 0x3b4c, 0x3f7c, 0x3b3f, 0x3f7d, 0x3b34, 0x3f7d, 0x3b29, 0x3f7d, 0x3b1f, 0x3f7d, 0x3b15,
    0x3f7c, 0x3b67, 0x3f7c, 0x3b59, 0x3f7c, 0x3b4c, 0x3f7c, 0x3b3f, 0x3f7d, 0x3b34, 0x3f7d, 0x3b29, 0x3f7d, 0x3b1f, 0x3f7d, 0x3b15,
    0x3f7d, 0x3b0c, 0x3f7d, 0x3b03, 0x3f7d, 0x3af7, 0x3f7e, 0x3ae8, 0x3f7e, 0x3ada, 0x3f7e, 0x3acd, 0x3f7e, 0x3ac1, 0x3f7e, 0x3ab5,
    0x3f7d, 0x3b0c, 0x3f7d, 0x3b03, 0x3f7d, 0x3af7, 0x3f7e, 0x3ae8, 0x3f7e, 0x3ada, 0x3f7e, 0x3acd, 0x3f7e, 0x3ac1, 0x3f7e, 0x3ab5,
    0x3f7e, 0x3aaa, 0x3f7e, 0x3aa0, 0x3f7e, 0x3a96, 0x3f7e, 0x3a8d, 0x3f7e, 0x3a84, 0x3f7e, 0x3a79, 0x3f7e, 0x3a6a, 0x3f7e, 0x3a5c,
    0x3f7e, 0x3aaa, 0x3f7e, 0x3aa0, 0x3f7e, 0x3a96, 0x3f7e, 0x3a8d, 0x3f7e, 0x3a84, 0x3f7e, 0x3a79, 0x3f7e, 0x3a6a, 0x3f7e, 0x3a5c,
    0x3f7f, 0x3a4e, 0x3f7f, 0x3a42, 0x3f7f, 0x3a36, 0x3f7f, 0x3a2b, 0x3f7f, 0x3a21, 0x3f7f, 0x3a17, 0x3f7f, 0x3a0e, 0x3f7f, 0x3a05,
    0x3f7f, 0x3a4e, 0x3f7f, 0x3a42, 0x3f7f, 0x3a36, 0x3f7f, 0x3a2b, 0x3f7f, 0x3a21, 0x3f7f, 0x3a17, 0x3f7f, 0x3a0e, 0x3f7f, 0x3a05,
    0x3f7f, 0x39fa, 0x3f7f, 0x39eb, 0x3f7f, 0x39dd, 0x3f7f, 0x39cf, 0x3f7f, 0x39c3, 0x3f7f, 0x39b7, 0x3f7f, 0x39ac, 0x3f7f, 0x39a1,
    0x3f7f, 0x39fa, 0x3f7f, 0x39eb, 0x3f7f, 0x39dd, 0x3f7f, 0x39cf, 0x3f7f, 0x39c3, 0x3f7f, 0x39b7, 0x3f7f, 0x39ac, 0x3f7f, 0x39a1,
    0x3f7f, 0x3998, 0x3f7f, 0x398e, 0x3f7f, 0x3986, 0x3f7f, 0x397c, 0x3f7f, 0x396c, 0x3f7f, 0x395e, 0x3f7f, 0x3951, 0x3f7f, 0x3944,
    0x3f7f, 0x3998, 0x3f7f, 0x398e, 0x3f7f, 0x3986, 0x3f7f, 0x397c, 0x3f7f, 0x396c, 0x3f7f, 0x395e, 0x3f7f, 0x3951, 0x3f7f, 0x3944
	};
}

#endif //TANH_LUT_BF16_512_H

