# pylint: skip-file

# Copyright (C) 2019 - 2022 Xilinx, Inc. All rights reserved.
# Copyright (C) 2022 - 2025 Advanced Micro Devices, Inc. All rights reserved.
#
# This file contains confidential and proprietary information
# of Xilinx, Inc. and is protected under U.S. and
# international copyright and other intellectual property
# laws.
#
# DISCLAIMER
# This disclaimer is not a license and does not grant any
# rights to the materials distributed herewith. Except as
# otherwise provided in a valid license issued to you by
# Xilinx, and to the maximum extent permitted by applicable
# law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
# WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
# AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
# BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
# INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
# (2) Xilinx shall not be liable (whether in contract or tort,
# including negligence, or under any other theory of
# liability) for any loss or damage of any kind or nature
# related to, arising under or in connection with these
# materials, including for any direct, or any indirect,
# special, incidental, or consequential loss or damage
# (including loss of data, profits, goodwill, or any type of
# loss or damage suffered as a result of any action brought
# by a third party) even if such damage or loss was
# reasonably foreseeable or Xilinx had been advised of the
# possibility of the same.
#
# CRITICAL APPLICATIONS
# Xilinx products are not designed or intended to be fail-
# safe, or for use in any application requiring fail-safe
# performance, such as life-support or safety devices or
# systems, Class III medical devices, nuclear facilities,
# applications related to the deployment of airbags, or any
# other applications that could lead to death, personal
# injury, or severe property or environmental damage
# (individually and collectively, "Critical
# Applications"). Customer assumes the sole risk and
# liability of any use of Xilinx products in Critical
# Applications, subject only to applicable laws and
# regulations governing limitations on product liability.
#
# THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
# PART OF THIS FILE AT ALL TIMES.

import numpy as np
from .data_converter import DataConverter


class NlfModel( DataConverter ):

    def approx_exp2( self, inp, bits_out=16 ):
        if not isinstance( inp, np.ndarray ): inp = np.array( inp )
        exp2_cnst  = np.array((  0, 39, 74, 110, 141, 172, 200, 225, 250, 270, 290, 305, 320, 332, 340, 347, 352, 352, 350, 347, 340, 328, 315, 299, 280, 257, 229, 200, 167, 131, 91, 47 ))
        exp2_coeff = np.array(( -10, -9, -9,  -8,  -8,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -3,  -2,  -2,  -1,   0,   0,   1,   2,   3,   3,   4,   5,   6,   7,   7,   8,   9,  10, 11, 12 ));
        x      = (( inp.astype( np.float32 ) + np.float32( 895.00099 )).getfield( np.int32 ) >> 2 ) - ( 0x111 << 20 )
        sel    = ( x >> 7 ) & 31
        fwd    = ( x & ~1 ) + ( 16 if bits_out == 16 else 0 )
        if bits_out == 16:
            if not isinstance( fwd, np.ndarray ): fwd = np.array( fwd )
            fwd[(( x >> 4 ) & 255 ) == 255] &= ~15
            bits_trunc = 16
        else:
            bits_trunc = 32
        prod   = (( x >> 2 ) & 31 ) * exp2_coeff[sel]
        approx = fwd + ( prod >> 3 ) - exp2_cnst[sel]
        dn_mask = ( x < ( 1 << 12 )) & ( x >= ( -11 << 12 ))
        if not isinstance( approx, np.ndarray ): approx = np.array( approx )
        dn_data = 4096 + ( approx[dn_mask] & 4095 )
        dn_shft = 1 - ( approx[dn_mask] >> 12 )
        approx[dn_mask] = ( dn_data >> dn_shft ) | (( dn_data & (( 1 << dn_shft ) - 1 )) != 0 )
        out  = (( np.minimum( np.maximum( approx, 0 ), 255 << 12 ) << 11 ) & ((( 1 << ( bits_trunc - 1 )) - 1 ) << ( 32 - bits_trunc ))).getfield( np.float32 )
        if not isinstance( out, np.ndarray ): out = np.array( out )
        out[np.isnan( inp )] = np.nan
        return out


    def approx_tanh( self, inp ):
        inp = self.f2bf( inp, rounding=False )
        def approx_tanh_core( inp ):
            if (  inp >= 3.0 )  : out =                 1.0;
            elif ( inp >= 2.0 )  : out = 0.03125 * inp + 0.90625;
            elif ( inp >= 1.75 ) : out = 0.125   * inp + 0.71875;
            elif ( inp >= 1.5 )  : out = 0.125   * inp + 0.72265625;
            elif ( inp >= 1.25 ) : out = 0.25    * inp + 0.53515625;
            elif ( inp >= 1.0 )  : out = 0.25    * inp + 0.52734375;
            elif ( inp >= 0.75 ) : out = 0.5     * inp + 0.265625;
            elif ( inp >= 0.625 ): out = 0.5     * inp + 0.25390625;
            elif ( inp >= 0.5 )  : out = 0.5     * inp + 0.25;
            elif ( inp > -0.5 )  : out =           inp;
            elif ( inp > -0.625 ): out = 0.5     * inp - 0.25;
            elif ( inp > -0.75 ) : out = 0.5     * inp - 0.25390625;
            elif ( inp > -1.0 )  : out = 0.5     * inp - 0.265625;
            elif ( inp > -1.25 ) : out = 0.25    * inp - 0.52734375;
            elif ( inp > -1.5 )  : out = 0.25    * inp - 0.53515625;
            elif ( inp > -1.75 ) : out = 0.125   * inp - 0.72265625;
            elif ( inp > -2.0 )  : out = 0.125   * inp - 0.71875;
            elif ( inp > -3.0 )  : out = 0.03125 * inp - 0.90625;
            else                 : out =               - 1.0;
            return out
        out = np.vectorize( approx_tanh_core )( inp )
        return self.f2bf( out, rounding=False )

