#pragma once

namespace qdq_kernel_params {
    std::vector<uint8_t> gen_qdq_params(int subv_elems, /*int qdq_prm_addr,*/ int index, int quant_offset)
    {
        int dq_zp_elem_idx = 2 * index;
        int dq_sc_elem_idx = dq_zp_elem_idx + 1;

        int q_zp_elem_idx = quant_offset;
        int q_sc_elem_idx = quant_offset + 1;

        int dq_enable_idx = quant_offset + 2;
        int q_enable_idx = quant_offset + 3;

        std::vector<uint8_t> result;
        result.reserve(14);

        auto append_little_endian_2bytes = [&result](uint16_t value) {
            result.push_back(static_cast<uint8_t>(value & 0xFF));
            result.push_back(static_cast<uint8_t>((value >> 8) & 0xFF));
        };

        append_little_endian_2bytes(static_cast<uint16_t>(subv_elems));
        append_little_endian_2bytes(static_cast<uint16_t>(dq_zp_elem_idx));
        append_little_endian_2bytes(static_cast<uint16_t>(dq_sc_elem_idx));
        append_little_endian_2bytes(static_cast<uint16_t>(q_zp_elem_idx));
        append_little_endian_2bytes(static_cast<uint16_t>(q_sc_elem_idx));
        append_little_endian_2bytes(static_cast<uint16_t>(dq_enable_idx));
        append_little_endian_2bytes(static_cast<uint16_t>(q_enable_idx));

        return result;
    }

    std::vector<uint8_t> gen_qdq_params_a8(int subv_elems, int index, int quant_offset, int scratch_buffer_addr,
                                        int fixed_point_bits, int qdq_mode, int output_addr)
    {
        int is_int16 = (fixed_point_bits == 8) ? 0 : 1;

        int dq_zp_elem_idx = 2 * index;
        int dq_sc_elem_idx = dq_zp_elem_idx + 1;

        int q_zp_elem_idx = quant_offset;
        int q_sc_elem_idx = quant_offset + 1;

        int dq_enable_idx = quant_offset + 2;
        int q_enable_idx = quant_offset + 3;

        int scratch_buffer_addr_core = (qdq_mode == 2 && is_int16 == 0) ? scratch_buffer_addr : output_addr;

        std::vector<uint8_t> result;
        result.reserve(18);

        auto append_little_endian_2bytes = [&result](uint16_t value) {
            result.push_back(static_cast<uint8_t>(value & 0xFF));
            result.push_back(static_cast<uint8_t>((value >> 8) & 0xFF));
        };

        append_little_endian_2bytes(static_cast<uint16_t>(subv_elems));
        append_little_endian_2bytes(static_cast<uint16_t>(scratch_buffer_addr_core));
        append_little_endian_2bytes(static_cast<uint16_t>(is_int16));
        append_little_endian_2bytes(static_cast<uint16_t>(dq_zp_elem_idx));
        append_little_endian_2bytes(static_cast<uint16_t>(dq_sc_elem_idx));
        append_little_endian_2bytes(static_cast<uint16_t>(q_zp_elem_idx));
        append_little_endian_2bytes(static_cast<uint16_t>(q_sc_elem_idx));
        append_little_endian_2bytes(static_cast<uint16_t>(dq_enable_idx));
        append_little_endian_2bytes(static_cast<uint16_t>(q_enable_idx));

        return result;
    }
}