#ifndef __WRAPPER_SLICE_CC__
#define __WRAPPER_SLICE_CC__
#include "slice_16b_c6463_impl.hpp"

void run_slice_c6463(KernelArgs& args)
{
    struct LayerParams
    {
        int32_t offset_bytes;
        SliceParams kernel_params;
    };
    LayerParams* layer_params = static_cast<LayerParams*>(args.params_data);
    SliceParams& kernel_params = layer_params->kernel_params;
    int16_t* input = static_cast<int16_t*>(args.s2mm_ch0_data);
    int16_t* outputA = static_cast<int16_t*>(args.mm2s_ch0_data);
    int16_t* outputB = byte_incr(outputA, layer_params->offset_bytes);
    slice_16b_c6463 (
        input,
        outputA,
        outputB,
        kernel_params
    );

}

#endif