# WAIC runner
WAIC runtime to compile bin files from WAIC output and run the combined bin file.

Usage ---

```
./waic_runtime.exe  <workload_path/config.json> [num_runs]
```

## Pre-requisites
### Board setup
Please follow the instructions [here](https://confluence.xilinx.com/pages/viewpage.action?pageId=672012798#TVMDPUruntime(AIEsim,SimNowLite,IPUboard)-Windows/board) to setup the board.

### CMake and C compiler in Windows
Use VisualStudio's Developer powershell to run cmake & compilation steps, or follow these steps to set it up via conda ---

```
conda env create -f env.yml
conda activate waic_runner
```

## Clone & Compile
```
git clone https://gitenterprise.xilinx.com/AIE-Architecture/aie_runner
cd aie_runner
set XRT_DIR=<path/to/xrt>
cmake -S . -B build -DCMAKE_INSTALL_PREFIX=build\Release --fresh
cmake --build build --config=Release --target install -j <nprc>
```

## Execute application
```
build\tests\Release\waic_runtime.exe <workload_path/cfg.json> [num_runs=1]
```

## Typical json file
```

config.json has the typical json file used in waic_runtime with default values for Compile_cfg and Debug_cfg
config_json.txt provides the comments.
```
## HW Recorder profiling
```

In config.json file, set Compile_cfg\profile be 3 to enable recorder timer. 

After running waic_runtime.exe, the following two files will be generated in the working directory.
1. dd_timestamp_info.json
2. record_timer_ts.json

You can use the following tool to visualize the profiling, https://ryzenai.docs.amd.com/en/latest/ai_analyzer.html#
1. Install it once, the wheel file can be found from https://artifactory.xilinx.com/ui/native/dlanalyzer-wheel/rai_1_5_0/
   pip install aianalyzer-1.5.0.dev20250623225740+gefff02fa-py3-none-any
2. launch it from the working directory 
   aianalyzer .\ --port=8087
```
