#pragma once

#include "op_common.hpp"
namespace waic_runner
{
class FusionRuntime
{
  public:
    FusionRuntime(const rtcfg &cfg, const json &tilings_data);
    FusionRuntime(const std::string &meta_file, const std::string &prebuilt_bin_dir,
                  const std::string &cache_dir, const bool &is_meta_string=false);
    void compile(cpcfg cfg);
    void compile(cpcfg cfg, std::vector<uint8_t> &const_bo, std::vector<uint8_t> &instr_bo,
                 std::vector<uint8_t> &super_instr_bo, std::vector<uint8_t> &ctrl_pkt_info);
    const Metadata &get_meta() const;
    std::vector<uint8_t> merge_inputs(const std::vector<Tensor> &inputs);
    void merge_inputs(const std::vector<Tensor> &inputs, void *input_ptr, void *output_ptr=NULL);
    void split_outputs(const std::vector<Tensor> &outputs, const std::vector<uint8_t> &output_bo);
    void split_outputs(const std::vector<Tensor> &outputs, void *output_ptr);
    void save_state(const std::string &state_name);
    void save_state(std::vector<uint8_t> &state_data);
    void load_state(const std::unique_ptr<std::vector<uint8_t>> state_data);
    void load_state(const std::string &state_name);
    bool get_verbose()
    {
        return verbose_;
    };
    void set_verbose(const bool verbose)
    {
        verbose_ = verbose;
    };

  private:
    std::string xclbin_fname_;
    std::string binfile_path_;
    std::string prebuilt_bin_dir_;
    std::string cache_dir_;
    Metadata meta_;
    bool use_inmem_;
    bool elf_flow_;
    bool verbose_ = 0;
    std::string prefix_;
    json tilings_data_;

    // Host buffers.
    FILE *input_vec_file_ptr_;
    FILE *const_vec_file_ptr_;
    std::vector<uint8_t> output_vec_;
    std::vector<uint8_t> scratch_vec_;
    FILE *super_instr_vec_file_ptr_;
    FILE *ctrl_pkt_vec_file_ptr_;

    std::vector<std::vector<uint8_t>> fused_instr_vec_;
    std::vector<std::vector<uint8_t>> opt_txns_;

    // procucer_ops_ = [{op_info1, op1}, {op_info2, op2}, ...]
    ///  A struct to store operator info plus the out_index for multi-output
    struct ProducerEntry
    {
        Metadata::OpInfo op_info;
        size_t out_index; ///< Which output index in op_info.out_args
    };

    /// A list of ProducerEntry items for the final graph outputs only.
    /// build exactly one entry for each output in meta_.fused_tensors["out"].
    std::vector<ProducerEntry> producer_ops_out_;
    std::vector<ProducerEntry> producer_ops_in_;

    void allocate_host_bos(const Metadata &meta);
    void release_host_resources();
    void fill_super_instr(const Metadata &meta);
    void fill_ctrl_pkts(const Metadata &meta);
    void load_const(const Metadata &meta);
    void fetch_txn_bins(Metadata &meta);
    void save_files();
    void write_in_vec(std::vector<uint8_t> &const_bo, std::vector<uint8_t> &instr_bo,
                      std::vector<uint8_t> &super_instr_bo);
    void save_ctrl_pkt_info(const Metadata &meta, bool elf_flow);
    void write_ctrl_pkt_info_in_vec(const Metadata &meta, bool elf_flow,
                                    std::vector<uint8_t> &ctrl_pkt_info);
    std::vector<std::vector<uint8_t>> generate_fused_txns(const Metadata &meta);
    void prepare_formatting_ops(const std::string &io_name, std::vector<ProducerEntry> &producer_ops);
};
} // namespace waic_runner
