// Copyright 2022-2024 Advanced Micro Devices, Inc. All Rights Reserved.
////////////////////////////////////////////////////////////////////////
#pragma once
#include <fstream>
#include <iostream>
#include <map>
#include <string>
#include <vector>

#include <cstdint>

#include <nlohmann/json.hpp>
using json = nlohmann::json;
namespace waic_runner {
    struct CtrlPktPatchInfo {
        size_t offset; // offset in ctrl pkt bin
        size_t size;   // number of bytes to modify
        size_t xrt_arg_idx;
        size_t bo_offset; // offset in BO to patch
    };

    json read_json_file(const std::string& json_fname);
    json parse_json(const std::string& json_data);

    std::vector<CtrlPktPatchInfo>
        extract_ctrlpkt_patch_info(json& data);
    std::vector<CtrlPktPatchInfo>
        ext_buf_json_to_ctrlpkt_patch_info(json& s, const std::vector<uint8_t>& ctrl_bin);
    std::vector<std::string> get_keys(const json& j, const std::vector<std::string>& excludeStr);
}
