#pragma once
#include "op_common.hpp"
namespace waic_runner {
	void analyze_buffer_reqs(Metadata& meta, std::string& binfile_path, std::string& prebuilt_bin_dir, const json& tilings_data, bool use_inmem);
	void optimize_scratch_buffer(Metadata& meta);
	void optimize_scratch_buffer_contiguous(Metadata& meta);
	void relocate_ctrl_pkt_patch_info(Metadata& meta, std::string& binfile_path, std::string& prebuilt_bin_dir, bool elf_flow, const json& tilings_data, bool use_inmem);
	void generate_pdi_partitions_pass(Metadata& meta, bool eager_mode);
	Metadata insert_record_timer_nodes(const Metadata& meta, uint32_t profile_level);
	Metadata insert_preemption_nodes(const Metadata& meta);
	Metadata insert_pm_load_nodes(const Metadata& meta);
	Metadata remove_identity_ops(const Metadata& meta);
	Metadata remove_concat_runtime_ops(const Metadata& meta);
	Metadata remove_split_runtime_ops(const Metadata& meta);
	Metadata remove_gather_runtime_ops(const Metadata& meta);
	Metadata remove_slice_runtime_ops(const Metadata& meta);
}
