#pragma once
namespace waic_runner {
    enum Support_OpType {
        NPUOP,
        IDENTITY,
        RECORDTIME,
        PREEMPTION,
        PMLOAD
    };
    const std::vector<uint8_t> timer_get_transaction_bin(
        std::vector<Tensor>& input, std::vector<Tensor>& output,
        const std::map<std::string, std::any>& attr);

    const std::vector<uint8_t> preemption_get_transaction_bin(
        std::vector<Tensor>& input, std::vector<Tensor>& output,
        const std::map<std::string, std::any>& attr);

    const std::vector<uint8_t> pm_load_get_transaction_bin(
        std::vector<Tensor>& input, std::vector<Tensor>& output,
        const std::map<std::string, std::any>& attr,
        const std::string& bin_path, bool verbose);

    const std::vector<uint8_t> identity_get_transaction_bin(
        std::vector<Tensor>& input, std::vector<Tensor>& output,
        const std::map<std::string, std::any>& attr);
}
