#pragma once

#include "op_common.hpp"
#include <xaiengine.h>
namespace waic_runner {
    class txn_util {
    public:
        //enum device_t {
        //    RYZENAI_PHX = XAIE_DEV_GEN_AIE2IPU,
        //    RYZENAI_STX = XAIE_DEV_GEN_AIE2P,
        //};
        txn_util() = default;
        txn_util(const std::vector<uint8_t>& txn_vec);
        /*std::string summarize();
        std::string text_dump();
        static std::vector<uint8_t>
            patch(const std::vector<uint8_t>& txn,
                const std::vector<OpArgMap>& source_args_map,
                const std::vector<OpArgMap>& dest_args_map);
        static std::vector<uint8_t> patch(const std::vector<uint8_t>& txn,
            const std::vector<OpArgMap>& args_map);*/
        void patch(const Metadata::OpInfo& op_info,
            const Metadata& meta,
            const std::vector<OpArgMap>& args_map);
        std::vector<uint8_t> to_vector();
        static std::vector<uint8_t>
            fuse_txns(const std::vector<std::vector<uint8_t>>& txns);
        static void pass_through(uint8_t** ptr);

        std::vector<uint8_t> txn;
        //std::string get_all_ops();

    private:
        std::stringstream ss_hdr_;
        std::stringstream ss_ops_;
        std::stringstream ss_summary_;
        uint64_t txn_size_;
        uint64_t num_txn_ops_;
        uint64_t fused_size_;
        uint64_t fused_ops_;

        uint32_t num_w_ops = 0;
        uint32_t num_bw_ops = 0;
        uint32_t num_mw_ops = 0;
        uint32_t num_mp_ops = 0;
        uint32_t num_mpbusy_ops = 0;
        uint32_t num_tct_ops = 0;
        uint32_t num_patch_ops = 0;
        uint32_t num_read_ops = 0;
        uint32_t num_readtimer_ops = 0;
        uint32_t num_mergesync_ops = 0;

        void stringify_txn_ops();
        void stringify_w32(uint8_t** ptr);
        void stringify_bw32(uint8_t** ptr);
        void stringify_mw32(uint8_t** ptr);
        void stringify_mp32(uint8_t** ptr);
        void stringify_mpbusy32(uint8_t** ptr);
        void stringify_tct(uint8_t** ptr);
        void stringify_patchop(uint8_t** ptr);
        void stringify_rdreg(uint8_t** ptr);
        void stringify_rectimer(uint8_t** ptr);
        void stringify_mergesync(uint8_t** ptr);
        void stringify_txn_bin();
        void prepare_summary();
    };

    class transaction_op {
    public:
        /**
         * @brief create txn op created by aie_controller locally.
         * Format :
         *     | TRANSACTION_OP | SIZE | txn |
         */
        transaction_op(const std::vector<uint8_t>& txn);
        std::vector<uint8_t> get_txn_op();
        size_t get_txn_instr_size();

        static size_t getInstrBufSize(const std::string& txn_str);

        // size of txn op header in bytes
        // this is the wrapper header around txn format supported by aie-rt
        constexpr static size_t TXN_OP_SIZE = 8;
        constexpr static uint32_t TXN_OP_CODE = 0;

    private:
        std::vector<uint8_t> txn_op_;
    };
}